<?php
/**
 * Eco Store Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package eco_store
 */

if( ! function_exists( 'eco_store_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function eco_store_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');
    

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'eco-store' );
    }
	
    /* Option list of all post */	
    $eco_store_options_posts = array();
    $eco_store_options_posts_obj = get_posts('posts_per_page=-1');
    $eco_store_options_posts[''] = esc_html__( 'Choose Post', 'eco-store' );
    foreach ( $eco_store_options_posts_obj as $eco_store_posts ) {
    	$eco_store_options_posts[$eco_store_posts->ID] = $eco_store_posts->post_title;
    }
    
    /* Option list of all categories */
    $eco_store_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $eco_store_option_categories = array();
    $eco_store_category_lists = get_categories( $eco_store_args );
    $eco_store_option_categories[''] = esc_html__( 'Choose Category', 'eco-store' );
    foreach( $eco_store_category_lists as $eco_store_category ){
        $eco_store_option_categories[$eco_store_category->term_id] = $eco_store_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'eco-store' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'eco-store' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'eco_store_header_site_title', 
        array(
            'default'           => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'eco-store' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'eco_store_header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'eco-store' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('eco_store_logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('eco_store_logo_width', array(
        'label' => __('Logo Width', 'eco-store'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'eco_store_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'eco_store_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'eco-store' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'eco_store_post_settings',
         array(
            'priority' => 11,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'eco-store' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'eco-store' ),
        ) 
    );

    /** Responsive Media Ends */

     //Global Color
    $wp_customize->add_section(
        'eco_store_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'eco-store' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_general_settings',
        )
    );

    $wp_customize->add_setting('eco_store_primary_color', array(
        'default'           => '#2A7D2E',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'eco_store_primary_color', array(
        'label'    => __('Theme Primary Color', 'eco-store'),
        'section'  => 'eco_store_global_color',
        'settings' => 'eco_store_primary_color',
    )));    

    $wp_customize->add_setting('eco_store_second_color', array(
        'default'           => '#0B3D2C',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'eco_store_second_color', array(
        'label'    => __('Theme Secondary Color', 'eco-store'),
        'section'  => 'eco_store_global_color',
        'settings' => 'eco_store_second_color',
    )));

    $wp_customize->add_setting('eco_store_tertiary_color', array(
        'default'           => '#E1FFE1',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'eco_store_tertiary_color', array(
        'label'    => __('Theme Tertiary Color', 'eco-store'),
        'section'  => 'eco_store_global_color',
        'settings' => 'eco_store_tertiary_color',
    )));

    /** Post Layouts */
    
    $wp_customize->add_section(
        'eco_store_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'eco-store' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_post_settings',
        )
    );

    $wp_customize->add_setting('eco_store_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'eco_store_sanitize_post_layout',
    ));

    $wp_customize->add_control('eco_store_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'eco-store'),
        'section'  => 'eco_store_post_layout_section',
        'settings' => 'eco_store_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'eco-store'),
            'right-sidebar'   => __('Right Sidebar', 'eco-store'),
            'left-sidebar'   => __('Left Sidebar', 'eco-store'),
            'three-column'   => __('Three Columns', 'eco-store'),
            'four-column'   => __('Four Columns', 'eco-store'),
        ),
    ));

    /** Post Layouts Ends */
     
    /** Post Settings */
    $wp_customize->add_section(
        'eco_store_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'eco-store' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'eco_store_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'eco-store' ),
            'section'     => 'eco_store_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'eco_store_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'eco-store' ),
            'section'     => 'eco_store_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'eco_store_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'eco-store' ),
            'section'     => 'eco_store_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'eco_store_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'eco-store' ),
            'section'     => 'eco_store_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post ReadMore control */
    $wp_customize->add_setting( 'eco_store_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'eco_store_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'eco_store_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'eco_store_post_settings', 
        'label'       => __( 'Display Read More Button', 'eco-store' ),
    ) );

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'eco_store_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'eco-store' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'eco_store_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'eco-store' ),
            'section'     => 'eco_store_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'eco_store_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'eco-store' ),
            'section'     => 'eco_store_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

    // Typography Settings Section
    $wp_customize->add_section('eco_store_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'eco-store'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'eco_store_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'eco-store'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('eco_store_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'eco_store_sanitize_choicess',
    ));
    $wp_customize->add_control('eco_store_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'eco-store'),
        'section' => 'eco_store_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('eco_store_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'eco_store_sanitize_choicess',
    ));
    $wp_customize->add_control('eco_store_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'eco-store'),
        'section' => 'eco_store_typography_settings',
    ));

    /** Typography Settings Section End */

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'eco_store_general_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'eco-store' ),
            'description' => esc_html__( 'Customize General Settings', 'eco-store' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'eco_store_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_general_settings',
        )
    );

    $wp_customize->add_setting( 
        'eco_store_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'eco-store' ),
            'section'     => 'eco_store_general_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('eco_store_loader_layout_setting', array(
        'default' => 'load',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    // Add control for loader layout
    $wp_customize->add_control('eco_store_loader_layout_control', array(
        'label' => __('Preloader Layout', 'eco-store'),
        'section' => 'eco_store_general_settings',
        'settings' => 'eco_store_loader_layout_setting',
        'type' => 'select',
        'choices' => array(
            'load' => __('Preloader 1', 'eco-store'),
            'load-one' => __('Preloader 2', 'eco-store'),
            'ctn-preloader' => __('Preloader 3', 'eco-store'),
        ),
    ));

    /** Header Section Settings */
    $wp_customize->add_section(
        'eco_store_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_home_page_settings',
        )
    );

    $wp_customize->add_setting( 
        'eco_store_show_hide_search', 
        array(
            'default' => false ,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_show_hide_search',
        array(
            'label'       => __( 'Show Search Icon', 'eco-store' ),
            'section'     => 'eco_store_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('eco_store_search_icon',array(
        'default'   => 'fas fa-search',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control(new Eco_Store_Changeable_Icon(
        $wp_customize,'eco_store_search_icon',array(
        'label' => __('Search Icon','eco-store'),
        'transport' => 'refresh',
        'section'   => 'eco_store_header_section_settings',
        'type'      => 'icon'
    )));

    /** Sticky Header control */
    $wp_customize->add_setting( 
        'eco_store_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'eco-store' ),
            'section'     => 'eco_store_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'eco_store_menu_font_weight', array(
        'default'           => '400',
        'sanitize_callback' => 'eco_store_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'eco_store_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'eco-store' ),
        'section'  => 'eco_store_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'eco-store' ),
            '200' => __( '200 - Extra Light', 'eco-store' ),
            '300' => __( '300 - Light', 'eco-store' ),
            '400' => __( '400 - Normal', 'eco-store' ),
            '500' => __( '500 - Medium', 'eco-store' ),
            '600' => __( '600 - Semi Bold', 'eco-store' ),
            '700' => __( '700 - Bold', 'eco-store' ),
            '800' => __( '800 - Extra Bold', 'eco-store' ),
            '900' => __( '900 - Black', 'eco-store' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'eco_store_menu_text_transform', array(
        'default'           => 'Capitalize',
        'sanitize_callback' => 'eco_store_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'eco_store_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'eco-store' ),
        'section'  => 'eco_store_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'eco-store' ),
            'capitalize' => __( 'Capitalize', 'eco-store' ),
            'uppercase'  => __( 'Uppercase', 'eco-store' ),
            'lowercase'  => __( 'Lowercase', 'eco-store' ),
        ),
    ) );

    $wp_customize->add_setting('eco_store_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'eco_store_sanitize_choices'
	));
	$wp_customize->add_control('eco_store_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','eco-store'),
		'section' => 'eco_store_header_section_settings',
		'choices' => array(
         'None' => __('None','eco-store'),
         'Zoom In' => __('Zoom In','eco-store'),
      ),
	));

    /** Social Section Settings */
    $wp_customize->add_section(
        'eco_store_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_home_page_settings',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'eco_store_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'eco-store' ),
            'section'     => 'eco_store_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'eco_store_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'eco-store' ),
            'section' => 'eco_store_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'eco_store_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_social_link_2',
        array(
            'label' => esc_html__( 'Add Youtube Link', 'eco-store' ),
            'section' => 'eco_store_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'eco_store_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'eco-store' ),
            'section' => 'eco_store_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'eco_store_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_social_link_4',
        array(
            'label' => esc_html__( 'Add Snap Link', 'eco-store' ),
            'section' => 'eco_store_social_section_settings',
            'type' => 'url',
        )
    );

    /** Social Section Settings End */

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'eco_store_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'eco-store' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'eco-store' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'eco_store_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'eco_store_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'eco-store' ),
            'section'     => 'eco_store_slider_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Text
    $wp_customize->add_setting('eco_store_slider_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('eco_store_slider_text_extra', 
        array(
        'label'       => __('Slider Extra Title', 'eco-store'),
        'section'     => 'eco_store_slider_section_settings',   
        'settings'    => 'eco_store_slider_text_extra',
        'type'        => 'text'
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $eco_store_i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($eco_store_i==0){
            $default = $category->slug;
            $eco_store_i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'eco_store_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'eco_store_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'eco_store_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slides','eco-store'),
            'section' => 'eco_store_slider_section_settings',
        )
    );

    /** Contact Us Section Settings */
    $wp_customize->add_section(
        'eco_store_contact_us_section_settings',
        array(
            'title' => esc_html__( 'Contact Us Section Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_home_page_settings',
        )
    );

    /** Contact Section control */
    $wp_customize->add_setting( 
        'eco_store_contact_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_contact_setting',
        array(
            'label'       => __( 'Show Contact', 'eco-store' ),
            'section'     => 'eco_store_contact_us_section_settings',
            'type'        => 'checkbox',
        )
    );

    /** Email */
    $wp_customize->add_setting(
        'eco_store_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'eco-store' ),
            'section' => 'eco_store_contact_us_section_settings',
            'type' => 'text',
        )
    );

    /** Address */
    $wp_customize->add_setting(
        'eco_store_address',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_address',
        array(
            'label' => esc_html__( 'Add Address', 'eco-store' ),
            'section' => 'eco_store_contact_us_section_settings',
            'type' => 'text',
        )
    );

    /** Phone */
    $wp_customize->add_setting(
        'eco_store_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'eco_store_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'eco-store' ),
            'section' => 'eco_store_contact_us_section_settings',
            'type' => 'text',
        )
    );

    /** Classes Section Settings */
    $wp_customize->add_section(
        'eco_store_classes_section_settings',
        array(
            'title' => esc_html__( 'Services Section Settings', 'eco-store' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'eco_store_home_page_settings',
        )
    );

    /** Classes Section control */
    $wp_customize->add_setting( 
        'eco_store_classes_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_classes_setting',
        array(
            'label'       => __( 'Show Services Section', 'eco-store' ),
            'section'     => 'eco_store_classes_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'eco_store_service_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'eco_store_service_title', 
        array(
            'label'       => __('Section Title', 'eco-store'),
            'section'     => 'eco_store_classes_section_settings',
            'settings'    => 'eco_store_service_title',
            'type'        => 'text'
        )
    );

     // Section Text
    $wp_customize->add_setting(
        'eco_store_service_text', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'eco_store_service_text', 
        array(
            'label'       => __('Section Text', 'eco-store'),
            'section'     => 'eco_store_classes_section_settings',
            'settings'    => 'eco_store_service_text',
            'type'        => 'text'
        )
    );

    // Get all post categories for dropdown
    $categories = get_categories();
    $cat_posts = array();
    $cat_posts['select'] = __('Select', 'eco-store');

    foreach ($categories as $category) {
        $cat_posts[$category->slug] = $category->name;
    }

    // Category selection setting in Customizer
    $wp_customize->add_setting(
        'eco_store_blog_args_',
        array(
            'default'           => 'select',
            'sanitize_callback' => 'eco_store_sanitize_choices',
        )
    );

    $wp_customize->add_control(
        'eco_store_blog_args_',
        array(
            'type'     => 'select',
            'choices'  => $cat_posts,
            'label'    => __('Select Category to Display Services', 'eco-store'),
            'section'  => 'eco_store_classes_section_settings',
        )
    );

    for ($i=1; $i <= 10; $i++) {

        $wp_customize->add_setting('eco_store_category_icon'.$i,array(
            'default'   => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control(new Eco_Store_Changeable_Icon(
            $wp_customize,'eco_store_category_icon'.$i,array(
            'label' => __('Feature Icon ','eco-store').$i,
            'transport' => 'refresh',
            'section'   => 'eco_store_classes_section_settings',
            'type'      => 'icon'
        )));
    }
   
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'eco_store_footer_section',
        array(
            'title' => __( 'Footer Settings', 'eco-store' ),
            'priority' => 70,
            'panel' => 'eco_store_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('eco_store_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'eco_store_sanitize_choices',
    ));

    $wp_customize->add_control('eco_store_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'eco-store'),
        'section'  => 'eco_store_footer_section',
        'settings' => 'eco_store_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'eco-store'),
		   '2'     => __('Two', 'eco-store'),
		   '3'     => __('Three', 'eco-store'),
		   '4'     => __('Four', 'eco-store')
        ),
    ));

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'eco_store_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'eco_store_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'eco_store_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'eco-store' ),
            'section'     => 'eco_store_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'eco_store_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'eco_store_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'eco-store' ),
            'section' => 'eco_store_footer_section',
            'type' => 'text',
        )
    );  
    $wp_customize->add_setting('eco_store_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'eco_store_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'eco-store'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'eco-store'), 1024, 800),
                'section' => 'eco_store_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attatchment */
    $wp_customize->add_setting('eco_store_background_attatchment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'eco_store_sanitize_choices',
    ));

    $wp_customize->add_control('eco_store_background_attatchment', array(
        'label'    => __('Footer Background Attatchment', 'eco-store'),
        'section'  => 'eco_store_footer_section',
        'settings' => 'eco_store_background_attatchment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','eco-store'),
            'scroll' => __('scroll','eco-store'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'eco_store_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'eco_store_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'eco-store'),
                'section' => 'eco_store_footer_section',
                'type' => 'color',
            )
        )
    );

     $wp_customize->add_setting('eco_store_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Eco_Store_Changeable_Icon(
        $wp_customize,'eco_store_scroll_icon',array(
        'label' => __('Scroll Top Icon','eco-store'),
        'transport' => 'refresh',
        'section'   => 'eco_store_footer_section',
        'type'      => 'icon'
    )));

    /** Scroll to top button shape */
    $wp_customize->add_setting('eco_store_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'eco_store_sanitize_choices',
    ));

    $wp_customize->add_control('eco_store_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'eco-store'),
        'section'  => 'eco_store_footer_section',
        'settings' => 'eco_store_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'eco-store' ),
            'curved-box' => __( 'Curved Box', 'eco-store' ),
            'circle'     => __( 'Circle', 'eco-store' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'eco_store_404_section',
        array(
            'title' => __( '404 Page Settings', 'eco-store' ),
            'priority' => 70,
            'panel' => 'eco_store_general_settings',
        )
    );
   
    $wp_customize->add_setting('eco_store_404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'eco_store_404_page_image', array(
        'label' => __('404 Page Image', 'eco-store'),
        'section' => 'eco_store_404_section',
        'settings' => 'eco_store_404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'eco-store'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'eco-store'),
        'section' => 'eco_store_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'eco-store'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'eco-store'),
        'section' => 'eco_store_404_section',
    ));

}
add_action( 'customize_register', 'eco_store_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function eco_store_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $eco_store_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $eco_store_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'eco_store_customizer', get_template_directory_uri() . '/js' . $eco_store_build . '/customizer' . $eco_store_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'eco_store_customize_preview_js' );