<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package echohealth
 */

$echohealth_single_post_thumb_class = 'no-single-post-thumb';
if (has_post_thumbnail()) :
	$echohealth_single_post_thumb_class = '';
endif;
?>
<div class="blog-listing-single-item-one <?php echo esc_attr( $echohealth_single_post_thumb_class ); ?>" data-wow-delay="0ms" data-wow-duration="1500ms">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="blog-listing-single-item-content">
			<div class="blog-listing-single-item-editor">
				<?php the_content(); ?>
			</div>
			<?php
				wp_link_pages(array(
					'before' => '<div class="blog-listing-single-item-page-links">',
					'after' => '</div>',
				));
			?>
		</div>
	</article>
</div>