<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package echohealth
 */
?>
<section class="no-results-found-area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="no-results-found">
					<?php
						if ( is_home() && current_user_can( 'publish_posts' ) ) :
							printf(
								'<p>' . wp_kses(
									__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'echo-health' ),
									array(
										'a' => array(
											'href' => array(),
										),
									)
								) . '</p>',
								esc_url( admin_url( 'post-new.php' ) )
							);
						elseif ( is_search() ) :
							?>
							<p class="no-found-text"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'echo-health' ); ?></p>
								<div class="nothing-found-search">
									<?php
										get_search_form();
									?>
								</div>
							<?php
						else :
							?>
							<p class="no-found-text"><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'echo-health' ); ?></p>
								<div class="nothing-found-search">
								<?php
									get_search_form();
								?>
								</div>
							<?php
						endif;
					?>
				</div>
			</div>
		</div>
	</div>
</section>
