<?php
	$echohealth_post_thumb_class = 'no-post-thumb';
	if (has_post_thumbnail()) :
		$echohealth_post_thumb_class = '';
	endif;

	$is_sticky_class = '';
	if (is_sticky()) :
		$is_sticky_class = 'kitbug-sticky-post-area';
	endif;
?>

	<div class="blog-listing-single-item-one <?php echo esc_attr( $echohealth_post_thumb_class . ' ' . $is_sticky_class ); ?>" data-wow-delay="0ms" data-wow-duration="1500ms">
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?php if (has_post_thumbnail()) : ?>
				<div class="blog-listing-single-item-thumbnail">
					<?php echohealth_post_thumbnail(); ?>
					<div class="post-date">
						<svg version="1.1" 
							viewBox="0 0 20 20" enable-background="new 0 0 20 20" xml:space="preserve">
						<path d="M17,3h-1v2h-3V3H7v2H4V3H3C1.899,3,1,3.9,1,5v12c0,1.1,0.899,2,2,2h14c1.1,0,2-0.9,2-2V5C19,3.9,18.1,3,17,3
							z M17,17H3V9h14V17z M6.5,1h-2v3.5h2V1z M15.5,1h-2v3.5h2V1z"/>
						</svg>
						<p><?php echohealth_posted_on(); ?></p>
					</div>
				</div>
			<?php endif; ?>
			<div class="blog-listing-single-item-content">
				<?php
					if (is_sticky()) {
						echo '<div class="sticky-post-icon" title="' . esc_attr__('Sticky Post', 'echo-health') . '"><svg viewBox="0 0 20 20" enable-background="new 0 0 20 20" xml:space="preserve"> <path d="M4.774,15.287l-2.105,3.25L2.893,19.6l1.06-0.227l2.104-3.248c-0.224-0.12-0.446-0.248-0.661-0.39 C5.178,15.594,4.97,15.443,4.774,15.287z M13.686,14.152c0.014-0.029,0.023-0.061,0.036-0.092c0.053-0.117,0.1-0.234,0.138-0.357
	c0.006-0.022,0.009-0.044,0.016-0.064c0.039-0.136,0.072-0.27,0.098-0.408c0-0.007,0-0.012,0-0.021 c0.195-1.169-0.145-2.473-0.923-3.651l1.11-1.714c1.279,0.163,2.385-0.159,2.917-0.982c0.923-1.423-0.2-3.792-2.505-5.293 C12.266,0.068,9.65,0.005,8.729,1.426C8.195,2.25,8.351,3.393,9.022,4.499L7.91,6.213C6.521,5.98,5.194,6.197,4.207,6.853 C4.201,6.855,4.194,6.857,4.19,6.861C4.075,6.939,3.963,7.025,3.858,7.115C3.841,7.129,3.821,7.142,3.807,7.156 C3.709,7.24,3.621,7.334,3.536,7.428c-0.02,0.024-0.048,0.045-0.067,0.07c-0.106,0.121-0.204,0.249-0.29,0.385 c-1.384,2.133-0.203,5.361,2.633,7.209c2.838,1.848,6.26,1.614,7.641-0.519C13.54,14.438,13.62,14.297,13.686,14.152z M12.871,4.194 c-0.887-0.577-1.32-1.487-0.965-2.036c0.354-0.547,1.361-0.522,2.246,0.055c0.889,0.577,1.318,1.489,0.965,2.036 C14.764,4.796,13.759,4.771,12.871,4.194z"/></svg></div>';
					}
				?>
				<?php
					if (is_singular()) :
						the_title('<h3 class="blog-listing-single-item-title">', '</h3>');
					else :
						the_title('<h3 class="blog-listing-single-item-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>');
					endif;
				?>
				<ul class="blog-listing-single-item-info">
					<li class="post-by-one">
						<span>
							<?php esc_html_e('By ','echo-health');?>
						</span>
						<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
							<?php echo esc_html( get_the_author() ); ?>
						</a>
					</li>
					<li class="post-comment-one">
						<?php echohealth_comments_count(); ?>
					</li>
					<?php if (!has_post_thumbnail()) : ?>
						<li class="post-on-one"><?php echohealth_posted_on(); ?></li>
					<?php endif; ?>
				</ul>
				
					<div class="blog-listing-single-item-excerpt">
						<?php
							if (get_option('rss_use_excerpt')) {
								the_excerpt();
							} else {
								the_excerpt();
							}
						?>
					</div>
				<?php
					wp_link_pages(array(
						'before' => '<div class="blog-listing-single-item-page-links">',
						'after' => '</div>',
					));
				?>
				<div class="blog-listing-single-item-read-more">
					<a href="<?php echo esc_url(get_permalink()); ?>">
						<span>
							<?php esc_html_e('Read More','echo-health');?>
						</span>
						<i class="fas fa-arrow-right"></i>
					</a>
				</div>
			</div>
		</div>
	</div>