<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package echohealth
 */

get_header();
    if (is_active_sidebar('sidebar-1')) :
        $echohealth_blog_post_list_class = 'col-lg-8';
    else :
        $echohealth_blog_post_list_class = 'col-lg-12';
    endif;
?>
	<section  id="content-start" class="blog-listing-area-one" id="content-start">
		<div class="container">
			<div class="row">
				<div class="<?php echo esc_attr($echohealth_blog_post_list_class); ?> col-md-12 col-sm-12">
					<div class="blog-listing">
						<?php
							if (have_posts()) :
								
								while (have_posts()) :
									the_post();
									get_template_part('template-parts/blog-layout/blog-standard-content');

								endwhile;
							else :
								get_template_part('template-parts/content', 'none');
							endif;
						?>
					</div>
					<?php if(get_the_posts_pagination()) : ?>
						<div class="pagination-box col-md-12">
							<?php
								the_posts_pagination(array(
									'mid_size' => 2,
									'prev_text' => '<span class="fa fa-angle-left"></span>',
                                	'next_text' => '<span class="fa fa-angle-right"></span>'
								));
							?>
						</div>
					<?php endif; ?>
				</div>
				<?php if (is_active_sidebar('sidebar-1')) { ?>
					<div class="col-lg-4 col-md-12 col-sm-12">
						<aside class="blog-sidebar-one">
							<?php get_sidebar(); ?>
						</aside>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
<?php
get_footer();
