<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package echohealth
 */

if ( ! function_exists( 'echohealth_posted_on' ) ) :
	function echohealth_posted_on() {
		echo '<a href="' . esc_url( get_permalink() ) . '" title="' . esc_attr( get_the_time() ) . '" rel="bookmark">';
		echo '<time class="entry-date published" datetime="' . esc_attr( get_the_date( 'c' ) ) . '" >' . esc_html( get_the_date() ) . '</time>';
		echo '</a>';
	}
endif;

if (!function_exists('echohealth_edit_post_link')) :

    function echohealth_edit_post_link() {
        edit_post_link(
			sprintf(
				wp_kses(
					__( 'Edit <span class="screen-reader-text">%s</span>', 'echo-health' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<div class="echohealth-edit-link">',
			'</div>'
		);
    }
endif;

if (!function_exists('echohealth_category_list')) :

    function echohealth_category_list() {
        if ('post' === get_post_type()) {
            $category_list = get_the_category_list(esc_html__(', ', 'echo-health'));
            if ($category_list) {
                printf($category_list);
            }
        }
    }

endif;

if (!function_exists('echohealth_comments_count')) :
    function echohealth_comments_count() {
        if (get_comments_number(get_the_ID()) == 0) {
            $comments_count = '<a href="' . esc_url(get_permalink()) . '" >' . get_comments_number(get_the_ID()) . " comments" . '</a>';
        }
        elseif (get_comments_number(get_the_ID()) > 1) {
            $comments_count = '<a href="' . esc_url(get_permalink()) . '" >' . get_comments_number(get_the_ID()) . " comments" . '</a>';
        } else {
            $comments_count = '<a href="' . esc_url(get_permalink()) . '#comments" >' . get_comments_number(get_the_ID()) . " comment" . '</a>';
        }
        echo sprintf(esc_html('%s'), $comments_count);
    }
endif;

if ( ! function_exists( 'echohealth_entry_footer' ) ) :
	function echohealth_entry_footer() {
		if ( 'post' === get_post_type() ) {
			$categories_list = get_the_category_list( esc_html__( ', ', 'echo-health' ) );
			if ( $categories_list ) {
				printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'echo-health' ) . '</span>', $categories_list );
			}
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'echo-health' ) );
			if ( $tags_list ) {
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'echo-health' ) . '</span>', $tags_list );
			}
		}
		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'echo-health' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}
		edit_post_link(
			sprintf(
				wp_kses(
					__( 'Edit <span class="screen-reader-text">%s</span>', 'echo-health' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'echohealth_post_thumbnail' ) ) :
	function echohealth_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}
		if ( is_singular() ) :
			?>
			<?php the_post_thumbnail(); ?>
		<?php else : ?>
		<a class="blog-listing-single-item-thumbnail-link" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php
			the_post_thumbnail( 'post-thumbnail', array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
			?>
		</a>
		<?php
		endif;
	}
endif;

if (!function_exists('echohealth_comments')) {
    function echohealth_comments($comment, $args, $depth) {
        extract($args, EXTR_SKIP);
        $args['reply_text'] = esc_html__('Reply', 'echo-health');
        $class = '';
        if ($depth > 1) {
            $class = '';
        }
        if ($depth == 1) {
            $child_html_el = '<ul><li>';
            $child_html_end_el = '</li></ul>';
        }

        if ($depth >= 2) {
            $child_html_el = '<li>';
            $child_html_end_el = '</li>';
        }
        ?>
        <div class="comment-box" id="comment-<?php comment_ID(); ?>">
            <?php if ($comment->comment_type != 'trackback' && $comment->comment_type != 'pingback') { ?>
			<div class="comment ">
			<?php } else { ?>
				<div class="comment yes-ping">
				<?php } ?>
				<?php if ($comment->comment_type != 'trackback' && $comment->comment_type != 'pingback') { ?>
					<div class="author-thumb">
						<figure class="thumb">
							<?php print get_avatar($comment, 80, null, null, array('class' => array())); ?>
						</figure>
					</div>
				<?php } ?>
				<h4 class="name"><?php echo get_comment_author_link(); ?></h4>
				<div class="date"><?php echo get_the_date(); ?></div>
				<div class="text">
					<?php comment_text(); ?>
				</div>
					<?php 
						$replyBtn = 'reply-btn';
						echo preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $replyBtn, 
							get_comment_reply_link(array_merge( $args, array(
								'reply_text' => esc_html__('Reply', 'echo-health'),
								'depth' => $depth,
								'max_depth' => $args['max_depth']))), 1 
						); 
					?>
			</div>
			
		<?php
	}
}