<?php
class echohealth_Style {
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_style' ), 99 );
		add_action( 'enqueue_block_editor_assets', array( $this, 'echohealth_block_editor_styles' ), 20 );
	}
	public function enqueue_style() {
		wp_enqueue_style( 'fontawesome', echohealth_CSS_URL . 'fontawesome.css', false, time() );
		wp_enqueue_style( 'bootstrap', echohealth_CSS_URL . 'bootstrap.css', false, time() );
		wp_enqueue_style( 'echohealth-design', echohealth_CSS_URL . 'echohealth-design.css', false, time() );
		wp_enqueue_style( 'echohealth-style', get_stylesheet_uri(), null, time() );
		wp_enqueue_style( 'echohealth-theme', echohealth_CSS_URL . 'echohealth-theme.css', false, time() );
		if (function_exists( 'echohealth_daynamic_styles' )) {
			wp_add_inline_style( 'echohealth-theme', echohealth_daynamic_styles() );
		}
	}
	public function echohealth_block_editor_styles() {
		wp_enqueue_style('echohealth-block-styles', echohealth_CSS_URL . 'all-block.css', false, time() );
	}
}
$echohealth_style = new echohealth_Style();
