<?php
class echohealth_Scripts {
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'echohealth_enqueue_scripts' ) );
		add_action( 'customize_preview_init', array( $this, 'echohealth_customize_scripts' ) );
	}
	public function echohealth_enqueue_scripts() {
		wp_enqueue_script( 'echohealth-touch-navigation', echohealth_JS_URL . 'touch-keyboard-navigation.js', array( 'jquery' ), time(), true );
		wp_enqueue_script( 'echohealth-touch-navigation-m', echohealth_JS_URL . 'touch-keyboard-navigation-mobile.js', array( 'jquery' ), time(), true );
		wp_enqueue_script( 'echohealth-skip-link-focus-fix', echohealth_JS_URL . 'skip-link-focus-fix.js', array( 'jquery' ), time(), true );
		wp_enqueue_script( 'echohealth-main', echohealth_JS_URL . 'echohealth-main.js', array( 'jquery' ), time(), true );
		wp_enqueue_script( 'echohealth-script', echohealth_JS_URL . 'echohealth-script.js', array( 'jquery' ), time(), true );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	public function echohealth_customize_scripts() {
		wp_enqueue_script( 'echohealth-customizer', echohealth_JS_URL . 'customizer.js', array( 'customize-preview' ), time(), true );
	}
}
$echohealth_scripts = new echohealth_Scripts();
