<?php

/**
 * ReduxFramework Barebones Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */
if (!class_exists('Redux')) {
    return;
}

// This is your option name where all the Redux data is stored.
$echohealth_opt_prefix = 'echohealth_';
$echohealth_opt_name = "echohealth_options";
/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$echohealth_theme = wp_get_theme('echo-health'); // For use with some settings. Not necessary.

$echohealth_args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $echohealth_opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $echohealth_theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $echohealth_theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Echo Health Option', 'echo-health'),
    'page_title' => esc_html__('Echo Health Option', 'echo-health'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar' => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-portfolio',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the echohealth_opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    // OPTIONAL -> Give you extra features
    'page_priority' => 65,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => '',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '_options',
    // Page slug used to denote the panel
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.
    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    'footer_credit'     => esc_html__( 'echohealth - Personal Multipurpose Template. echohealth is made to be used for business, corporate, creative agencies, and personal websites.', 'echo-health' ),                 // Disable the footer credit of Redux. Please leave if you can help it.
    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
    //'compiler'             => true,   
);
$echohealth_args['admin_bar_links'][] = array(
    'id'    => 'echohealth-docs',
    'href'  => 'http://kitbug.com/documentation/echohealth',
    'title' => esc_html__( 'Edict Lite Documentation', 'echo-health' ),
);
$echohealth_args['admin_bar_links'][] = array(
    'id'    => 'echohealth-support',
    'href'  => 'http://kitbug.com/support',
    'title' => esc_html__( 'Edict Lite Support', 'echo-health' ),
);
$echohealth_args['share_icons'][] = array(
    'url'   => 'https://www.facebook.com/kitbugio',
    'title' => esc_html__( 'Like us on Facebook','echo-health'),
    'icon'  => 'el el-facebook'
);
$echohealth_args['share_icons'][] = array(
    'url'   => 'https://twitter.com/kitbugio',
    'title' => esc_html__( 'Follow us on Twitter','echo-health'),
    'icon'  => 'el el-twitter'
);
$echohealth_args['share_icons'][] = array(
    'url'   => 'https://www.youtube.com/c/jremb',
    'title' => esc_html__( 'Subscribe Us on YouTube','echo-health'),
    'icon'  => 'el el-youtube'
);
Redux::setArgs($echohealth_opt_name, $echohealth_args);
Redux::setSection($echohealth_opt_name, array(
    'title' => esc_html__('Base theme option', 'echo-health'),
    'id' => 'base_theme_option',
    'desc' => esc_html__('Chnage Base theme option here', 'echo-health'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id' => $echohealth_opt_prefix . 'preloader_on_off',
            'type' => 'switch',
            'title' => esc_html__('Preloader on off switch', 'echo-health'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'echo-health'),
            'off' => esc_html__('Disable', 'echo-health'),
        ),
        array(
            'id' => $echohealth_opt_prefix . 'back_to_top_on_off',
            'type' => 'switch',
            'title' => esc_html__('Back To Top on off switch', 'echo-health'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'echo-health'),
            'off' => esc_html__('Disable', 'echo-health'),
        ),
    )
));
Redux::setSection($echohealth_opt_name, array(
    'title' => esc_html__('Header option', 'echo-health'),
    'id' => 'header_option',
    'desc' => esc_html__('Header option here', 'echo-health'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $echohealth_opt_prefix . 'header_style',
            'type'     => 'select',
            'title'    => esc_html__('Header style', 'echo-health'), 
            'options'  => array(
                '1' => esc_html__('Header style one', 'echo-health'),
                '2' => esc_html__('Header style two', 'echo-health'),
            ),
            'default'  => false,
        ),
        array(
            'id' => $echohealth_opt_prefix . 'menu_info_button',
            'type' => 'ace_editor',
            'title' => esc_html__('Menu info button', 'echo-health'),
            'subtitle' => esc_html__( 'A tag style, class use: btn-2, visit: ', 'echo-health' ),
        ),
        array(
            'id'       => $echohealth_opt_prefix . 'mobile_menu_logo',
            'type'     => 'media', 
            'url'      => true,
            'title'    => esc_html__('Mobile Menu logo', 'echo-health'),
        ),
    )
));
Redux::setSection($echohealth_opt_name, array(
    'subsection' => true,
    'title' => esc_html__('Header Top Bar option', 'echo-health'),
    'id' => 'header_top_bar',
    'desc' => esc_html__('Chnage Header Top Bar here', 'echo-health'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id' => $echohealth_opt_prefix . 'top_bar_link',
            'type' => 'ace_editor',
            'title' => esc_html__('Top bar info link ', 'echo-health'),
        ),
        array(
            'id' => $echohealth_opt_prefix . 'top_bar_social_icon',
            'type' => 'ace_editor',
            'title' => esc_html__('Social icon', 'echo-health'),
        ),
    )
));
Redux::setSection($echohealth_opt_name, array(
    'title' => esc_html__('Breadcrumb area', 'echo-health'),
    'id' => 'breadcrumb_area',
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $echohealth_opt_prefix . 'blog_breadcrumb_style',
            'type'     => 'select',
            'title'    => esc_html__('Breadcrumb style', 'echo-health'), 
            'options'  => array(
                '1' => esc_html__('Breadcrumb style one', 'echo-health'),
                '2' => esc_html__('Breadcrumb style two', 'echo-health'),
            ),
            'default'  => false,
        ),
        array(
            'id' => $echohealth_opt_prefix . 'blog_breadcrumb_switch',
            'type' => 'switch',
            'title' => esc_html__('Blog breadcrumb on off switch', 'echo-health'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'echo-health'),
            'off' => esc_html__('Disable', 'echo-health'),
        ),
        array(
            'required' => array( $echohealth_opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
            'id'       => $echohealth_opt_prefix . 'blog_breadcrumb_bg',
            'type'     => 'background', 
            'url'      => true,
            'title'    => esc_html__('Blog breadcrumb background', 'echo-health'),
            'output'    => array(
                'background' => '.blog-breadcrumb', 
            )
        ),
        array(
            'required' => array( $echohealth_opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
            'id' => $echohealth_opt_prefix . 'blog_breadcrumb_content',
            'type' => 'text',
            'title' => esc_html__('Blog breadcrumb title', 'echo-health'),
            'default' => esc_html__('OUR NEWS', 'echo-health'),
        ),
        array(
            'id' => $echohealth_opt_prefix . 'blog_single_breadcrumb_switch',
            'type' => 'switch',
            'title' => esc_html__('Blog Single breadcrumb on off switch', 'echo-health'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'echo-health'),
            'off' => esc_html__('Disable', 'echo-health'),
        ),
        array(
            'required' => array( $echohealth_opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
            'id'       => $echohealth_opt_prefix . 'blog_single_breadcrumb_bg',
            'type'     => 'background', 
            'url'      => true,
            'title'    => esc_html__('Blog Single breadcrumb background', 'echo-health'),
            'output'    => array(
                'background' => '.blog-single-breadcrumb', 
            )
        ),
        array(
            'required' => array( $echohealth_opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
            'id' => $echohealth_opt_prefix . 'blog_single_breadcrumb_content',
            'type' => 'text',
            'title' => esc_html__('Blog single breadcrumb title', 'echo-health'),
            'default' => esc_html__('NEWS DETAILS', 'echo-health'),
        ),
    )
));
Redux::setSection($echohealth_opt_name, array(
    'title' => esc_html__('Blog Design option', 'echo-health'),
    'id' => 'echohealth_blog_area',
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $echohealth_opt_prefix . 'blog_post_style',
            'type'     => 'select',
            'title'    => esc_html__('Blog style', 'echo-health'), 
            'options'  => array(
                '1' => esc_html__('Blog style one', 'echo-health'),
                '2' => esc_html__('Blog style two', 'echo-health'),
            ),
            'default'  => false,
        ),
    )
));
Redux::setSection($echohealth_opt_name, array(
    'title' => esc_html__('Footer option', 'echo-health'),
    'id' => 'echohealth_footer_area',
    'desc' => esc_html__('Chnage footer option here', 'echo-health'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $echohealth_opt_prefix . 'footer_top_elementor_widget',
            'type'     => 'select',
            'multi' => true,
            'title'    => esc_html__('Footer top Elementor widget', 'echo-health'), 
            'options'  => echohealth_elementor_library(),
        ),
        array(
            'id'       => $echohealth_opt_prefix . 'footer_style',
            'type'     => 'select',
            'title'    => esc_html__('Footer style', 'echo-health'), 
            'options'  => array(
                '1' => esc_html__('Footer style one', 'echo-health'),
                '2' => esc_html__('Footer style two', 'echo-health'),
            ),
            'default'  => false,
        ),
        array(
            'id' => $echohealth_opt_prefix . 'footer_copyright',
            'type' => 'text',
            'title' => esc_html__('Copyright text', 'echo-health'),
        ),
    )
));