<?php
	class echohealth_Int {
		/**
		 * afiq skip link compatibility.
		 */
		public static function echohealth_skip_link() {
			?>
				<a class="skip-link screen-reader-text" href="#content-start"><?php esc_html_e( 'Skip to content', 'echo-health' ); ?></a>
			<?php
		}
		/**
		 * preloader compatibility.
		 */
		public static function echohealth_preloader() {
				$preloader_on_off = echohealth_get_options('preloader_on_off');
			?>
				<?php if($preloader_on_off) : ?>
					<div class="loading">
            <div class="display-table">
                <div class="table-cell">
                    <div class="loading-box">
                        <div class="loader">
                            <div class="wave top-wave">
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                            </div>
                            <div class="wave bottom-wave">
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                                <div></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
				<?php endif; ?>
			<?php
		}
		/**
		 * header logo compatibility.
		 */
		public static function echohealth_header_logo() {
			?>
				<div class="header-one-logo-area">
					<div class="header-one-logo">
					<?php
							if (has_custom_logo()) :
								the_custom_logo();
							endif;
							if (is_front_page() && is_home() && get_bloginfo() ) :
								?>
									<h3 class="kahaf-site-title site-title">
										<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
											<?php bloginfo('name'); ?>
										</a>
									</h3>
								<?php
							else :
								if ( get_bloginfo() ) :
									?>
										<h3 class="kahaf-site-title">
											<a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
										</h3>
									<?php
								endif;
							endif;
							$kahaf_description = get_bloginfo('description', 'display');
							if ($kahaf_description || is_customize_preview()) :
								?>
								<p class="kahaf-site-description site-description"><?php echo esc_html($kahaf_description); ?></p>
								<?php
							endif;
						?>
					</div>
				</div>
			<?php
		}
		/**
		 * header menu compatibility.
		 */
		public static function echohealth_header_menu() {
			?>
				<div class="header-one-menu-area">
					<div class="header-one-menu" id="site-navigation" >
						<button class="header-one-focus"><?php esc_html_e( 'Primary Menu', 'echo-health' ); ?></button>
						<?php
							if ( has_nav_menu( 'primary' ) ) { ?>
								<?php
									wp_nav_menu( array(
										'theme_location' => 'primary',
										'container'       => 'ul',
									) );
								?>
							<?php }else{ ?>
									<?php
										wp_nav_menu( array(
											'container'       => 'ul',
										) );
									?>
								<?php
							}
						?>
					</div>
				</div>
			<?php
		}

		/**
		 * mobile part compatibility.
		 */
		public static function echohealth_mobile_part() {
			?>
				<div class="mobile-header-row-area">
					<div class="mobile-header-bg"></div>
					<div class="mobile-header-row">
						<div class="mobile-logo-area">
							<?php
								if (has_custom_logo()) :
									the_custom_logo();
								endif;
								if (is_front_page() && is_home() && get_bloginfo() ) :
									?>
										<h3 class="kahaf-site-title">
											<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
												<?php bloginfo('name'); ?>
											</a>
										</h3>
									<?php
								else :
									if ( get_bloginfo() ) :
										?>
											<p class="kahaf-site-title">
												<a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
											</p>
										<?php
									endif;
								endif;
								$kahaf_description = get_bloginfo('description', 'display');
								if ($kahaf_description || is_customize_preview()) :
									?>
									<p class="kahaf-site-description"><?php echo esc_html($kahaf_description); ?></p>
									<?php
								endif;
							?>
						</div>
						<div class="mobile-menu">
							<div class="header-one-menu" id="site-navigation1" >
								<button class="header-one-focus"><?php esc_html_e( 'Primary Menu', 'echo-health' ); ?></button>
								<?php
									if ( has_nav_menu( 'primary' ) ) { ?>
										<?php
											wp_nav_menu( array(
												'theme_location' => 'primary',
												'container'       => 'ul',
											) );
										?>
									<?php }else{ ?>
											<?php
												wp_nav_menu( array(
													'container'       => 'ul',
												) );
											?>
										<?php
									}
								?>
							</div>
						</div>
						
					</div>
				</div>
			<?php
		}
		/**
		 * All header and breadcrumb.
		 */
		public static function echohealth_breadcrumb() {
				$breadcrumb_title = 'echo-health';
				$breadcrumb_class = 'breadcrumb_no_bg';
				if ( is_front_page() && is_home() ) :
					$breadcrumb_title = ''; // deafult blog
					$breadcrumb_class = 'deafult-home-breadcrumb';
				elseif ( is_front_page() && !is_home() ) :
					$breadcrumb_title = ''; // custom home or deafult
					$breadcrumb_class = 'custom-home-breadcrumb';
				elseif ( is_home() ) :
					$blog_breadcrumb_switch = echohealth_get_options('blog_breadcrumb_switch');
					if ( $blog_breadcrumb_switch == '1' ) :
						$blog_breadcrumb_content = echohealth_get_options('blog_breadcrumb_content');
						$breadcrumb_title = $blog_breadcrumb_content;
					else :
						$breadcrumb_title = '';
					endif;
					$breadcrumb_class = 'blog-breadcrumb';
				elseif ( is_archive() ) :
					$breadcrumb_title = get_the_archive_title();
					$breadcrumb_class = 'blog-breadcrumb';
				elseif ( is_single() ) :
					$blog_single_breadcrumb_switch = echohealth_get_options('blog_single_breadcrumb_switch');
					if ( $blog_single_breadcrumb_switch == '1' ) :
						if ( get_post_type( get_the_ID() ) && !is_single() ) :
							$breadcrumb_title = get_post_type() . esc_html__(' Details', 'echo-health');
						else :
							$blog_single_breadcrumb_content = echohealth_get_options('blog_single_breadcrumb_content');
							$breadcrumb_title = $blog_single_breadcrumb_content;
						endif;
					else :
						$breadcrumb_title = '';
					endif;
					$breadcrumb_class = 'blog-single-breadcrumb';
				elseif ( is_404() ) :
					$breadcrumb_title = esc_html__('Error Page', 'echo-health');
					$breadcrumb_class = 'blog-breadcrumb';
				elseif ( is_search() ) :
					if ( have_posts() ) :
						$breadcrumb_title = esc_html__('Search Results for: ', 'echo-health') . get_search_query();
						$breadcrumb_class = 'blog-breadcrumb';
					else :
						$breadcrumb_title = esc_html__('Nothing Found', 'echo-health');
						$breadcrumb_class = 'blog-breadcrumb';
					endif;
				elseif ( !is_home() && !is_front_page() && !is_search() && !is_404() ) :
					$breadcrumb_title = get_the_title();
					$breadcrumb_class = 'page-breadcrumb';
				endif;
				$breadcrumb_active_class = 'breadcrumb-not-active';
				if (function_exists('bcn_display')) : 
					$breadcrumb_active_class = '';
				endif;
			?>
			<?php
				$echohealth_show_breadcrumb = get_post_meta(get_the_ID(), 'echohealth_theme_metabox_show_breadcrumb', true);
				$blog_breadcrumb_style = echohealth_get_options('blog_breadcrumb_style');
			?>
			<?php if ($echohealth_show_breadcrumb != 'off') : ?>
				<?php if(isset($breadcrumb_title) && !empty($breadcrumb_title)) : ?>
					<?php if ($blog_breadcrumb_style == '2') : ?>
						<section class="page-header-area breadcrumb-header <?php echo esc_attr($breadcrumb_class . ' ' . $breadcrumb_active_class); ?>">
							<div class="overlay"></div>
							<div class="container">
								<div class="banner">
									<div class="head-info page-header text-center">
										<h1><?php echo wp_kses($breadcrumb_title,'code_contxt'); ?></h1>
										<?php if (function_exists('bcn_display')) : ?>
											<?php bcn_display(); ?>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</section>
					<?php else : ?>
						<section class="page-header-area <?php echo esc_attr($breadcrumb_class . ' ' . $breadcrumb_active_class); ?>">
							<div class="container">
								<div class="row">
									<div class="col-md-12">
										<div class="page-header">
											<h6><?php echo wp_kses($breadcrumb_title,'code_contxt'); ?></h6>
											<?php if (function_exists('bcn_display')) : ?>
												<?php bcn_display(); ?>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</section>
					<?php endif; ?>
				<?php endif; ?>
			<?php endif; ?>
			<?php
		}
		/**
		 * Back To Top
		 */
		public static function echohealth_back_to_top() {
			$back_to_top_on_off = echohealth_get_options('back_to_top_on_off');
		?>
				<?php if($back_to_top_on_off) : ?>
					<button class="scroll-top scroll-to-target" data-target="html">
						<span class="fas fa-angle-up"></span>
					</button>
				<?php endif; ?>
			<?php
		}
		/**
		 * widget area.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
		 */
		public static function echohealth_widgets_init() {
			register_sidebar( array(
				'name'          => esc_html__( 'Blog Sidebar', 'echo-health' ),
				'id'            => 'sidebar-1',
				'description'   => esc_html__( 'Add widgets here.', 'echo-health' ),
				'before_widget' => '<div id="%1$s" class="sidebar-single-widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="sidebar-single-widget-title"><h3>',
				'after_title'   => '</h3></div>',
			) );
		}
		/**
		 * echohealth excerpt tength compatibility.
		 */
		public static function echohealth_excerpt_length( $length ) {
			return 9;
		}
		/**
		 * echohealth query vars compatibility.
		 */
		public static function echohealth_add_query_vars_filter($vars) {
			$vars[] = "blog_style";
			return $vars;
		}
		/**
		 * echohealth elementor comment field compatibility.
		 */
		public static function echohealth_custom_field($fields) {
			$comment_field = $fields['comment'];
			unset($fields['comment']);
			unset($fields['cookies']);
			$fields['comment'] = $comment_field;
			return $fields;
		}
		/**
		 * echohealth google font compatibility.
		 */
		public static function echohealth_google_font() {
			$protocol = is_ssl() ? 'https' : 'http';
			$subsets = 'latin,cyrillic-ext,latin-ext,cyrillic,greek-ext,greek,vietnamese';
			$variants = ':300,400,500,600,700';
			$query_args = array(
				'family' => 'Poppins/Robot' . $variants,
				'family' => 'Poppins' . $variants.'%7CRobot' . $variants,
				'subset' => $subsets,
			);
			$font_url = add_query_arg($query_args, $protocol . "://fonts.googleapis.com/css?display=swap");
			wp_enqueue_style('echohealth-google-fonts', $font_url, array(), NULL);
		}
		/**
		 * echohealth compatibility.
		 */
		public static function echohealth_kses_allowed_html($tags, $context) {
			switch ($context) {
				case 'code_contxt':
					$tags = array(
						'li' => array(
						),
						'span' => array(
							'class' => array()
						),
						'a' => array(
							'class' => array(),
							'href' => array()
						),
						'i' => array(
							'class' => array()
						),
						'br' => array(
							'class' => array()
						),
						'p' => array(),
						'em' => array(),
						'strong' => array()
					);
					return $tags;
				case 'author_avatar':
					$tags = array(
						'img' => array('class' => array(), 'height' => array(), 'width' => array(), 'src' => array(), 'alt' => array())
					);
					return $tags;
				default:
					return $tags;
			}
		}
	}
$echohealth_int = new echohealth_Int();
