<?php
/**
 * echohealth functions and definitions [echohealth]
 * 
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * echohealth
 * @package echohealth  
 */
defined('echohealth_THEME_URI') or define('echohealth_THEME_URI', get_template_directory_uri()); // echohealth
define('echohealth_THEME_DRI', get_template_directory());
define('echohealth_IMG_URL', echohealth_THEME_URI . '/assets/images/');
define('echohealth_CSS_URL', echohealth_THEME_URI . '/assets/css/');
define('echohealth_JS_URL', echohealth_THEME_URI . '/assets/js/');
define('echohealth_FRAMEWORK_DRI', echohealth_THEME_DRI . '/inc/framework/');
require_once echohealth_FRAMEWORK_DRI . 'styles/index.php';
require_once echohealth_FRAMEWORK_DRI . 'styles/daynamic-style.php';
require_once echohealth_FRAMEWORK_DRI . 'scripts/index.php';
require_once echohealth_FRAMEWORK_DRI . 'redux/redux-config.php';
require_once echohealth_FRAMEWORK_DRI . 'meta-box/config-meta-box.php';
require_once echohealth_FRAMEWORK_DRI . "tgm/tgm.php";
require_once echohealth_FRAMEWORK_DRI . "classes/echohealth-int.php";
require_once echohealth_FRAMEWORK_DRI . "classes/echohealth-act.php";
/**
 * Theme option compatibility.
 */
if ( ! function_exists( 'echohealth_get_options' ) ) :
	function echohealth_get_options( $key ) {
		global $echohealth_options;
		$opt_pref = 'echohealth_';
		if ( empty( $echohealth_options ) ) {
			$echohealth_options = get_option( $opt_pref . 'options' );
		}
		$index = $opt_pref . $key;
		if(!isset($echohealth_options[ $index ])) {
			return false;
		}
		return $echohealth_options[ $index ];
	}
endif;
if ( ! function_exists( 'echohealth_setup' ) ) :
	function echohealth_setup() {
		// load theme textdomain
		load_theme_textdomain( 'echo-health', get_template_directory() . '/languages' );

		// Add support for automatic feed links.
		add_theme_support( 'automatic-feed-links' );

		// Add support for title tag
		add_theme_support( 'title-tag' );

		// Add support for post thumbnails.
		add_theme_support( 'post-thumbnails' );

		// registe av menus.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'echo-health' ),
		) );

		// Add support for post formats.
		add_theme_support('post-formats', array(
            'aside',
            'image',
            'gallery',
            'audio',
            'video',
            'link',
            'quote',
		));
		
		 // Add support for Block Styles.
		 add_theme_support('wp-block-styles');

		 // Add support for full and wide align images.
		 add_theme_support('align-wide');
 
		 // Add support for editor styles.
		 add_theme_support('editor-styles');
		 
 		// Add support for responsive embedded content.
		 add_theme_support('responsive-embeds');

		 // Add custom editor font sizes.
		 add_theme_support(
			'editor-font-sizes', array(
				array(
					'name' => esc_html__('Small', 'echo-health'),
					'shortName' => esc_html__('S', 'echo-health'),
					'size' => 23,
					'slug' => 'small',
				),
				array(
					'name' => esc_html__('Normal', 'echo-health'),
					'shortName' => esc_html__('M', 'echo-health'),
					'size' => 31,
					'slug' => 'normal',
				),
				array(
					'name' => esc_html__('Large', 'echo-health'),
					'shortName' => esc_html__('L', 'echo-health'),
					'size' => 35,
					'slug' => 'large',
				),
				array(
					'name' => esc_html__('Huge', 'echo-health'),
					'shortName' => esc_html__('XL', 'echo-health'),
					'size' => 40,
					'slug' => 'huge',
				),
			)
		);

		// Add custom editor editor color palette.
        add_theme_support('editor-color-palette', array(
            array(
                'name' => esc_html__('strong yellow', 'echo-health'),
                'slug' => 'strong-yellow',
                'color' => '#f7bd00',
            ),
            array(
                'name' => esc_html__('strong white', 'echo-health'),
                'slug' => 'strong-white',
                'color' => '#fff',
            ),
            array(
                'name' => esc_html__('light black', 'echo-health'),
                'slug' => 'light-black',
                'color' => '#242424',
            ),
            array(
                'name' => esc_html__('very light gray', 'echo-health'),
                'slug' => 'very-light-gray',
                'color' => '#797979',
            ),
            array(
                'name' => esc_html__('very dark black', 'echo-health'),
                'slug' => 'very-dark-black',
                'color' => '#000000',
            ),
		));

		// Add editor style
		add_editor_style(echohealth_CSS_URL . 'editor-style.css');
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Indicate that the theme works well in both Standard and Transitional template modes of the AMP plugin.
		add_theme_support(
			'amp',
			array(
				// The `paired` flag means that the theme retains logic to be fully functional when AMP is disabled.
				'paired' => true,
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'echohealth_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'echohealth_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function echohealth_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'echohealth_content_width', 640 );
}
add_action( 'after_setup_theme', 'echohealth_content_width', 0 );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * echohealth TGM compatibility.
 */

echohealth\TGM\setup();

/**
 * echohealth is_blog compatibility.
 */
function echohealth_is_blog() {
    if ((is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag())) {
        return true;
    } else {
        return false;
    }
}

/**
 * echohealth elementor library compatibility.
 */
function echohealth_elementor_library() {
    $pageslist = get_posts(array(
        'post_type' => 'elementor_library',
        'posts_per_page' => -1
		));
	$pagearray = array();
	if(!empty($pageslist)) {
		foreach ($pageslist as $page) {
			$pagearray[$page->ID] = $page->post_title;
		}
	}
    return $pagearray;
}

/**
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
 */
if ( ! function_exists( 'wp_body_open' ) ) :
	function wp_body_open() {
		// Triggered after the opening <body> tag.
		do_action( 'wp_body_open' );
	}
endif;	
