<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package echohealth
 */
	$footer_style   = echohealth_get_options( 'footer_style' );
	$footer_copyright   = echohealth_get_options( 'footer_copyright' );
	$footer_style_class = '';
	if( $footer_style == '2' ) :
		$footer_style_class = 'footer-style-two';
	endif;
?>
	<?php
		$footer_top_elementor_widget = echohealth_get_options('footer_top_elementor_widget');
		if (class_exists("\\Elementor\\Plugin")) {
			if( is_array($footer_top_elementor_widget) && !empty($footer_top_elementor_widget) ) :
				$pluginElementor = \Elementor\Plugin::instance();
				foreach($footer_top_elementor_widget as $single_value){
					$echohealth_all_save_element = $pluginElementor->frontend->get_builder_content($single_value);
					echo do_shortcode($echohealth_all_save_element) ;
				}
			endif;
		}
	?>
	<footer class="footer-area <?php echo esc_attr( $footer_style_class ); ?>">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="footer-content">
						<div class="footer-copyright">
							<p>
								<?php
									if ( $footer_copyright != '' ) :
										echo wp_kses( $footer_copyright, 'code_contxt' );
									else :
								?>
									&copy;
									<?php
									echo esc_html(
										date_i18n(
										/* translators: Copyright date format, see https://www.php.net/date */
											_x( 'Y', 'copyright date format', 'echo-health' )
										)
									);
									?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>,
									<?php
										printf(
											'%s <a href="%s" target="_blank">%s</a> %s',
											esc_html__( 'Designed by', 'echo-health' ),
											esc_url( 'kitbug.com' ),
											esc_html( 'KitBug' ),
											esc_html__( 'and proudly', 'echo-health' )
										);
									?>
									<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'echo-health' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Powered by WordPress', 'echo-health' ); ?>
									</a>
								<?php endif; ?>
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>	
	<?php 
		do_action('echohealth_back_to_top_ready');
	?>
<?php wp_footer(); ?>
</body>
</html>
