<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package echohealth
 */

get_header();
?>
<!--Sidebar Page Container-->
<section class="error-404-page-area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="error-404-page">
					<h1><?php esc_html_e('404', 'echo-health'); ?></h1>
					<h6><?php esc_html_e('Oops! That page can not be found.', 'echo-health'); ?></h6>
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'echo-health' ); ?></p>
					<div class="error-404-page-search">
						<?php
							get_search_form();
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
