<?php
    /**
 * Template part for displaying front page Featured.
 *
 * @package Shadow Themes
 */

/// Get default  mods value.
$default = overall_blog_get_default_mods();
$featured_enable = get_theme_mod( 'easyvibe_featured_section_enable', true );

if ( false == $featured_enable ) {
    return;
}

$header_font_size = get_theme_mod( 'easyvibe_featured_header_font_size');
$title_font_size = get_theme_mod( 'easyvibe_featured_post_font_size',16);
$featured = get_theme_mod( 'easyvibe_featured_content_type', 'cat' );
$featured_section_title = get_theme_mod( 'easyvibe_featured_title');
$featured_section_subtitle = get_theme_mod( 'easyvibe_featured_subtitle');
$featured_num = get_theme_mod( 'easyvibe_featured_num', 10 );
$excerpt_length = get_theme_mod( 'easyvibe_featured_secion_excerpt',10); ?>
<?php if (!empty($title_font_size)): ?>
<style type="text/css">
    #featured .shadow-entry-title{
        font-size: <?php  echo esc_attr($title_font_size); ?>px;
        line-height: <?php  echo esc_attr($title_font_size) + 2; ?>px;
    }
</style>
<?php endif ?>

<div id="featured" class="page-section">
    <div class="wrapper">
        <?php if(!empty($featured_section_title)):?>
            <div class="shadow-section-header">
                <h2 class="shadow-section-title" style="font-size: <?php echo esc_attr($header_font_size); ?>px; " ><?php echo esc_html($featured_section_title);?></h2>
            </div><!-- .shadow-section-header -->
        <?php endif; ?>
        <div class="shadow-section-content column-5">
            <?php
                $featured_cat_id = get_theme_mod( 'easyvibe_featured_cat' );
                $args = array(
                    'cat' => $featured_cat_id,   
                    'posts_per_page' => $featured_num,
                    'ignore_sticky_posts' => true,
                );

                $query = new WP_Query( $args );

                $i = 1;
                if ( $query->have_posts() ) :
                    while ( $query->have_posts() ) :
                        $query->the_post();
                        ?>
                        <article class="grid-item">
                            <div class="featured-inner">
                                <div class="featured-image-wrapper">
                                    <div class="featured-image bg-image" style="background-image: url('<?php the_post_thumbnail_url( 'full' ); ?>');">
                                        <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->
                                </div>

                                <div class="shadow-entry-container">
                                    <?php if ($i%2!=0) {
                                        overall_blog_cats();  
                                    } ?>
                                    <header class="shadow-entry-header">
                                        <h2 class="shadow-entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                    </header>
                                    <div class="shadow-entry-meta">
                                        <?php overall_blog_posted_on(); ?>
                                    </div>
                                    <?php if ($i%2==0) {
                                        overall_blog_cats();  
                                    } ?>
                                </div><!-- .shadow-entry-container -->
                            </div>
                        </article>
                        <?php $i++; ?>
                    <?php endwhile; ?> 
                <?php endif; ?>
                <?php wp_reset_postdata(); ?>
        </div>
    </div>
</div>