<?php
/**
	 * Featured section
	 */
	// Featured section
	$wp_customize->add_section(
		'easyvibe_featured',
		array(
			'title' => esc_html__( 'Featured Post', 'easyvibe' ),
			'panel' => 'overall_blog_home_panel',
		)
	);

	// Featured Section enable setting
	$wp_customize->add_setting(
		'easyvibe_featured_section_enable',
		array(
			'sanitize_callback' => 'overall_blog_sanitize_checkbox',
			'default' => true,
		)
	);

	$wp_customize->add_control(
		'easyvibe_featured_section_enable',
		array(
			'section'		=> 'easyvibe_featured',
			'label'			=> esc_html__( 'Enable Featured Section.', 'easyvibe' ),
			'type'			=> 'checkbox',
		)
	);

	// Featured title setting
	$wp_customize->add_setting(
		'easyvibe_featured_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'easyvibe_featured_title',
		array(
			'section'		=> 'easyvibe_featured',
			'label'			=> esc_html__( 'Title:', 'easyvibe' ),
		)
	);

	// Featured number setting
	$wp_customize->add_setting(
		'easyvibe_featured_num',
		array(
			'sanitize_callback' => 'overall_blog_sanitize_number_range',
			'default' => 5,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'easyvibe_featured_num',
		array(
			'section'		=> 'easyvibe_featured',
			'label'			=> esc_html__( 'Number of featured:', 'easyvibe' ),
			'description'			=> esc_html__( 'Min: 1 | Max: 21', 'easyvibe' ),
			
			'type'			=> 'number',
			'input_attrs'	=> array( 'min' => 1,'max' => 20,'step' => 1 ),
		)
	);
	// Featured Excerpt setting
	$wp_customize->add_setting(
		'easyvibe_featured_secion_excerpt',
		array(
			'sanitize_callback' => 'overall_blog_sanitize_number_range',
			'default' => 20,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'easyvibe_featured_secion_excerpt',
		array(
			'section'		=> 'easyvibe_featured',
			'label'			=> esc_html__( 'Excerpt Length', 'easyvibe' ),
			'description'			=> esc_html__( 'Min: 10 | Max: 300', 'easyvibe' ),
			
			'type'			=> 'number',
			'input_attrs'	=> array( 'min' => 10, 'max' => 300 ),
		)
	);
	// Featured category setting
	$wp_customize->add_setting(
		'easyvibe_featured_cat',
		array(
			'sanitize_callback' => 'overall_blog_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'easyvibe_featured_cat',
		array(
			'section'		=> 'easyvibe_featured',
			'label'			=> esc_html__( 'Category:', 'easyvibe' ),
			'type'			=> 'select',
			'choices'		=> overall_blog_get_post_cat_choices(),
		)
	);

?>