<?php
/**
 * Shadow Themes Customizer
 *
 * @package Shadow Themes
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function easyvibe_customize_register( $wp_customize ) {
    include get_stylesheet_directory() . '/inc/customizer/featured.php';
}
add_action( 'customize_register', 'easyvibe_customize_register' );

if( !function_exists( 'easyvibe_get_post_cat_choices' ) ) :
  /*
   * Function to get categories
   */
  function easyvibe_get_post_cat_choices() {
    $categories = get_terms( 'category' );
    $choices = array('' => esc_html__( '--Select Category--', 'easyvibe' ));

    foreach( $categories as $category ) {
      $choices[$category->term_id] = $category->name;
    }

    return $choices;
  }
endif;