<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'easyvibe_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function easyvibe_enqueue_styles() {
        wp_enqueue_style( 'easyvibe-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'easyvibe-style', get_stylesheet_directory_uri() . '/style.css', array( 'easyvibe-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'easyvibe_enqueue_styles', 10 );

if ( ! function_exists( 'easyvibe_customize_backend_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function easyvibe_customize_backend_styles() {
        wp_enqueue_style( 'easyvibe-style', get_stylesheet_directory_uri() . '/customizer-style.css' );
    }
endif;
add_action( 'customize_controls_enqueue_scripts', 'easyvibe_customize_backend_styles', 99 );

require get_stylesheet_directory() . '/inc/customizer/customizer.php';

function easyvibe_body_classes( $classes ) {

if ( overall_blog_is_frontpage_blog() || overall_blog_is_latest_posts() ) { // When global post sidebar is checked.
    $page_id = get_option( 'page_for_posts' );
      $overall_blog_page_sidebar_meta = get_post_meta( $page_id, 'overall-blog-select-sidebar', true);
      if ( ! empty( $overall_blog_page_sidebar_meta ) ) {
        $classes[] = esc_attr( $overall_blog_page_sidebar_meta ) . '-sidebar';
        } else {
        $blog_post_sidebar = get_theme_mod( 'overall_blog_blog_sidebar', 'no' ); 
        $classes[] = esc_attr( $blog_post_sidebar ) . '-sidebar';
      }
  }
}