<?php
/**
 * Easemag tabs content
 */
class Easymag_Tabs_Content extends WP_Widget {

    public $layout;
    public $layout_class;

    public function __construct( $id_base = '', $name = '', $widget_options = array(), $control_options = array() ) {
        parent::__construct( $id_base, $name, $widget_options, $control_options );
    }

    function query( $instance = array() ){
        $instance = wp_parse_args( $instance, array() );
        $viewing = isset( $instance['viewing'] ) ?  $instance['viewing'] : '';

        $viewing = explode( ',', $viewing);
        $viewing = array_map( 'absint', $viewing );
        $viewing = array_filter( $viewing );

        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            $this->layout = isset($instance['_layout']) ? absint( $instance['_layout'] ) : 1;
        }

        if ( is_string( $instance['category'] ) ) {
            $instance['category'] = explode( ',', $instance['category'] );
            $instance['category'] = array_map( 'absint', $instance['category'] );
        }

        if ( ! $instance['category'] || empty( $instance['category'] ) ) {
            $instance['category'] = array();
        }

        $instance['category'] = array_filter( $instance['category'] );

        if ( ! $viewing || empty( $viewing ) ) {

            if ( isset( $instance['show_all'] ) && $instance['show_all'] == 'on' ) {
                $viewing = $instance['category'] ;
            } else {
                $viewing = current( $instance['category'] );
            }

        }

        $no_of_posts = isset( $instance['no_of_posts'] ) ? absint( $instance['no_of_posts'] ) : false;
        if ( ! $no_of_posts ) {
            if ( isset( $instance['posts_per_page'] ) ) {
                $no_of_posts = absint( $instance['posts_per_page'] );
            }
        }

        $max_posts =  apply_filters( 'easymag_tabs_content_max_posts', 30 );

        if ( $no_of_posts > $max_posts ) {
            $no_of_posts = $max_posts;
        }

        if ( ! $no_of_posts ) {
            $no_of_posts = get_option( 'posts_per_page' );
        }

        $paged = 0;

        if ( isset( $instance['paged'] ) ) {
            $paged = absint( $instance['paged'] );
        }

        $args = array(
            'post_type'         => 'post',
            'category__in'      => $viewing,
            'posts_per_page'    => $no_of_posts,
            'ignore_sticky_posts' => 1,
            'paged' => $paged,
        );

        $can_orderby = array( 'date', 'title', 'rand', 'comment_count' );

        if ( isset( $instance['orderby'] ) &&  $instance['orderby'] && in_array(  $instance['orderby'], $can_orderby ) ) {
            $args['orderby'] = $instance['orderby'];
        }

        if ( isset( $instance['order'] ) &&  $instance['order'] && in_array(  $instance['order'], array( 'asc', 'desc' ) ) ) {
            $args['order'] = $instance['order'];
        }

        $args = apply_filters( 'easymag_widget_content_args', $args, $instance, $this );

        $query = new WP_Query( $args );
       

        return $query;
    }


    function setup_instance( $instance ){
        $r = array();
        foreach ( $this->get_configs() as $f ) {
            if ( isset( $f['name'] ) ) {
                if ( isset( $instance[ $f['name'] ] ) ) {
                    $r[ $f['name' ] ] = $instance[ $f['name'] ];
                } else if ( isset( $f['default'] ) && empty( $instance ) ) {
                    $r[ $f['name' ] ] = $f['default'];
                } else {
                    $r[ $f['name' ] ] = null;
                }
            }
        }

        return $r;
    }

    public function widget( $args, $instance )
    {

        if ( ! isset( $instance['__setup_data'] ) || ! $instance['__setup_data'] === false ){
            $instance = $this->setup_instance( $instance );
        }

        $title = $instance['title'];
        unset($instance['title']);

        $category = $instance['category'];
        $show_all = ( isset( $instance['show_all'] ) ) ? $instance['show_all'] : '';

        if ( ! is_array( $category ) ) {
            $category = ( array ) $category;
        }

        $query = $this->query( $instance );
        $instance['_layout'] = $this->layout;

        $classes = array( 'dt-news-list-' . $this->layout );
        if ( $this->layout_class ) {
            $classes[] = $this->layout_class;
        }

        ?>
        <div class="<?php echo esc_attr( join( ' ', $classes ) ); ?>">
            <div class="news-layout-tabs dt-news-layout-wrap" data-ajax="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" data-instance="<?php echo esc_attr(json_encode($instance)); ?>">
                <?php if ( ! empty( $title ) ) { ?>
                <div class="widget-title filter-inside">
                    <h2 class="heading-label"><?php echo esc_html($title) ?></h2>
                    <?php
                   
                        $t = current( $category );
                        $t = get_term( $t , 'category');
                        if ( $t && ! is_wp_error( $t ) ) {
                            echo '<span class="view-all-link"><a href="' . esc_url( get_term_link( $t ) ) . '">' . esc_html__('[ View All ]', 'easymag') . '</a></span>';
                        }
                    
                    ?>
                    <?php ?>
                </div>
                <?php } ?>

                <?php

                echo '<div class="news-tab-layout animate dt-news-layout'.$this->layout.'">';
                    echo '<div class="news-tab-posts">';
                            if ( $query->have_posts() ) {
                                if (method_exists($this, 'layout_' . $this->layout)) {
                                    $this->{'layout_' . $this->layout}($query);
                                } else {
                                    $this->layout_content($query);
                                }
                            } else {
                                $this->not_found();
                            }

                    echo '</div>';
                echo '</div>';

                wp_reset_postdata();
                ?>
            </div>
        </div>
        <?php
    }


    function layout_content( $query ){

        ?>
        <?php while ($query->have_posts()) : $query->the_post(); ?>

            <div class="dt-news-post">
                <figure class="dt-news-post-img">
                    <?php
                    if (has_post_thumbnail()) :
                        the_post_thumbnail('dt-featured-post-medium');
                    endif;
                    ?>

                    <a href="<?php echo esc_url(get_permalink()); ?>" rel="bookmark"><span class="transition35"><i class="fa fa-search transition35"></i></span></a>
                </figure>
                <!-- .dt-news-post-img -->

                <div class="dt-news-post-content">
                    <div class="dt-news-post-meta">
                        <span class="dt-news-post-date"><i class="fa fa-calendar"></i> <?php the_time(get_option('date_format')); ?></span>

                        <span class="dt-news-post-comments"><i class="fa fa-comments"></i> <?php comments_number('No Responses', 'one Response', '% Responses'); ?></span>
                    </div>
                    <!-- .dt-news-post-meta -->

                    <h3>
                        <a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                            <?php echo wp_trim_words(get_the_title(), 10, '...'); ?>
                        </a>
                    </h3>

                    <div class="dt-news-post-desc">
                        <?php
                        $excerpt = get_the_excerpt();
                        $limit = "220";
                        $pad = "...";

                        if (strlen($excerpt) <= $limit) {
                            echo esc_attr($excerpt);
                        } else {
                            $excerpt = substr($excerpt, 0, $limit) . $pad;
                            echo esc_attr($excerpt);
                        }
                        ?>

                    </div>
                    <!-- .dt-news-post-desc -->
                </div>
                <!-- .dt-news-post-content -->

                <div class="clearfix"></div>
            </div><!-- .dt-news-post -->

        <?php endwhile; ?>

        <div class="clearfix"></div>
        <?php
        $this->end_layout($query);

    }
    function not_found(){
        ?>
        <p class="posts-not-found"><?php _e( 'Sorry, no posts found in selected category.', 'easymag' ); ?></p>
        <?php
    }

    function end_layout( $query ){
       
        wp_reset_postdata();
    }

    function layout_1( $query ){
        $this->layout_content( $query );
    }

    function layout_2( $query ){
        global $post;
        while ( $query->have_posts() ) { $query->the_post(); ?>

            <div class="dt-news-post transition5">
                <figure class="dt-news-post-img">

                    <?php
                    if (has_post_thumbnail()) :
                        $image = '';
                        $title_attribute = get_the_title($post->ID);
                        $image .= '<a href="' . esc_url(get_permalink()) . '" title="' . esc_html(the_title('', '', false)) . '">';
                        $image .= get_the_post_thumbnail($post->ID, 'dt-featured-post-medium', array('title' => esc_attr($title_attribute), 'alt' => esc_attr($title_attribute))) . '</a>';
                        echo $image;

                    endif;
                    ?>

                    <div class="dt-news-post-meta">
                        <span class="dt-news-post-month"><?php esc_attr(the_time("M")); ?><br/><?php esc_attr(the_time("Y")); ?></span>
                        <span class="dt-news-post-day"><?php esc_attr(the_time("d")); ?></span>
                    </div>
                    <!-- .dt-news-post-meta -->
                </figure>
                <!-- .dt-news-post-img -->

                <div class="dt-news-post-content">
                    <h3>
                        <a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                            <?php echo wp_trim_words(get_the_title(), 8, '...'); ?>
                        </a>
                    </h3>

                    <div class="dt-news-post-desc">

                        <?php echo wp_trim_words(get_the_excerpt(), 23, '...'); ?>

                    </div>
                    <!-- .dt-news-post-desc -->
                </div>
                <!-- .dt-news-post-content -->
            </div><!-- .dt-news-post transition5 -->

            <?php
        };

        $this->end_layout( $query );

    }

    function layout_3( $query ){

        while ( $query->have_posts() ) { $query->the_post(); ?>

            <div class="dt-news-post">
                <figure class="dt-news-post-img">
                    <?php

                    if ( has_post_thumbnail() ) :

                        the_post_thumbnail( 'dt-featured-post-medium' );

                    endif;
                    ?>
                    <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><span class="transition35"><i class="fa fa-search transition35"></i></span></a>
                </figure><!-- .dt-news-post-img -->

                <div class="dt-news-post-content">
                    <div class="dt-news-post-meta">
                        <span class="dt-news-post-date"><i class="fa fa-calendar"></i> <?php the_time ( get_option ( 'date_format' ) ); ?></span>

                        <span class="dt-news-post-comments"><i class="fa fa-comments"></i> <?php comments_number( 'No Responses', 'one Response', '% Responses' ); ?></span>
                    </div><!-- .dt-news-post-meta -->

                    <h3><a href="<?php esc_url( the_permalink() ); ?>" title="<?php the_title_attribute(); ?>">

                            <?php echo wp_trim_words( get_the_title(), 10, '...' ); ?>

                        </a></h3>

                    <div class="dt-news-post-desc">
                        <?php
                        $excerpt = get_the_excerpt();
                        $limit   = "210";
                        $pad     = "...";

                        if( strlen( $excerpt ) <= $limit ) {
                            echo esc_html( $excerpt );
                        } else {
                            $excerpt = substr( $excerpt, 0, $limit ) . $pad;
                            echo esc_html( $excerpt );
                        }

                        ?>
                    </div><!-- .dt-news-post-desc -->
                </div><!-- .dt-news-post-content -->

                <div class="clearfix"></div>
            </div><!-- .dt-news-post -->

        <?php }

        $this->end_layout($query);
    }

    function layout_4( $query ){

        $n = count( $query->posts );
        global $post;

        $i = 0;
        while ( $query->have_posts() ) { $query->the_post();
            $i++;
            $c = 'dt-news-post';
            if ( $n % 2 == 0 ){
                if ( $i == $n ) {
                    $c.= ' last';
                } else if ( $i == $n - 1 ) {
                    $c.= ' e-last';
                }
            } else {
                if ( $i == $n ) {
                    $c.= ' last';
                }
            }

            ?>
            <div class="<?php echo esc_attr( $c ); ?>">
                <figure class="dt-news-post-img">
                    <?php
                    if ( has_post_thumbnail() ) :
                        $image = '';
                        $title_attribute = get_the_title( $post->ID );
                        $image .= '<a href="'. esc_url( get_permalink() ) . '" title="' . esc_html( the_title( '', '', false ) ) .'">';
                        $image .= get_the_post_thumbnail( $post->ID, 'dt-featured-post-small', array( 'title' => esc_attr( $title_attribute ), 'alt' => esc_attr( $title_attribute ) ) ).'</a>';
                        echo $image;

                    endif;
                    ?>

                    <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><span class="transition35"><i class="fa fa-search transition35"></i></span></a>
                </figure><!-- .dt-news-post-img -->

                <div class="dt-news-post-content">
                    <h3><a href="<?php esc_url( the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php esc_html( the_title() ); ?></a></h3>
                </div><!-- .dt-news-post-content -->
            </div><!-- .dt-news-post -->
        <?php
        };

        $this->end_layout($query);
    }

    function field( $field = array() ){

        if ( is_array( $field['value'] ) ) {
            $field['value'] = array_filter( $field['value'] );
        }

        switch ( $field['type'] ) {
            case 'select_category':
                ?>
                <div class="dt-admin-input-wrap">
                    <label for="<?php echo $this->get_field_id( $field['name'] ); ?>"><strong><?php echo $field['label']; ?></strong></label>
                    <?php
                    wp_dropdown_categories(
                        array(
                            'show_option_all'   =>  esc_html__( '-- Select a category --', 'easymag' ),
                            'show_option_none'  => '',
                            'orderby'           => 'id',
                            'order'             => 'ASC',
                            'show_count'        => 0,
                            'hide_empty'        => true,
                            'child_of'          => 0,
                            'selected'          => $field['value'],
                            'hierarchical'      => 1,
                            'name'              => $field['name'],
                            'id'                => '',
                            'taxonomy'          => 'category',
                            'option_none_value' => -1,
                            'value_field'       => 'term_id',
                        )
                    );
                    ?>
                </div><!-- .dt-admin-input-wrap -->
                <?php
                break;
            case 'checkbox':
                ?>
                <div class="dt-admin-input-wrap">
                    <label for="<?php echo $this->get_field_id( $field['name'] ); ?>"><strong><?php echo $field['label']; ?></strong></label>
                    <input type="checkbox" <?php checked( $field[ 'value' ], 'on' ); ?> id="<?php echo $this->get_field_id( $field['name'] ); ?>" name="<?php echo $this->get_field_name( $field['name'] ); ?>" />
                </div><!-- .dt-admin-input-wrap -->
                <?php
                break;
            case 'orderby':
            ?>
            <div class="dt-admin-input-wrap">
                <label for="<?php echo $this->get_field_id( $field['name'] ); ?>"><strong><?php echo $field['label']; ?></strong></label>
                <select id="<?php echo $this->get_field_id( $field['name'] ); ?>" name="<?php echo $this->get_field_name( $field['name'] ); ?>">
                    <option value=""><?php esc_html_e( 'Default', 'easymag' ); ?></option>
                    <option <?php selected( $field[ 'value' ], 'date' ); ?> value="date"><?php esc_html_e( 'Date', 'easymag' ); ?></option>
                    <option <?php selected( $field[ 'value' ], 'title' ); ?> value="title"><?php esc_html_e( 'Title', 'easymag' ); ?></option>
                    <option <?php selected( $field[ 'value' ], 'rand' ); ?> value="rand"><?php esc_html_e( 'Random order', 'easymag' ); ?></option>
                    <option <?php selected( $field[ 'value' ], 'comment_count' ); ?> value="comment_count"><?php esc_html_e( 'Number of comments', 'easymag' ); ?></option>
                </select>
            </div><!-- .dt-admin-input-wrap -->
            <?php
            break;

            case 'order':
                ?>
                <div class="dt-admin-input-wrap">
                    <label for="<?php echo $this->get_field_id( $field['name'] ); ?>"><strong><?php echo $field['label']; ?></strong></label>
                    <select id="<?php echo $this->get_field_id( $field['name'] ); ?>" name="<?php echo $this->get_field_name( $field['name'] ); ?>">
                        <option value=""><?php esc_html_e( 'Default', 'easymag' ); ?></option>
                        <option <?php selected( $field[ 'value' ], 'desc' ); ?> value="desc"><?php esc_html_e( 'Desc', 'easymag' ); ?></option>
                        <option <?php selected( $field[ 'value' ], 'asc' ); ?> value="asc"><?php esc_html_e( 'Asc', 'easymag' ); ?></option>
                    </select>
                </div><!-- .dt-admin-input-wrap -->
                <?php
                break;

            case 'list_cat':
               

                    if ( is_array( $field['value'] ) ) {
                        $field['value'] = current( $field['value'] );
                    }

                    ?>
                    <div class="dt-admin-input-wrap">
                        <label for="<?php echo $this->get_field_id( $field['name'] ); ?>"><strong><?php echo $field['label']; ?></strong></label>
                        <?php
                        wp_dropdown_categories(
                            array(
                                'show_option_all'   =>  esc_html__( '-- Select a category --', 'easymag' ),
                                'show_option_none'  => '',
                                'orderby'           => 'id',
                                'order'             => 'ASC',
                                'show_count'        => 0,
                                'hide_empty'        => true,
                                'child_of'          => 0,
                                'selected'          => $field['value'],
                                'hierarchical'      => 1,
                                'name'              => $this->get_field_name( $field['name'] ),
                                'id'                => '',
                                'taxonomy'          => 'category',
                                'option_none_value' => -1,
                                'value_field'       => 'term_id',
                            )
                        );
                        ?>
                    </div><!-- .dt-admin-input-wrap -->
                    <?php
                

                break;
            default:
                ?>
                <div class="dt-admin-input-wrap">
                    <label for="<?php echo $this->get_field_id($field['name']); ?>"><strong><?php echo $field['label']; ?></strong></label>
                    <input type="text" id="<?php echo $this->get_field_id($field['name']); ?>" name="<?php echo $this->get_field_name($field['name']); ?>"
                           value="<?php echo esc_attr($field['value']); ?>">
                </div><!-- .dt-admin-input-wrap -->
                <?php
                break;
        }
    }

    function get_configs( ){
        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'easymag' ),
            ),
            array(
                'type' =>'repeatable',
                'name' => 'category',
                'label' => esc_html__( 'Categories', 'easymag' ),
            ),
            array(
                'type' =>'checkbox',
                'name' => 'show_all',
                'label' => esc_html__( 'Show All Filter', 'easymag' ),
            ),

            array(
                'type' =>'text',
                'name' => 'no_of_posts',
                'label' => esc_html__( 'Show All Filter', 'easymag' ),
            ),
        );

        return $fields;

    }

    function render_fields( $instance = array() ){
        $fields = $this->get_configs();
        foreach ( $fields as $field ) {
            $field = wp_parse_args( $field, array(
                'type'      => 'text',
                'name'      => '',
                'label'     => '',
                'value'     => '',
                'default'   => '',
            ) );

            if ( isset( $instance[ $field['name'] ] ) ) {
                $field['value'] = $instance[ $field['name'] ];
            } else {
                $field['value'] = $field['default'];
            }

            $this->field( $field );

        }
    }


    public function form( $instance ) {
        ?>
        <div class="dt-news-list-1">
            <?php
            $this->render_fields( $instance );
            ?>
        </div><!-- .dt-news-list-1 -->
        <?php ?>
            <div class="ft-notice-message">
                <?php _e( 'Upgrade to <a target="_blank" href="https://www.famethemes.com/themes/easymag-pro/#pricing">EasyMag Pro version</a> to use <strong>Ajax tabs content</strong> and <strong>unlimited categories</strong> for this widget.', 'easymag' ); ?>
            </div>
        <?php  ?>
        <?php
    }

    public function update( $new_instance, $old_instance ) {

        return $new_instance;

        $instance = array();
        foreach ( $this->get_configs() as $field ) {
            $field = wp_parse_args( $field, array(
                'name'      => '',
            ) );

            if (  $field['name'] ) {
                if (isset($new_instance[$field['name']])) {
                    $instance[$field['name']] = $new_instance[$field['name']];
                } else {
                    $instance[$field['name']] = '';
                }
            }
        }

        if ( isset( $new_instance['category'] ) ) {
            $instance['category'] = $new_instance['category'];
        }

        return $new_instance;
    }
}



