<?php
/**
 * News list Layout 4.
 */
class easymag_news_list4 extends Easymag_Tabs_Content {

    public $layout = 4;
    public $layout_class = 'dt-sidebar-news';

    public function __construct() {

        parent::__construct(
            'easymag_news_list4',
            __( 'EasyMag: News Layout 4', 'easymag' ),
            array(
                'description'   => __( 'Posts display layout 4 for recently published post', 'easymag' )
            )
        );
    }

    function get_configs( ){
        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'easymag' ),
            ),
            array(
                'type' =>'list_cat',
                'name' => 'category',
                'label' => esc_html__( 'Categories', 'easymag' ),
            ),

            array(
                'type' =>'text',
                'name' => 'no_of_posts',
                'label' => esc_html__( 'No. of Posts', 'easymag' ),
            ),

            array(
                'type' =>'orderby',
                'name' => 'orderby',
                'label' => esc_html__( 'Orderby', 'easymag' ),
            ),

            array(
                'type' =>'order',
                'name' => 'order',
                'label' => esc_html__( 'Order', 'easymag' ),
            ),

        );

       

        return $fields;

    }
}