<?php
/**
 * News list Layout 3.
 */
class easymag_news_list3 extends Easymag_Tabs_Content {

    public $layout = 3;

    public function __construct() {

        parent::__construct(
            'easymag_news_list3',
            __( 'EasyMag: News Layout 3', 'easymag' ),
            array(
                'description'   => __( 'Posts display layout 3 for recently published post', 'easymag' )
            )
        );
    }

    function get_configs( ){
        $fields = array(
            array(
                'type' =>'text',
                'name' => 'title',
                'label' => esc_html__( 'Title', 'easymag' ),
            ),
            array(
                'type' =>'list_cat',
                'name' => 'category',
                'label' => esc_html__( 'Categories', 'easymag' ),
            ),

            array(
                'type' =>'text',
                'name' => 'title2',
                'label' => esc_html__( 'Title 2', 'easymag' ),
            ),
            array(
                'type' =>'list_cat',
                'name' => 'category2',
                'label' => esc_html__( 'Categories 2', 'easymag' ),
            ),

            array(
                'type' =>'text',
                'name' => 'no_of_posts',
                'label' => esc_html__( 'No. of Posts', 'easymag' ),
            ),

            array(
                'type' =>'orderby',
                'name' => 'orderby',
                'label' => esc_html__( 'Orderby', 'easymag' ),
            ),

            array(
                'type' =>'order',
                'name' => 'order',
                'label' => esc_html__( 'Order', 'easymag' ),
            ),

        );

       

        return $fields;

    }


    public function widget( $args, $instance ) {

        $instance = $this->setup_instance( $instance );

        $title          = isset( $instance[ 'title' ] ) ? $instance[ 'title' ] : '';
        $category       = isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : '';
        $no_of_posts    = isset( $instance[ 'no_of_posts' ] ) ? $instance[ 'no_of_posts' ] : '';

        $title2          = isset( $instance[ 'title2' ] ) ? $instance[ 'title2' ] : '';
        $category2       = isset( $instance[ 'category2' ] ) ? $instance[ 'category2' ] : '';

        $instance_1 = array(
            '__setup_data'      => false,
            'title'             => $title,
            'category'          => $category,
            'no_of_posts'       => $no_of_posts,
            'order'             => $instance[ 'order' ],
            'orderby'           => $instance[ 'orderby' ],
        );

        $instance_2 = array(
            '__setup_data'      => false,
            'title'             =>  $title2,
            'category'          => $category2,
            'posts_per_page'    => $no_of_posts,
            'order'             => $instance[ 'order' ],
            'orderby'           => $instance[ 'orderby' ],
        );

       

        ?>
        <div class="dt-news-list-3">
            <div class="dt-news-layout-half">
                <?php

                parent::widget( array(), $instance_1 );

                ?>
            </div><!-- .dt-news-layout-wrap .dt-news-layout-half -->

            <div class="dt-news-layout-half dt-half-last">
                <?php
                parent::widget( array(), $instance_2 );
                ?>
            </div>
            <div class="clearfix"></div>
        </div>
        <?php
    }


}