<?php

class EasyMag_Weather {

    private static $caching_time = 10800;  // 3 hours
    private static $caching_overtime = 315360000; // 60 * 60 * 24 * 365 * 10
    //private static $owm_api_key = 'f5dc074e364b4d0bbaacbab0030031a3';

    private static $api_keys = array (
        'e5342a41a77f36d7802f350362aa6725',
        '5f0e41b16ad3752a1ccb886bceb5ed51',
        '5893ae71fbc9d28b832691406f6ba39b',
        '93d95bd6e3378a6cb7c7e3e6f6cb5483',
        '44458592cde0010a8a963db522bf6be5',
        '9c252c3f1a0036ea446f45651330701e',
        '0c3f5c17cf5499acaabff3ff594eec5c',
        '2b08ac14030ba455470237725275d7f8',
        'c3075d0842fb57c51faada7fc3cbba6b',
        'f5dc074e364b4d0bbaacbab0030031a3',
        '17aa0dd026f22e09f52ad000002991c6',
        '849339ce83cba73963c74b390cba23dd',
        '6dc28d5e9e6ef985034b6e9d153e73c7',
        'f166e0697a8541984a1c4dce5221f592',
        'd24d6df2a159679a31cf70400e87a26c'
    );

    private static function locale( $locale ){
        if (empty( $locale )) {
            $atts['language'] = 'en';
            $sytem_locale = get_locale();
            $available_locales = array( 'en', 'es', 'sp', 'fr', 'it', 'de', 'pt', 'ro', 'pl', 'ru', 'uk', 'ua', 'fi', 'nl', 'bg', 'sv', 'se', 'ca', 'tr', 'hr', 'zh', 'zh_tw', 'zh_cn', 'hu' );

            // CHECK FOR LOCALE
            if( in_array( $sytem_locale , $available_locales ) ) {
                $locale = $sytem_locale;
            }
            // CHECK FOR LOCALE BY FIRST TWO DIGITS
            if( in_array(substr($sytem_locale, 0, 2), $available_locales ) ) {
                $locale = substr($sytem_locale, 0, 2);
            }
        }
        return $locale;
    }

    static function icon( $code ) {
        $icons = array (
            // day
            '01d' => 'B',
            '02d' => 'H',
            '03d' => 'N',
            '04d' => 'Y',
            '09d' => 'Q',
            '10d' => 'R',
            '11d' => 'P',
            '13d' => 'W',
            '50d' => 'M',

            //night
            '01n' => 'C',
            '02n' => 'I',
            '03n' => 'N',
            '04n' => 'Y',
            '09n' => 'Q',
            '10n' => 'R',
            '11n' => 'P',
            '13n' => 'W',
            '50n' => 'M',
        );

        if ( isset( $icons[ $code ] ) ) {
            return $icons[ $code ];
        } else {
            return false;
        }
    }

    /**
     * adds to the &$weather_data the information for today's forecast from OWM
     * @param $atts - the shortcode atts
     * @param $weather_data - BYREF weather data - this function will add to it
     *
     * @return bool|string
     *   - true: if everything is ok
     *   - string: the error message, if there was an error
     */
    public static function get_today($atts) {
        $atts = wp_parse_args( $atts,  array(
            'location' => '',
            'language' => '',
            'unit' => 'c', // of f
        ) );

        if ( ! $atts['language'] ) {
            $atts['language'] = self::locale( $atts['language']  );
        }
       
        // Check cache
        $cache_key = __CLASS__.'weather_data_'.md5( json_encode( $atts ) );
        $weather_data = get_transient( $cache_key );
        if ( false !== $weather_data ) {
            return $weather_data;
        }

        $key = self::get_api_key();
        $today_weather_url = 'http://api.openweathermap.org/data/2.5/weather?q=' . urlencode($atts['location']) . '&lang=' . $atts['language'] . '&units=metric&appid=' . $key;

        $r =  wp_remote_get( $today_weather_url );
        if ( wp_remote_retrieve_response_code( $r ) != 200 ) {
            return false;
        }
        $json_api_response = wp_remote_retrieve_body( $r );

        // try to decode the json
        $api_response = @json_decode($json_api_response, true);

        if ( $api_response === null and json_last_error() !== JSON_ERROR_NONE) {
            return __( 'Error decoding the json from OpenWeatherMap', 'easymag' );
        }

        if( ! isset( $api_response['cod'] ) || $api_response['cod'] != 200 ) {
            return false;
        }

        $weather_data = array(
            'name' => $api_response['name'],
            'temp' => '',
            'temp_min' => '',
            'temp_max' => '',
            'icon' => '',
            'icon_i' => '',
            'title' => ''
        );

        if( strtoupper( $atts['unit'] ) == 'F' ) {
            $weather_data['temp']       = self::celsius_to_fahrenheit( $api_response['main']['temp'] );
            $weather_data['temp_min']   = self::celsius_to_fahrenheit( $api_response['main']['temp_min'] );
            $weather_data['temp_max']   = self::celsius_to_fahrenheit( $api_response['main']['temp_max'] );
            $weather_data['unit_html']   = '&#x2109;';
        } else {
            $weather_data['temp']       =  $api_response['main']['temp'];
            $weather_data['temp_min']   =  $api_response['main']['temp_min'];
            $weather_data['temp_max']   =  $api_response['main']['temp_max'];
            $weather_data['unit_html']   = '&#x2103;';
        }

        $weather_data['icon']   = $api_response['weather'][0]['icon'];
        $weather_data['icon_i'] = self::icon( $api_response['weather'][0]['icon'] );
        $weather_data['title']  = $api_response['weather'][0]['main'];
        set_transient( $cache_key,  $weather_data, self::$caching_time );
        return $weather_data;
    }


    /**
     * adds to the &$weather_data the information for the next 5 days
     * @param $atts - the shortcode atts
     * @param $weather_data - BYREF weather data - this function will add to it
     *
     * @return bool|string
     *   - true: if everything is ok
     *   - string: the error message, if there was an error
     */
    public static function get_7_days_data ( $atts ) {
        $atts = wp_parse_args( $atts,  array(
            'location' => '',
            'language' => '',
            'unit' => 'c', // of f
        ) );
        $api_key = self::get_api_key();
        $today_weather_url = 'http://api.openweathermap.org/data/2.5/forecast/daily?q=' . urlencode($atts['location']) . '&lang=' . $atts['language'] . '&units=metric&cnt=7&appid=' . $api_key;
        $r = wp_remote_get( $today_weather_url );
        if ( wp_remote_retrieve_response_code( $r ) != 200 ) {
            return false;
        }
        $json_api_response = wp_remote_retrieve_body( $r );
        // fail
        if ( $json_api_response === false ) {
            return __( 'Error getting remote data for 5 days forecast. Please check your server configuration', 'easymag' );
        }

        // try to decode the json
        $api_response = @json_decode($json_api_response, true);
        if ($api_response === null and json_last_error() !== JSON_ERROR_NONE) {
            return __( 'Error decoding the json from OpenWeatherMap', 'easymag' );
        }

        if( ! isset( $api_response['cod'] ) || $api_response['cod'] != 200 ) {
            return false;
        }

        return $api_response;
    }

    /**
     * convert celsius to fahrenheit + rounding (no decimals if result > 100 or one decimal if result < 100)
     * @param $celsius_degrees
     * @return float
     */
    private static function celsius_to_fahrenheit ($celsius_degrees) {
        $f_degrees = $celsius_degrees * 9 / 5 + 32;

        $rounded_val = round($f_degrees, 1);
        if ($rounded_val > 99.9) {  // if the value is bigger than 100, round it with no zecimals
            return round($f_degrees);
        }

        return $rounded_val;
    }


    /**
     * rounding to .1
     * @param $kmph
     * @return float
     */
    private static function kmph_to_mph ($kmph) {
        return round($kmph * 0.621371192, 1);
    }

    private static function get_api_key( $avoid_keys = array() ) {

        if (empty($avoid_keys)) {
            return self::$api_keys[rand(0, count(self::$api_keys) - 1)];
        }

        $available_keys = array_values(array_diff(self::$api_keys, $avoid_keys));

        if (empty($available_keys)) {
            return null;
        }

        return $available_keys[rand(0, count($available_keys) - 1)];
    }
}
