<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package EasyMag
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function easymag_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	return $classes;
}
add_filter( 'body_class', 'easymag_body_classes' );


/**
 * Enqueue Inline styles generated by customizer
 */
function easymag_customizer_styles() {

    $color = get_theme_mod( 'easymag_font_color' );

    if ( $color != '' ) {
        $dt_color = "
	body,
	h1 a,
	h2 a,
	h3 a,
	h4 a,
	h5 a,
	h6 a,
	.dt-sidebar .dt-social-icons li .fa,
    a {
		color: {$color};
	}
	";
    } else {
        $dt_color = '';
    }

    $font_size = get_theme_mod( 'easymag_font_size' );

    if ( $font_size != '' ) {
        $dt_font_size = "
	body {
		font-size: {$font_size}px;
	}
	";
    } else {
        $dt_font_size = '';
    }

    $primary = get_theme_mod( 'easymag_primary_color' );

    if ( $primary != '' ) {
        $dt_primary_color = "
	a:hover,
	.dt-footer-cont li a:hover,
	.dt-sec-menu li a:hover,
	.dt-featured-posts-wrap h2 a:hover,
	.dt-pagination-nav .current,
	.dt-footer .dt-news-layout-wrap a:hover {
		color: {$primary};
	}

	.dt-news-layout2 .dt-news-post:hover,
	.dt-pagination-nav .current,
	.dt-pagination-nav a:hover {
		border-color: {$primary} ;
	}
	.bt-news-ticker-tag:after {
		border-left-color: {$primary} !important;
	}
	.sticky {
		border-color: {$primary} !important;
	}

	.dt-news-layout1 .dt-news-post-img .fa:hover,
	.dt-news-layout-half .dt-news-post-img .fa:hover,
	.dt-sidebar-news .dt-news-post-img .fa:hover,
	.dt-footer h2:after,
	.dt-footer .tagcloud a:hover,
	.dt-related-posts .dt-news-post-img .fa:hover,
	.dt-search-bar,
	.bt-news-ticker-tag,
	.dt-category-posts .dt-news-post-img .fa:hover,
	.dt-category-post-readmore a:hover,
	.dt-nav-md-trigger:hover .fa,
	.tagcloud a:hover {
		background: {$primary};
	}
	";
    } else {
        $dt_primary_color = '';
    }

    $rgba = easymag_hex2rgba( $primary, .75 );
    if ( $rgba != '' ) {
        $dt_rgba = "
	.dt-news-layout1 .dt-news-post-img .fa,
	.dt-news-layout-half .dt-news-post-img .fa,
	.dt-sidebar-news .dt-news-post-img .fa,
	.dt-related-posts .dt-news-post-img .fa,
	.dt-category-posts .dt-news-post-img .fa,
	#back-to-top:hover {
		background: {$rgba};
	}
	";
    } else {
        $dt_rgba = '';
    }

    $menu_bg = get_theme_mod( 'easymag_menu_bg_color' );

    if ( $menu_bg != '' ) {

        $dt_menu_bg = "
	.dt-menu-bar,
	.dt-main-menu li ul {
		background: {$menu_bg};
	}
	";

    } else {
        $dt_menu_bg = '';
    }

    $menu_color		= get_theme_mod( 'easymag_menu_color' );
    if ( $menu_color != '' ) {
        $dt_menu_color = "
	.dt-main-menu li a,
	.dt-main-menu li:hover,
	.menu-item-has-children:after,
	.current-menu-item a,
	.dt-nav-md li a,
	.dt-nav-md .menu-item-has-children:after,
	.dt-logo-md a,
	.dt-nav-md-trigger {
		color: {$menu_color};
	}
	";
    } else {
        $dt_menu_color = '';
    }

    $menu_hover_bg	= get_theme_mod( 'easymag_menu_hover_bg_color', '#be3434' );

    if ( $menu_hover_bg != '' ) {
        $dt_menu_hover_bg = "
	.dt-main-menu li:hover,
	.dt-main-menu li a:hover,
	.dt-main-menu li.current-menu-item > a,
	.dt-nav-md li a:hover,
	.current-menu-item.menu-item-has-children {
		background: {$menu_hover_bg};
		color: #fff;
	}
	";
    } else {
        $dt_menu_hover_bg = '';
    }

    $menu_color_hover = get_theme_mod( 'easymag_menu_color_hover' );

    if ( $menu_color_hover != '' ) {
        $dt_menu_color_hover = "
	.dt-main-menu li:hover,
	.dt-main-menu li a:hover,
	.dt-main-menu li .current-menu-item > a,
	.dt-nav-md li a:hover ,
	.current-menu-item.menu-item-has-children:after,
	.current-menu-item.menu-item-has-children:hover:after,
	.menu-item-has-children:hover:after,
	.dt-main-menu li:hover > a {
		color: {$menu_color_hover};
	}
	";
    } else {
        $dt_menu_color_hover = '';
    }

    $dt_related_posts = 33.333333;

    $dt_related_posts_li = ".dt-related-posts li { width: calc({$dt_related_posts}% - 20px); }";

    $footer_bg_color = get_theme_mod( 'easymag_footer_bg_color', '#2f363e' );
    $footer_text_color = get_theme_mod( 'easymag_footer_text_color' );
	$footer_hover_color = get_theme_mod( 'easymag_footer_text_hover_color' );

    $footer  = ".dt-footer {background: $footer_bg_color}";
    if ( $footer_text_color ) {
	    $footer .= ".dt-footer, .dt-footer p, .dt-footer a, .dt-footer-cont li a, .dt-footer-bar, .dt-footer-bar a {color: $footer_text_color}";
    }
    if ( $footer_hover_color ) {
	    $footer .= ".dt-footer a:hover, .dt-footer-bar a:hover { color: $footer_hover_color !important;}";
    }

    $custom_css = $dt_color . $dt_font_size . $dt_primary_color . $dt_rgba . $dt_menu_bg . $dt_menu_color . $dt_menu_hover_bg . $dt_menu_color_hover . $dt_related_posts_li . $footer;

    wp_add_inline_style( 'easymag-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'easymag_customizer_styles' );

// Disables the block editor from managing widgets.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
add_filter( 'use_widgets_block_editor', '__return_false' );
