<?php
/**
 * EasyMag Theme Customizer.
 *
 * @package EasyMag
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function easymag_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';


    // Load custom controls
    require get_template_directory() . '/inc/customizer-controls.php';

	// Header Settings
	$wp_customize->add_panel( 'easymag_header_options',	array(
		'priority' 			=> 60,
		'title' 			=> __( 'Header', 'easymag' ),
		'description' 		=> __( 'Header Settings', 'easymag' ),
		'capabitity' 		=> 'edit_theme_options'
	) );

	// Sticky Menu
	$wp_customize->add_section( 'easymag_sticky_menu_section', array(
		'priority' 			=> 100,
		'title' 			=> __( 'Sticky Menu', 'easymag' ),
        'panel' 			=> 'easymag_header_options'
	) );

	$wp_customize->add_setting( 'easymag_sticky_menu', array(
		'default' 			=> 0,
		'capability' 		=> 'edit_theme_options',
		'sanitize_callback' => 'easymag_checkbox_sanitize'
	) );

	$wp_customize->add_control( 'easymag_sticky_menu', array(
		'type' 				=> 'checkbox',
		'label' 			=> __( 'Check to enable the sticky Main menu', 'easymag' ),
		'section' 			=> 'easymag_sticky_menu_section'
	) );


	$wp_customize->add_section( 'header_topbar', array(
		'title' 			=> __( 'Header Topbar', 'easymag' ),
		'panel' 			=> 'easymag_header_options'
	) );

	$wp_customize->add_setting( 'easymag_hide_date_setting', array(
		'default' 			=> '1',
		'capability' 		=> 'edit_theme_options',
		'sanitize_callback'	=> 'easymag_checkbox_sanitize'
	) );

	$wp_customize->add_control( 'easymag_hide_date', array(
		'type' 				=> 'checkbox',
		'label' 			=> __( 'Hide Header Date', 'easymag' ),
		'section' 			=> 'header_topbar',
		'settings' 			=> 'easymag_hide_date_setting'
	) );

    $wp_customize->add_setting( 'easymag_hide_weather', array(
        'default' 			=> false,
        'capability' 		=> 'edit_theme_options',
        'sanitize_callback'	=> 'easymag_checkbox_sanitize'
    ) );

    $wp_customize->add_control( 'easymag_hide_weather', array(
        'type' 				=> 'checkbox',
        'label' 			=> __( 'Hide Weather', 'easymag' ),
        'section' 			=> 'header_topbar',
    ) );


    $wp_customize->add_setting( 'easymag_weather_location', array(
        'default' 			=> 'London',
        'sanitize_callback'	=> 'sanitize_text_field'
    ) );

    $wp_customize->add_control( 'easymag_weather_location', array(
        'type' 				=> 'text',
        'label' 			=> __( 'Weather Location', 'easymag' ),
        'description' 		=> __( '<a href="http://openweathermap.org/find" target="_blank">Find your location</a> - You can use "city name" (ex: London) or "city name,country code" (ex: London,uk)', 'easymag' ),
        'section' 			=> 'header_topbar',
    ) );

    $wp_customize->add_setting( 'easymag_weather_unit', array(
        'default' 			=> 'c',
        'sanitize_callback'	=> 'sanitize_text_field'
    ) );


    $wp_customize->add_control( 'easymag_weather_unit', array(
        'type' 				=> 'select',
        'label' 			=> __( 'Weather Unit', 'easymag' ),
        'section' 			=> 'header_topbar',
        'choices' 			=> array(
            'c' => __( 'Celsius',"easymag" ),
            'f' => __( 'Fahrenheit',"easymag" ),
        )
    ) );

	// Main Menu Color
	$wp_customize->add_section( 'easymag_menu_color_section', array(
		'priority' 			=> 3,
		'title' 			=> __( 'Menu Color', 'easymag' ),
		'panel'				=> 'colors'
	) );

	$wp_customize->add_setting( 'easymag_menu_color', array(
		'priority' 			     => 6,
		'default' 			     => '#ffffff',
		'capability' 			 => 'edit_theme_options',
		'sanitize_callback'		 => 'easymag_color_sanitize',
		'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
	) );

	// Main Menu Color
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'easymag_menu_color_picker', array(
		'label' 		=> __( 'Menu Font Color', 'easymag' ),
		'section' 		=> 'colors',
		'settings' 		=> 'easymag_menu_color'
	) ) );

	$wp_customize->add_setting(	'easymag_menu_bg_color', array(
		'priority' 				 => 7,
		'default' 				 => '#cf4141',
		'capability' 			 => 'edit_theme_options',
		'sanitize_callback'		 => 'easymag_color_sanitize',
		'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
	) );

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_menu_bg_color_picker',
			array(
				'label' 			=> __( 'Menu Background', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_menu_bg_color'
			)
		)
	);

	$wp_customize->add_setting(
		'easymag_menu_color_hover',
		array(
			'priority' 			     => 8,
			'default' 			     => '#ffffff',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_menu_hover_color_picker',
			array(
				'label' 			=> __( 'Menu Hover Font Color', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_menu_color_hover'
			)
		)
	);

	$wp_customize->add_setting(
		'easymag_menu_hover_bg_color',
		array(
			'priority' 				 => 9,
			'default' 				 => '#be3434',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_menu_hover_bg_color_picker',
			array(
				'label' 			=> __( 'Menu Hover Background', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_menu_hover_bg_color'
			)
		)
	);

	/* Footer backgounr color */
	$wp_customize->add_setting(
		'easymag_footer_bg_color',
		array(
			'priority' 				 => 9,
			'default' 				 => '#2f363e',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_footer_bg_color',
			array(
				'label' 			=> __( 'Footer Main Background', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_footer_bg_color'
			)
		)
	);
	$wp_customize->add_setting(
		'easymag_footer_text_color',
		array(
			'priority' 				 => 9,
			'default' 				 => '#ffffff',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_footer_text_color',
			array(
				'label' 			=> __( 'Footer Text Color', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_footer_text_color'
			)
		)
	);
	$wp_customize->add_setting(
		'easymag_footer_text_hover_color',
		array(
			'priority' 				 => 9,
			'default' 				 => '#cc2936',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_footer_text_hover_color',
			array(
				'label' 			=> __( 'Footer Text Hover Color', 'easymag' ),
				'section' 			=> 'colors',
				'settings' 			=> 'easymag_footer_text_hover_color'
			)
		)
	);

	// Layout and Content
	$wp_customize->add_panel(
		'easymag_layout_options',
		array(
			'capabitity' 		=> 'edit_theme_options',
			'description' 		=> __( 'Layout and Content Settings', 'easymag' ),
			'priority' 			=> 201,
			'title' 			=> __( 'Layout and Content', 'easymag' )
		)
	);



	// Website Default Layout
	$wp_customize->add_section(
		'easymag_website_layout',
		array(
			'priority' 			=> 1,
			'title' 			=> __( 'Website Layout', 'easymag' ),
			'panel'				=> 'easymag_layout_options'
		)
	);

	$wp_customize->add_setting(
		'easymag_default_layout',
		array(
			'default' 			=> 'boxed_layout',
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback' => 'easymag_site_layout_sanitize'
		)
	);

	$wp_customize->add_control( 'easymag_default_layout', array(
		'type'			 	=> 'radio',
		'label' 			=> __( 'Choose layout: The change will make to whole site', 'easymag' ),
		'choices' 			=> array(
			'boxed_layout'  => __( 'Boxed Layout', 'easymag' ),
			'wide_layout'  	=> __( 'Wide Layout', 'easymag' )
		),
		'section'			=> 'easymag_website_layout',
		'settings' 			=> 'easymag_default_layout'
	) );

	// Website Default Layout
	$wp_customize->add_section(
		'easymag_website_layout',
		array(
			'priority' 			=> 1,
			'title' 			=> __( 'Website Layout', 'easymag' ),
			'panel'				=> 'easymag_layout_options'
		)
	);

	$wp_customize->add_setting(
		'easymag_default_layout',
		array(
			'default' 			=> 'wide_layout',
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback' => 'easymag_site_layout_sanitize'
		)
	);

	$wp_customize->add_control(
		'easymag_default_layout',
		array(
			'type'			 	=> 'radio',
			'label' 			=> __( 'Choose layout: The change will make to whole site', 'easymag' ),
			'choices' 			=> array(
				'boxed_layout'  => __( 'Boxed Layout', 'easymag' ),
				'wide_layout'  	=> __( 'Wide Layout', 'easymag' )
			),
			'section'			=> 'easymag_website_layout',
			'settings' 			=> 'easymag_default_layout'
		)
	);

	// Related Posts
	$wp_customize->add_section(
		'easymag_related_posts_section',
		array(
			'priority' 			=> 4,
			'title' 			=> __( 'Related Posts', 'easymag' ),
			'panel' 			=> 'easymag_layout_options',
		)
	);

	$wp_customize->add_setting(
		'easymag_related_posts_setting',
		array(
			'default' 			=> 0,
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback'	=> 'easymag_checkbox_sanitize'
		)
	);

	$wp_customize->add_control(
		'easymag_related_posts',
		array(
			'type' 				=> 'checkbox',
			'label' 			=> __( 'Check to activate the related posts', 'easymag' ),
			'section' 			=> 'easymag_related_posts_section',
			'settings' 			=> 'easymag_related_posts_setting'
		)
	);

	// Default Font Size
	$wp_customize->add_section(
		'easymag_font_size_section',
		array(
			'priority' 			=> 5,
			'title' 			=> __( 'Default Font Size', 'easymag' ),
			'panel'				=> 'easymag_layout_options'
		)
	);

	$wp_customize->add_setting(
		'easymag_font_size',
		array(
			'default' 			=> '15',
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback' => 'easymag_sanitize_integer'
		)
	);

	$wp_customize->add_control(
		'easymag_font_size',
		array(
			'type'			 	=> 'number',
			'label' 			=> __( 'Set Default Font Size', 'easymag' ),
			'section'			=> 'easymag_font_size_section',
			'settings' 			=> 'easymag_font_size'
		)
	);

	// Font Colors
	$wp_customize->add_section(
		'easymag_font_color_section',
		array(
			'priority' 			=> 6,
			'title' 			=> __( 'Font Color', 'easymag' ),
			'panel'				=> 'easymag_layout_options'
		)
	);

	$wp_customize->add_setting(
		'easymag_font_color',
		array(
			'default' 			     => '#2f363e',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_font_color',
			array(
				'label' 		=> __( 'Font Color', 'easymag' ),
				'section' 		=> 'colors',
				'settings' 		=> 'easymag_font_color'
			)
		)
	);

	// Primary Color
	$wp_customize->add_setting(
		'easymag_primary_color',
		array(
			'default' 			     => '#cc2936',
			'capability' 			 => 'edit_theme_options',
			'sanitize_callback'		 => 'easymag_color_sanitize',
			'sanitize_js_callback'   => 'easymag_color_escaping_sanitize'
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'easymag_primary_color',
			array(
				'label' 		=> __( 'Primary Color', 'easymag' ),
				'section' 		=> 'colors',
				'settings' 		=> 'easymag_primary_color'
			)
		)
	);

    // Footer Settings
    $wp_customize->add_section(
        'footer',
        array(
            'title' => esc_html__('Footer', 'easymag'),
        )
    );

   

        $wp_customize->add_setting( 'footer_credit', array(
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new EasyMag_Group_Settings_Heading_Control(
                $wp_customize,
                'footer_credit',
                array(
                    'label'      => esc_html__( 'Footer Settings', 'easymag' ),
                    'description' => sprintf( esc_html__( 'Upgrade to %1$s to change footer copyright and credit', 'easymag' ), '<a href="https://www.famethemes.com/themes/easymag-pro/#pricing">'.esc_html__( 'EasyMag Pro version', 'easymag' ).'</a>' ),
                    'section'    => 'footer',
                    'type'    => 'group_heading_message',
                )
            )
        );

    


   
        $wp_customize->add_section( 'easymag_premium' ,
            array(
                'title'       => esc_html__( 'Upgrade to EasyMag Pro', 'easymag' ),
                'description' => '',
                'priority'  => 215,
            )
        );

        $wp_customize->add_setting( 'easymag_premium_features', array(
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new EasyMag_Group_Settings_Heading_Control(
                $wp_customize,
                'easymag_premium_features',
                array(
                    'label'      => esc_html__( 'EasyMag Pro Features', 'easymag' ),
                    'description'   => '<span>Advanced Typography</span><span>600+ Google Fonts</span><span>Advanced widget post tabs filter</span><span>Footer Copyright Editor</span><span>Remove Theme Credit</span><span>Navigation Ajax</span><span>Multiple Category Selection</span><span>... and much more </span>',
                    'section'    => 'easymag_premium',
                    'type'    => 'group_heading_message',
                )
            )
        );
        $wp_customize->add_setting( 'easymag_premium_links', array(
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control(
            new EasyMag_Group_Settings_Heading_Control(
                $wp_customize,
                'easymag_premium_links',
                array(
                    'description'   => '<a target="_blank" class="easymag-premium-buy-button" href="https://www.famethemes.com/themes/easymag-pro/#download_pricing">Buy EasyMag Pro Now</a>', 'easymag',
                    'section'    => 'easymag_premium',
                    'type'    => 'group_heading_message',
                )
            )
        );
    

	// Checkbox Sanitize
	function easymag_checkbox_sanitize( $input ) {
		if ( $input == 1 ) {
			return 1;
		} else {
			return '';
		}
	}

	// Color Sanitizate
	function easymag_color_sanitize( $color ) {
		if ( $unhashed = sanitize_hex_color_no_hash( $color ))
			return '#' . $unhashed;

		return $color;
	}

	// Color Escape Sanitize
	function easymag_color_escaping_sanitize( $input ) {
		$input = esc_attr( $input );
		return $input;
	}

	// Layout Sanitize
	function easymag_site_layout_sanitize( $input ) {
		$valid_keys = array(
			'boxed_layout' => __( 'Boxed Layout', 'easymag' ),
			'wide_layout'  => __( 'Wide Layout', 'easymag' )
		);

		if ( array_key_exists( $input, $valid_keys ) ) {
			return $input;
		} else {
			return '';
		}
	}

	// Page Layout Sanitize
	function easymag_page_layout_sanitize( $input ) {
		$valid_keys = array(
			'right_sidebar' => __( 'Right Sidebar', 'easymag'),
			'left_sidebar'  => __( 'Left Sidebar', 'easymag' ),
			'full_width'  	=> __( 'Full Width', 'easymag' )
		);

		if ( array_key_exists( $input, $valid_keys ) ) {
			return $input;
		} else {
			return '';
		}
	}

	// Number Integer
	function easymag_sanitize_integer( $input ) {
		return absint( $input );
	}

}
add_action( 'customize_register', 'easymag_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function easymag_customize_preview_js() {
	wp_enqueue_script( 'easymag_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'easymag_customize_preview_js' );

function easymag_customize_js_settings(){
    wp_register_style( 'easymag-customizer-controls',  get_template_directory_uri() . '/css/customizer.css' );
    wp_enqueue_style('easymag-customizer-controls');
}
add_action( 'customize_controls_enqueue_scripts', 'easymag_customize_js_settings' );
