<?php
/**
 * EasyBlog Theme Customizer.
 *
 * @package EasyBlog
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function easyblog_customize_register( $wp_customize ) {
//	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
//	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	// Primary Color
	$wp_customize->add_setting( 'easyblog_primary_color', array(
		'priority' 			     => 6,
		'default' 			     => '#17bebb',
		'capability' 			 => 'edit_theme_options',
		'sanitize_callback'		 => 'easyblog_color_sanitize',
		'sanitize_js_callback'   => 'easyblog_color_escaping_sanitize'
	) );

	$wp_customize->add_control(	new WP_Customize_Color_Control(	$wp_customize, 'easyblog_primary_color_picker', array(
		'label' 		=> __( 'Primary Color', 'easyblog' ),
		'section' 		=> 'colors',
		'settings' 		=> 'easyblog_primary_color'
	) ) );

	// Color Sanitize
	function easyblog_color_sanitize( $color ) {
		if ( $unhashed = sanitize_hex_color_no_hash( $color ))
			return '#' . $unhashed;

		return $color;
	}

	// Related Posts
	$wp_customize->add_section(
		'easyblog_related_posts_section',
		array(
			'title' 			=> __( 'Related Posts', 'easyblog' )
		)
	);

	$wp_customize->add_setting(
		'easyblog_related_posts_setting',
		array(
			'default' 			=> 0,
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback'	=> 'easyblog_checkbox_sanitize'
		)
	);

	$wp_customize->add_control(
		'easyblog_related_posts',
		array(
			'type' 				=> 'checkbox',
			'label' 			=> __( 'Check to activate the related posts', 'easyblog' ),
			'section' 			=> 'easyblog_related_posts_section',
			'settings' 			=> 'easyblog_related_posts_setting'
		)
	);

	// Color Escape Sanitize
	function easyblog_color_escaping_sanitize( $input ) {
		$input = esc_attr( $input );
		return $input;
	}

	// Checkbox Sanitize
	function easyblog_checkbox_sanitize( $input ) {
		if ( $input == 1 ) {
			return 1;
		} else {
			return '';
		}
	}
}
add_action( 'customize_register', 'easyblog_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function easyblog_customize_preview_js() {
	wp_enqueue_script( 'easyblog_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'easyblog_customize_preview_js' );

/**
 * Enqueue Inline styles generated by customizer
 */
function easyblog_customizer_styles() {

	$primary_color = esc_attr( get_theme_mod( 'easyblog_primary_color' ) );

	if ( $primary_color != '' && $primary_color != '#17bebb' ) {
		$primary_color_elements = "
	a:hover,
	.dt-logo h1 a,
	.dt-pagination-nav a:hover,
	.dt-pagination-nav .current:hover,
	.dt-pagination-nav .current,
	.entry-meta a:hover,
	.entry-footer a:hover,
	.dt-footer-bar a:hover {
		color: {$primary_color};
	}

	.dt-menu-wrap li:hover > a,
	.dt-menu-wrap .current-menu-item a {
		color: {$primary_color} !important;
	}

	.dt-archive-post .entry-footer a:hover,
	#secondary h2:after,
	.tagcloud a:hover,
	#back-to-top:hover,
	.dt-related-posts .dt-news-post-img .fa:hover {
		background: {$primary_color};
	}

	.dt-pagination-nav a:hover,
	.dt-pagination-nav .current:hover,
	.dt-pagination-nav .current {
		border-color: {$primary_color};
	}

	";
	} else {
		$primary_color_elements = '';
	}

	$header_text_color = get_header_textcolor();

	if ( $header_text_color != '' && $header_text_color != '000000' ) {
		$header_text_colors = "
	.dt-logo h1 a {
		color: #{$header_text_color};
	}	
		";
	} else {
		$header_text_colors = '';
	}

	$dt_related_posts = 33.333333;

	$dt_related_posts_li = ".dt-related-posts li { width: calc({$dt_related_posts}% - 20px); }";

	$custom_css = $primary_color_elements . $header_text_colors . $dt_related_posts_li;

	wp_add_inline_style( 'easyblog-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'easyblog_customizer_styles' );
