<?php
/**
 * Easify Theme Setup
 *
 */
function easify_theme_style() {
	$easify_parent_style = 'fasterly-style';
	wp_enqueue_style( $easify_parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'easify-style', get_stylesheet_uri(), array( $easify_parent_style ));
}
add_action( 'wp_enqueue_scripts', 'easify_theme_style',999);
   	

/*==================================================================================
 Easify  Header Navigation
==================================================================================*/
if ( ! function_exists( 'easify_primary_navigation' ) ) :
function easify_primary_navigation() {
	wp_nav_menu( 
		array(  
			'theme_location' => 'primary_menu',
			'container'  => '',
			'menu_class' => 'main-menu menu-effect-1',
			'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
			'walker' => new WP_Bootstrap_Navwalker()
			 ) 
		);
	} 
endif;


/*==================================================================================
 Easify  Custom Header
==================================================================================*/
function easify_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'easify_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '002a34',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'fasterly_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'easify_custom_header_setup' );


/**
 * Remove Customize Panel from parent theme
 */
function easify_remove_parent_setting( $wp_customize ) {
	$wp_customize->remove_control('fasterly_theme_footer_copy_head');	
	$wp_customize->remove_control('fasterly_theme_hs_footer_copy');	
	$wp_customize->remove_control('fasterly_theme_footer_s_head');	
	$wp_customize->remove_control('fasterly_theme_hs_footer_social');
	$wp_customize->remove_control('fasterly_theme_footer_social_ttl');	
	$wp_customize->remove_control('fasterly_theme_footer_social_icons');	
}
add_action( 'customize_register', 'easify_remove_parent_setting',99 );

/**
 * Import Options From Parent Theme
 *
 */
function easify_parent_theme_options() {
	$fasterly_mods = get_option( 'theme_mods_fasterly' );
	if ( ! empty( $fasterly_mods ) ) {
		foreach ( $fasterly_mods as $fasterly_mod_k => $fasterly_mod_v ) {
			set_theme_mod( $fasterly_mod_k, $fasterly_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'easify_parent_theme_options' );

require get_stylesheet_directory() . '/inc/customizer/customizer-upsale/class-customize.php';