<?php

//$content_width is required even though this is a variable-width theme
if ( ! isset( $dw_iconis_content_width ) ) {
	$dw_iconis_content_width = 400;
}

function dw_iconis_sanitize_html( $html ) {
	return wp_filter_post_kses( $html );
}

function dw_iconis_sanitize_checkbox( $input ) {
	return ( ( isset( $input ) && true === $input ) ? true : false );
}

//makes replying look neat
if ( ! function_exists( 'dw_iconis_threaded_comments' ) ) :
	function dw_iconis_threaded_comments() {
		if ( get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	add_action( 'wp_enqueue_scripts', 'dw_iconis_threaded_comments' );
endif;

// displays "Comments are closed" instead of comment form when comments are closed.
if ( ! function_exists( 'dw_iconis_closed_comments' ) ) :
	function dw_iconis_closed_comments() {
		echo '<p>', esc_html__( 'Comments are closed.', 'dw-iconis' ), '</p>';
	}
	add_action( 'comment_form_comments_closed', 'dw_iconis_closed_comments' );
endif;

if ( ! function_exists( 'dw_iconis_setup' ) ) :
	function dw_iconis_setup() {
		load_theme_textdomain( 'dw-iconis', get_template_directory() . '/languages' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 200,
				'width'       => 672,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
		add_theme_support( 'title-tag' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'customize-selective-reiconis-widgets' );
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 150, 150 );
		add_image_size( 'dw-iconis-single-post-thumbnail', 9999, 9999 );
		add_image_size( 'dw-iconis-homepage-featured', 350, 350 );
		add_theme_support(
			'starter-content',
			array(
				'widgets' => array(
					'left-sidebar'  => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'First Sidebar', 'dw-iconis' ),
								'text'  => _x( 'This is some text in the first sidebar.', 'Theme Starter Content', 'dw-iconis' ),
							),
						),
					),
					'right-sidebar' => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'Second Sidebar', 'dw-iconis' ),
								'text'  => _x( 'This is some text in the second sidebar.', 'Theme Starter Content', 'dw-iconis' ),
							),
						),
					),
					'center-block'  => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'Center Block', 'dw-iconis' ),
								'text'  => _x( 'This is some text in the center block.', 'Theme Starter Content', 'dw-iconis' ),
							),
						),
					),
				),
			)
		);
	}
	add_action( 'after_setup_theme', 'dw_iconis_setup' );
endif;

if ( ! function_exists( 'dw_iconis_register_menu' ) ) :
	function dw_iconis_register_menu() {
		register_nav_menus(
			array(
				'top_header_menu' => esc_html__( 'Top Header Menu', 'dw-iconis' ),
			)
		);
	}
	add_action( 'init', 'dw_iconis_register_menu' );
endif;

if ( ! function_exists( 'dw_iconis_stylesheet' ) ) :
	function dw_iconis_stylesheet() {
		wp_enqueue_style( 'dw-iconis-style', get_stylesheet_directory_uri() . '/style.css', array(), wp_get_theme()->version );
	}
	add_action( 'wp_enqueue_scripts', 'dw_iconis_stylesheet' );
endif;

if ( ! function_exists( 'dw_iconis_sidebars' ) ) :
	// register the sidebars
	function dw_iconis_sidebars() {
		register_sidebar(
			array(
				'name' => __( 'Left Sidebar 1', 'dw-iconis' ),
				'id'   => 'left-sidebar',
			)
		);
		register_sidebar(
			array(
				'name' => __( 'Center Block 1', 'dw-iconis' ),
				'id'   => 'center-block',
			)
		);
		register_sidebar(
			array(
				'name' => __( 'Right Sidebar 1', 'dw-iconis' ),
				'id'   => 'right-sidebar',
			)
		);
	}
	add_action( 'widgets_init', 'dw_iconis_sidebars' );
endif;

// display information about a post under the post title
if ( ! function_exists( 'dw_iconis_post_meta' ) ) :
	function dw_iconis_post_meta() {
		echo '<div class="meta">';
		if ( get_post_type() === 'page' ) :
			printf(
				/* translators: %s = author */
				esc_html__( 'Posted by %s', 'dw-iconis' ),
				get_the_author()
			);
		elseif ( has_category() ) :
			printf(
				/* translators: %1$s = date, %2$s = categories, %3$s = author */
				esc_html__( 'Posted on %1$s in %2$s by %3$s', 'dw-iconis' ),
				get_the_date(),
				wp_kses_post( get_the_category_list( ',' ) ),
				get_the_author()
			);
		else :
			printf(
				/* translators: %1$s = date, %2$s = author */
				esc_html__( 'Posted on %1$s by %2$s', 'dw-iconis' ),
				get_the_date(),
				get_the_author()
			);
		endif;
		edit_post_link( _x( 'Edit', 'verb', 'dw-iconis' ), ' | ' );
		if ( get_post_type() !== 'page' && has_tag() ) :
			echo '<br>';
			the_tags();
		endif;
		echo '</div>';
	}
endif;

// change the archive title to show the search query when showing the archive title on a search result page.
if ( ! function_exists( 'dw_iconis_search_title' ) ) :
	function dw_iconis_search_title( $title ) {
		if ( is_search() ) {
			/* translators: %s = search query */
			$title = sprintf( __( 'Search: %s', 'dw-iconis' ), get_search_query() );
		}
		return $title;
	}
	add_filter( 'get_the_archive_title', 'dw_iconis_search_title' );
endif;

function dw_iconis_google_fonts() {
	wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css2?family=Electrolize&display=swap', array(), wp_get_theme()->version );
}
add_action( 'wp_enqueue_scripts', 'dw_iconis_google_fonts' );

/**
 * Enqueue scripts
 */
function dw_iconis_enqueue_scripts() {
	wp_enqueue_script( 'dw-iconis-header-clock', get_template_directory_uri() . '/js/dw-iconis-header-clock.js', array(), wp_get_theme()->version, true );
	wp_enqueue_script( 'dw-iconis-top-button', get_template_directory_uri() . '/js/dw-iconis-top-button.js', array(), wp_get_theme()->version, true );
	wp_enqueue_script( 'dw-iconis-navigation', get_template_directory_uri() . '/js/dw-iconis-navigation.js', array( 'jquery' ), '20141205', true );
}
add_action( 'wp_enqueue_scripts', 'dw_iconis_enqueue_scripts' );

// Add Footer Text Box section to customize
function dw_iconis_fcontent( $wp_customize ) {
	$wp_customize->add_section(
		'dw-iconis-fcontent-section',
		array(
			'title' => __( 'Footer Text Box', 'dw-iconis' ),
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-fcontent-text-control',
			array(
				'type'        => 'button',
				'settings'    => array(),
				'label'       => __( 'Get this feature with premium!', 'dw-iconis' ),
				'priority'    => 10,
				'section'     => 'dw-iconis-fcontent-section',
				'input_attrs' => array(
					'value'   => __( 'Click Here!', 'dw-iconis' ),
					'class'   => 'button-secondary',
					'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
				),
			)
		)
	);
}

add_action( 'customize_register', 'dw_iconis_fcontent' );

// Premium Upgrade Section
function dw_iconis_procontent(
	$wp_customize ) {
	$wp_customize->add_section(
		'pro_sec',
		array(
			'title'       => __( 'GET PREMIUM VERSION', 'dw-iconis' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		'button_id',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'BUY PREMIUM VERSION', 'dw-iconis' ),
				'class'   => 'button-primary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'label'       => __( 'Premium Features:', 'dw-iconis' ),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( '12 More Widget Blocks', 'dw-iconis' ),
				'class'   => 'button-secondary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label1',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'Footer HTML/Text Content Area', 'dw-iconis' ),
				'class'   => 'button-secondary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label2',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'Top Header and Bottom Footer Length Widget Area', 'dw-iconis' ),
				'class'   => 'button-secondary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label3',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'bbPress Matching Forum Style', 'dw-iconis' ),
				'class'   => 'button-secondary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label4',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'And More!', 'dw-iconis' ),
				'class'   => 'button-secondary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

	$wp_customize->add_control(
		'label5',
		array(
			'type'        => 'button',
			'settings'    => array(),
			'label'       => __( 'FOR MORE DW THEMES:', 'dw-iconis' ),
			'priority'    => 10,
			'section'     => 'pro_sec',
			'input_attrs' => array(
				'value'   => __( 'CLICK HERE!', 'dw-iconis' ),
				'class'   => 'button-primary',
				'onclick' => "window.open('https://www.designwicked.com/store/premium-grayscale', '_blank')",
			),
		)
	);

}

	add_action( 'customize_register', 'dw_iconis_procontent' );

// Header Nav
function dw_iconis_hnav( $wp_customize ) {
	$wp_customize->add_section(
		'dw-iconis-hnav-section',
		array(
			'title' => esc_html__( 'Header Navigation', 'dw-iconis' ),
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-linkname1',
		array(
			'default'           => esc_html__( 'Link 1', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-linkname1',
			array(
				'label'       => esc_html__( 'Link 1 Name:', 'dw-iconis' ),
				'section'     => 'dw-iconis-hnav-section',
				'description' => esc_html__( 'The visible name of the link on the button.', 'dw-iconis' ),
				'settings'    => 'dw-iconis-hnav-linkname1',
				'type'        => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-link1',
		array(
			'default'           => esc_html__( 'http://', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-link1',
			array(
				'label'       => esc_html__( 'Link 1 Address:', 'dw-iconis' ),
				'section'     => 'dw-iconis-hnav-section',
				'description' => esc_html__( 'You can use /address to point to a directory, or just put a full link including http://', 'dw-iconis' ),
				'settings'    => 'dw-iconis-hnav-link1',
				'type'        => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-linkname2',
		array(
			'default'           => esc_html__( 'Link 2', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-linkname2',
			array(
				'label'    => esc_html__( 'Link 2 Name:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-linkname2',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-link2',
		array(
			'default'           => esc_html__( 'http://', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-link2',
			array(
				'label'    => esc_html__( 'Link 2 Address:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-link2',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-linkname3',
		array(
			'default'           => esc_html__( 'Link 3', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-linkname3',
			array(
				'label'    => esc_html__( 'Link 3 Name:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-linkname3',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-link3',
		array(
			'default'           => esc_html__( 'http://', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-link3',
			array(
				'label'    => esc_html__( 'Link 3 Address:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-link3',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-linkname4',
		array(
			'default'           => esc_html__( 'Link 4', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-linkname4',
			array(
				'label'    => esc_html__( 'Link 4 Name:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-linkname4',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-link4',
		array(
			'default'           => esc_html__( 'http://', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-link4',
			array(
				'label'    => esc_html__( 'Link 4 Address:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-link4',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-linkname5',
		array(
			'default'           => esc_html__( 'Link 5', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-linkname5',
			array(
				'label'    => esc_html__( 'Link 5 Name:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-linkname5',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-iconis-hnav-link5',
		array(
			'default'           => esc_html__( 'http://', 'dw-iconis' ),
			'sanitize_callback' => 'dw_iconis_sanitize_html',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-iconis-hnav-control-link5',
			array(
				'label'    => esc_html__( 'Link 5 Address:', 'dw-iconis' ),
				'section'  => 'dw-iconis-hnav-section',
				'settings' => 'dw-iconis-hnav-link5',
				'type'     => 'text',
			)
		)
	);
}
add_action( 'customize_register', 'dw_iconis_hnav' );

function dw_iconis_search_form( $form ) {
	$form = '<form method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <input type="text" value="' . get_search_query() . '" name="s" placeholder="What can we help you find?">
    <button type="submit">Search</button>
    </form>';

		return $form;
}

add_filter( 'get_search_form', 'dw_iconis_search_form' );
