<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div class="header-footer-bg">
<div id="header">

<nav role="navigation" id="skip" aria-label="<?php echo esc_attr_x( 'Skip links', 'ARIA label', 'dw-caution' ); ?>">

	<?php if ( is_active_sidebar( 'left-sidebar' ) ) : ?>

	<a class="tab-shortcut" id="shortcut-left-sidebar" href="#left"><?php is_active_sidebar( 'right-sidebar' ) ? esc_html_e( 'Skip to first sidebar', 'dw-caution' ) : esc_html_e( 'Skip to sidebar', 'dw-caution' ); ?></a>

	<?php endif; ?>

	<a class="tab-shortcut" id="shortcut-content" href="#content"><?php esc_html_e( 'Skip to content', 'dw-caution' ); ?></a>

	<?php if ( is_active_sidebar( 'right-sidebar' ) ) : ?>

	<a class="tab-shortcut" id="shortcut-right-sidebar" href="#right"><?php is_active_sidebar( 'left-sidebar' ) ? esc_html_e( 'Skip to second sidebar', 'dw-caution' ) : esc_html_e( 'Skip to sidebar', 'dw-caution' ); ?></a>

	<?php endif; ?>

</nav> <!-- /skip -->

<div id="container">

<header role="banner">

<!------------------------------------------Header section starts------------------------------------------>
<div class="hd-body">
			<div class="hd-row1">
				<div class="hd-row1-inner-1"></div>
			</div>
			<div class="hd-row2">
				<div class="hd-row2-inner-1">
				<a class="hd-row2-nav-link-1" href="<?php echo esc_url( get_theme_mod( 'dw-caution-hnav-link1' ) ); ?>"><div class="hdmainnav"><?php echo esc_html( get_theme_mod( 'dw-caution-hnav-linkname1' ) ); ?></div></a>
				<a class="hd-row2-nav-link-2" href="<?php echo esc_url( get_theme_mod( 'dw-caution-hnav-link2' ) ); ?>"><div class="hdmainnav"><?php echo esc_html( get_theme_mod( 'dw-caution-hnav-linkname2' ) ); ?></div></a>
				<a class="hd-row2-nav-link-3" href="<?php echo esc_url( get_theme_mod( 'dw-caution-hnav-link3' ) ); ?>"><div class="hdmainnav"><?php echo esc_html( get_theme_mod( 'dw-caution-hnav-linkname3' ) ); ?></div></a>
				<a class="hd-row2-nav-link-4" href="<?php echo esc_url( get_theme_mod( 'dw-caution-hnav-link4' ) ); ?>"><div class="hdmainnav"><?php echo esc_html( get_theme_mod( 'dw-caution-hnav-linkname4' ) ); ?></div></a>
				<a class="hd-row2-nav-link-5" href="<?php echo esc_url( get_theme_mod( 'dw-caution-hnav-link5' ) ); ?>"><div class="hdmainnav"><?php echo esc_html( get_theme_mod( 'dw-caution-hnav-linkname5' ) ); ?></div></a>
				</div>
				<div class="hd-row2-inner-2"></div>
				<div class="hd-row2-inner-3"></div>
				<div class="hd-row2-inner-4"></div>
				<div class="hd-row2-inner-5">
				<div class="userlog">
				<?php 
				if ( is_user_logged_in() ) {
					/* translators: %s = Logout URL */
					$dw_caution_html_message = sprintf( __( 'Welcome, you are logged in. <a href="%s">Logout?</a>', 'dw-caution' ), esc_url( wp_login_url() ) );
					echo wp_kses_post( $dw_caution_html_message );
				} else {
					/* translators: %s = Login URL */
					$dw_caution_html_message = sprintf( __( 'Welcome, Log in by clicking <a href="%s">&nbsp;Here!</a>', 'dw-caution' ), esc_url( wp_login_url() ) );
					echo wp_kses_post( $dw_caution_html_message );
				} 
				?>
				</div>
				</div>
			</div>
			<div class="hd-row3">
				<div class="hd-row3-inner-1"></div>
				<div class="hd-row3-inner-2"></div>
				<div class="hd-row3-inner-3">
				<div id="headerlogo">
					<a href="<?php echo esc_url( home_url() ); ?>">
					<?php
					$dw_caution_custom_logo_id = get_theme_mod( 'custom_logo' );
					$dw_caution_logo           = wp_get_attachment_image_src( $dw_caution_custom_logo_id, 'full' );
					
					if ( has_custom_logo() ) {
						echo '<img src="' . esc_url( $dw_caution_logo[0] ) . '" alt="' . esc_html( get_bloginfo( 'name' ) ) . '">';
					} else {
						echo '<div id="blog-name">' . esc_html( get_bloginfo( 'name' ) ) . '</div>';
						echo '<div id="blog-tagline">' . esc_html( get_bloginfo( 'description' ) ) . '</div>';
					}
					?>
					</a>
				</div> <!-- /headerlogo -->
				</div>
			</div>
			<div class="hd-row4">
				<div class="hd-row4-inner-1"></div>
				<div class="hd-row4-inner-2"></div>
				<div class="hd-row4-inner-3"></div>
				<div class="hd-row4-inner-4">
				<div class="datetime">
					<div id="dw-caution-digital-clock"></div>
				</div>
				</div>
			</div>
			<div class="hd-row5">
				<div class="hd-row5-inner"></div>
			</div>
</div>

<!------------------------------------------Header section ends------------------------------------------>

</header>

<div id="main-body">

<div id="wrapper">

<?php

wp_nav_menu(
	array(
		'theme_location'       => 'top_header_menu',
		'menu_id'              => 'header-menu-content',
		'fallback_cb'          => false,
		'depth'                => 2,
		'container'            => 'nav',
		'container_id'         => 'header-menu',
		'container_aria_label' => _x( 'Header Menu', 'ARIA label', 'dw-caution' ),
	)
);

?>

	<div id="responsive">
	<div id="widgetcorral">
	<!---BEGIN LEFT SIDEBARS--->

	<?php if ( is_active_sidebar( 'left-sidebar' ) ) : ?>

	<!-- begin left sidebar -->
	<div class="side-blocks">
	<div class="block-top"></div>
	<div class="block-content">
		<div class="block-content-inner">
		<aside role="complementary" id="left" class="sidebar" aria-label="<?php echo is_active_sidebar( 'right-sidebar' ) ? esc_attr_x( 'Left Sidebar', 'ARIA label', 'dw-caution' ) : esc_attr_x( 'Sidebar', 'ARIA label', 'dw-caution' ); ?>">

<ul>
		<?php dynamic_sidebar( 'left-sidebar' ); ?>
</ul>

</aside>
</div>
	</div>

	<div class="block-pos-4"></div>

</div>
	<!-- end left sidebar -->

<?php endif; ?>
</div> <!---END WIDGET CORRAL--->

	<div id="content">
		<main id="main" role="main">
