<?php

//$content_width is required even though this is a variable-width theme
if ( ! isset( $dw_caution_content_width ) ) {
	$dw_caution_content_width = 400;
}

//makes replying look neat
if ( ! function_exists( 'dw_caution_threaded_comments' ) ) :
	function dw_caution_threaded_comments() {
		if ( get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	add_action( 'wp_enqueue_scripts', 'dw_caution_threaded_comments' );
endif;

// displays "Comments are closed" instead of comment form when comments are closed.
if ( ! function_exists( 'dw_caution_closed_comments' ) ) :
	function dw_caution_closed_comments() {
		echo '<p>', esc_html__( 'Comments are closed.', 'dw-caution' ), '</p>';
	}
	add_action( 'comment_form_comments_closed', 'dw_caution_closed_comments' );
endif;

if ( ! function_exists( 'dw_caution_setup' ) ) :
	function dw_caution_setup() {
		load_theme_textdomain( 'dw-caution', get_template_directory() . '/languages' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 190,
				'width'       => 190,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
		add_theme_support( 'title-tag' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 50, 50 );
		add_image_size( 'single-post-thumbnail', 9999, 9999 );
		add_image_size( 'homepage-featured', 150, 150, true );
		add_theme_support(
			'starter-content', 
			array(
				'widgets' => array(
					'left-sidebar'  => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'First Sidebar', 'dw-caution' ),
								'text'  => _x( 'This is some text in the first sidebar.', 'Theme Starter Content', 'dw-caution' ),
							),
						),
					),
					'right-sidebar' => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'Second Sidebar', 'dw-caution' ),
								'text'  => _x( 'This is some text in the second sidebar.', 'Theme Starter Content', 'dw-caution' ),
							),
						),
					),
					'center-block' => array(
						array(
							'text',
							array(
								'title' => esc_html__( 'Center Block', 'dw-caution' ),
								'text'  => _x( 'This is some text in the center block.', 'Theme Starter Content', 'dw-caution' ),
							),
						),
					),
				),
			)
		);
	}
	add_action( 'after_setup_theme', 'dw_caution_setup' );
endif;

if ( ! function_exists( 'dw_caution_register_menu' ) ) :
	function dw_caution_register_menu() {
		register_nav_menus(
			array(
				'top_header_menu' => esc_html__( 'Top Header Menu', 'dw-caution' ),
			)
		);
	}
	add_action( 'init', 'dw_caution_register_menu' );
endif;

if ( ! function_exists( 'dw_caution_stylesheet' ) ) :
	function dw_caution_stylesheet() {
		wp_enqueue_style( 'dw-caution-style', get_stylesheet_directory_uri() . '/style.css', array(), wp_get_theme()->version );
		/* responsive design: */
		if ( is_active_sidebar( 'left-sidebar' ) && is_active_sidebar( 'right-sidebar' ) ) :
			wp_enqueue_style( 'dw-caution-mobile', get_stylesheet_directory_uri() . '/mobile.css', array(), wp_get_theme()->version, 'all and (max-width:899px)' );
			//if there are two sidebars, use mobile stylesheet at width<900
		elseif ( is_active_sidebar( 'left-sidebar' ) || is_active_sidebar( 'right-sidebar' ) ) :
			wp_enqueue_style( 'dw-caution-mobile', get_stylesheet_directory_uri() . '/mobile.css', array(), wp_get_theme()->version, 'all and (max-width:699px)' );
			//if there is one sidebar, use mobile stylesheet at width<700
		else :
			wp_enqueue_style( 'dw-caution-mobile', get_stylesheet_directory_uri() . '/mobile.css', array(), wp_get_theme()->version );
			//if there are no sidebars, use mobile stylesheet without width condition
		endif;
	}
	add_action( 'wp_enqueue_scripts', 'dw_caution_stylesheet' );
endif;

if ( ! function_exists( 'dw_caution_sidebars' ) ) :
	// register the sidebars
	function dw_caution_sidebars() {
		register_sidebar( 
			array(
				'name' => __( 'Left Sidebar', 'dw-caution' ),
				'id'   => 'left-sidebar',
			)
		);
		register_sidebar(
			array(
				'name' => __( 'Right Sidebar', 'dw-caution' ),
				'id'   => 'right-sidebar',
			)
		);
		register_sidebar(
			array(
				'name' => __( 'Center Block', 'dw-caution' ),
				'id'   => 'center-block',
			)
		);
	}
	add_action( 'widgets_init', 'dw_caution_sidebars' );
endif;

// display information about a post under the post title
if ( ! function_exists( 'dw_caution_post_meta' ) ) :
	function dw_caution_post_meta() {
		echo '<div class="meta">';
		if ( get_post_type() === 'page' ) :
			printf(
				/* translators: %s = author */
				esc_html__( 'Posted by %s', 'dw-caution' ),
				get_the_author()
			);
		elseif ( has_category() ) :
			printf(
				/* translators: %1$s = date, %2$s = categories, %3$s = author */
				esc_html__( 'Posted on %1$s in %2$s by %3$s', 'dw-caution' ),
				get_the_date(),
				wp_kses_post( get_the_category_list( ',' ) ),
				get_the_author()
			);
		else :
			printf(
				/* translators: %1$s = date, %2$s = author */
				esc_html__( 'Posted on %1$s by %2$s', 'dw-caution' ),
				get_the_date(),
				get_the_author()
			);
		endif;
		edit_post_link( _x( 'Edit', 'verb', 'dw-caution' ), ' | ' );
		if ( get_post_type() !== 'page' && has_tag() ) :
			echo '<br>';
			the_tags();
		endif;
		echo '</div>';
	}
endif;

// change the archive title to show the search query when showing the archive title on a search result page.
if ( ! function_exists( 'dw_caution_search_title' ) ) :
	function dw_caution_search_title( $title ) {
		if ( is_search() ) {
			/* translators: %s = search query */
			$title = sprintf( __( 'Search: %s', 'dw-caution' ), get_search_query() );
		}
		return $title;
	}
	add_filter( 'get_the_archive_title', 'dw_caution_search_title' );
endif;

function dw_caution_google_fonts() {
	wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css2?family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap', array(), wp_get_theme()->version );
}
add_action( 'wp_enqueue_scripts', 'dw_caution_google_fonts' );

/**
 * Enqueue Clock script
 */
function dw_caution_clock_enqueue_scripts() {
	wp_enqueue_script( 'dw-caution-header-clock', get_template_directory_uri() . '/js/dw-caution-header-clock.js', array(), wp_get_theme()->version, true );
}
add_action( 'wp_enqueue_scripts', 'dw_caution_clock_enqueue_scripts' );

// Premium Upgrade Section
function dw_caution_procontent($wp_customize) {
	$wp_customize->add_section( 'pro_sec' , array(
		'title'          => __( 'GET PREMIUM VERSION', 'dw-caution' ),
		'description'    => '',
		'priority'       => 10,
		'capability'     => 'edit_theme_options',
	   
	) );
	
	
	
	$wp_customize->add_control( 'button_id', array(
		'type' => 'button',
		'settings' => array(),
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'BUY PREMIUM VERSION', 'dw-caution' ),
			'class' => 'button-primary',
			'onclick'=>"window.open('https://www.designwicked.com/premium-caution', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label', array(
		'type' => 'button',
		'settings' => array(),  
		'label'=> __( 'Premium Features:', 'dw-caution' ),
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( '12 More Widget Blocks', 'dw-caution' ),
			'class' => 'button-secondary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label1', array(
		'type' => 'button',
		'settings' => array(),  
		
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'Footer HTML/Text Content Area', 'dw-caution' ),
			'class' => 'button-secondary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label2', array(
		'type' => 'button',
		'settings' => array(),  
		
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'Top Header and Bottom Footer Length Widget Area', 'dw-caution' ),
			'class' => 'button-secondary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label3', array(
		'type' => 'button',
		'settings' => array(),  
		
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'bbPress Matching Forum Style', 'dw-caution' ),
			'class' => 'button-secondary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label4', array(
		'type' => 'button',
		'settings' => array(),  
		
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'And More!', 'dw-caution' ),
			'class' => 'button-secondary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	$wp_customize->add_control( 'label5', array(
		'type' => 'button',
		'settings' => array(),  
		'label'=> __( 'FOR MORE DW THEMES:', 'dw-caution' ),
		'priority' => 10,
		'section' => 'pro_sec',
		'input_attrs' => array(
			'value' => __( 'CLICK HERE!', 'dw-caution' ),
			'class' => 'button-primary',
			'onclick'=>"window.open('https://www.designwicked.com/wordpress-themes', '_blank')"
	),
	) );
	
	}
	
	add_action('customize_register', 'dw_caution_procontent');

// Header Nav
function dw_caution_hnav( $wp_customize ) {
	$wp_customize->add_section(
		'dw-caution-hnav-section',
		array(
			'title' => esc_html__( 'Header Navigation', 'dw-caution' ),
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-linkname1',
		array(
			'default'           => esc_html__( 'Link 1', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);


	$wp_customize->add_control( 
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-linkname1',
			array(
				'label'       => esc_html__( 'Link 1 Name:', 'dw-caution' ),
				'section'     => 'dw-caution-hnav-section',
				'description' => esc_html__( 'The visible name of the link on the button.', 'dw-caution' ),
				'settings'    => 'dw-caution-hnav-linkname1',
				'type'        => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-link1',
		array(
			'default'           => esc_html__( 'http://', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);


	$wp_customize->add_control( 
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-link1',
			array(
				'label'       => esc_html__( 'Link 1 Address:', 'dw-caution' ),
				'section'     => 'dw-caution-hnav-section',
				'description' => esc_html__( 'You can use /address to point to a directory, or just put a full link including http://', 'dw-caution' ),
				'settings'    => 'dw-caution-hnav-link1',
				'type'        => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-linkname2',
		array(
			'default'           => esc_html__( 'Link 2', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-linkname2',
			array(
				'label'    => esc_html__( 'Link 2 Name:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-linkname2',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-link2',
		array(
			'default'           => esc_html__( 'http://', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-link2',
			array(
				'label'    => esc_html__( 'Link 2 Address:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-link2',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-linkname3',
		array(
			'default'           => esc_html__( 'Link 3', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-linkname3',
			array(
				'label'    => esc_html__( 'Link 3 Name:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-linkname3',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-link3',
		array(
			'default'           => esc_html__( 'http://', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-link3',
			array(
				'label'    => esc_html__( 'Link 3 Address:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-link3',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-linkname4',
		array(
			'default'           => esc_html__( 'Link 4', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-linkname4',
			array(
				'label'    => esc_html__( 'Link 4 Name:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-linkname4',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-link4',
		array(
			'default'           => esc_html__( 'http://', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-link4',
			array(
				'label'    => esc_html__( 'Link 4 Address:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-link4',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-linkname5',
		array(
			'default'           => esc_html__( 'Link 5', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-linkname5',
			array(
				'label'    => esc_html__( 'Link 5 Name:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-linkname5',
				'type'     => 'text',
			)
		)
	);

	$wp_customize->add_setting(
		'dw-caution-hnav-link5',
		array(
			'default'           => esc_html__( 'http://', 'dw-caution' ),
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'dw-caution-hnav-control-link5',
			array(
				'label'    => esc_html__( 'Link 5 Address:', 'dw-caution' ),
				'section'  => 'dw-caution-hnav-section',
				'settings' => 'dw-caution-hnav-link5',
				'type'     => 'text',
			)
		)
	);
}
add_action( 'customize_register', 'dw_caution_hnav' );
