<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( ! function_exists( 'droha_setup' ) ) {
	add_action( 'after_setup_theme', 'droha_setup' );
	// Sets up theme defaults and registers support for various WordPress features.
	function droha_setup() {
		
		add_editor_style( 'style.css' );
		
	}
}

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'martanda_background_setup' );
function martanda_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => '252525',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'center',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Replace default fonts from parent theme
function martanda_get_font_face_styles() {
	return "
	@font-face{
		font-family: 'Work Sans';
		font-weight: 100;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 200;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 300;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 400;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 500;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 600;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 700;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 800;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	@font-face{
		font-family: 'Work Sans';
		font-weight: 900;
		font-style: normal;
		font-stretch: normal;
		font-display: swap;
		src: url('" . get_stylesheet_directory_uri() . "/fonts/WorkSans.woff2') format('woff2');
	}
	";
}

function martanda_font_family_css() {
	// Get our settings
	$martanda_settings = wp_parse_args(
		get_option( 'martanda_settings', array() ),
		martanda_get_defaults()
	);

	// Initiate our class
	$css = new martanda_css;
	
	$og_defaults = martanda_get_defaults( false );
	
	$bodyclass = 'body';
	if ( is_admin() ) {
		$bodyclass = '.editor-styles-wrapper';
	}
	
	$bodyfont = $martanda_settings[ 'font_body' ];
	if ( $bodyfont == 'inherit' ) { $bodyfont = 'Work Sans'; }
	
	$font_site_title = $martanda_settings[ 'font_site_title' ];
	if ( $font_site_title == 'inherit' ) { $font_site_title = 'Work Sans'; }
	$font_navigation = $martanda_settings[ 'font_navigation' ];
	if ( $font_navigation == 'inherit' ) { $font_navigation = 'Work Sans'; }
	$font_buttons = $martanda_settings[ 'font_buttons' ];
	if ( $font_buttons == 'inherit' ) { $font_buttons = 'Work Sans'; }
	$font_heading_1 = $martanda_settings[ 'font_heading_1' ];
	if ( $font_heading_1 == 'inherit' ) { $font_heading_1 = 'Work Sans'; }
	$font_heading_2 = $martanda_settings[ 'font_heading_2' ];
	if ( $font_heading_2 == 'inherit' ) { $font_heading_2 = 'Work Sans'; }
	$font_heading_3 = $martanda_settings[ 'font_heading_3' ];
	if ( $font_heading_3 == 'inherit' ) { $font_heading_3 = 'Work Sans'; }
	$font_heading_4 = $martanda_settings[ 'font_heading_4' ];
	if ( $font_heading_4 == 'inherit' ) { $font_heading_4 = 'Work Sans'; }
	$font_heading_5 = $martanda_settings[ 'font_heading_5' ];
	if ( $font_heading_5 == 'inherit' ) { $font_heading_5 = 'Work Sans'; }
	$font_heading_6 = $martanda_settings[ 'font_heading_6' ];
	if ( $font_heading_6 == 'inherit' ) { $font_heading_6 = 'Work Sans'; }
	$font_footer = $martanda_settings[ 'font_footer' ];
	if ( $font_footer == 'inherit' ) { $font_footer = 'Work Sans'; }
	$font_fixed_side = $martanda_settings[ 'font_fixed_side' ];
	if ( $font_fixed_side == 'inherit' ) { $font_fixed_side = 'Work Sans'; }
	
	$css->set_selector( $bodyclass );
	$css->add_property( '--martanda--font-body', esc_attr( $bodyfont ) );
	$css->add_property( '--martanda--font-site-title', esc_attr( $font_site_title ) );
	$css->add_property( '--martanda--font-navigation', esc_attr( $font_navigation ) );
	$css->add_property( '--martanda--font-buttons', esc_attr( $font_buttons ) );
	$css->add_property( '--martanda--font-heading-1', esc_attr( $font_heading_1 ) );
	$css->add_property( '--martanda--font-heading-2', esc_attr( $font_heading_2 ) );
	$css->add_property( '--martanda--font-heading-3', esc_attr( $font_heading_3 ) );
	$css->add_property( '--martanda--font-heading-4', esc_attr( $font_heading_4 ) );
	$css->add_property( '--martanda--font-heading-5', esc_attr( $font_heading_5 ) );
	$css->add_property( '--martanda--font-heading-6', esc_attr( $font_heading_6 ) );
	$css->add_property( '--martanda--font-footer', esc_attr( $font_footer ) );
	$css->add_property( '--martanda--font-fixed-side', esc_attr( $font_fixed_side ) );
	
	$css->set_selector( '.editor-styles-wrapper .top-bar-socials button' );
	$css->add_property( 'background-color', 'inherit' );
	
	// Allow us to hook CSS into our output
	do_action( 'martanda_font_family_css', $css );

	return apply_filters( 'martanda_font_family_css_output', $css->css_output() );
}

// Overwrite theme URL
function martanda_theme_uri_link() {
	return 'https://wpkoi.com/droha-wpkoi-wordpress-theme/';
}

// Extra cutomizer functions
if ( ! function_exists( 'droha_customize_register' ) ) {
	add_action( 'customize_register', 'droha_customize_register' );
	function droha_customize_register( $wp_customize ) {
				
		// Add Droha customizer section
		$wp_customize->add_section(
			'droha_layout_effects',
			array(
				'title' => __( 'Body border', 'droha' ),
				'priority' => 24,
			)
		);
		
		// Body border
		$wp_customize->add_setting(
			'droha_settings[body_border]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'droha_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'droha_settings[body_border]',
			array(
				'type' => 'select',
				'label' => __( 'Body border', 'droha' ),
				'choices' => array(
					'enable' => __( 'Enable', 'droha' ),
					'disable' => __( 'Disable', 'droha' )
				),
				'settings' => 'droha_settings[body_border]',
				'section' => 'droha_layout_effects',
				'priority' => 30
			)
		);
		
		// Effect colors
		$wp_customize->add_setting(
			'droha_settings[droha_color_1]', array(
				'default' => '#F5F5E5',
				'type' => 'option',
				'sanitize_callback' => 'droha_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'droha_settings[droha_color_1]',
				array(
					'label' => __( 'Border color', 'droha' ),
					'section' => 'droha_layout_effects',
					'settings' => 'droha_settings[droha_color_1]',
					'priority' => 35
				)
			)
		);
		
	}
}

//Sanitize choices.
if ( ! function_exists( 'droha_sanitize_choices' ) ) {
	function droha_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'droha_sanitize_hex_color' ) ) {
	function droha_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Droha effects css
if ( ! function_exists( 'droha_effect_css' ) ) {
	function droha_effect_css() {
		// Get Customizer settings
		$droha_settings = get_option( 'droha_settings' );
		
		$droha_color_1	 = isset( $droha_settings['droha_color_1'] ) ? $droha_settings['droha_color_1'] : '#F5F5E5';
		
		$droha_effect_css = 'body {--martanda--droha-color-1: ' . esc_attr( $droha_color_1 ) . ';}';
		
		return $droha_effect_css;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'droha_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'droha_remove_parent_dynamic_css' );
	function droha_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'martanda_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'droha_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'droha_enqueue_parent_dynamic_css', 50 );
	function droha_enqueue_parent_dynamic_css() {
		$css = martanda_get_font_face_styles() . martanda_font_family_css() . martanda_base_css() . droha_effect_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'martanda-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'droha_body_classes' ) ) {
	add_filter( 'body_class', 'droha_body_classes' );
	function droha_body_classes( $classes ) {
		// Get Customizer settings
		$droha_settings = get_option( 'droha_settings' );
		
		$body_border     = 'enable';
		
		if ( isset( $droha_settings['body_border'] ) ) {
			$body_border = $droha_settings['body_border'];
		}
		
		// Body border
		if ( $body_border != 'disable' ) {
			$classes[] = 'droha-body-border';
		}
		
		return $classes;
	}
}
