<?php 
  $driving_school_lite_archive_year  = get_the_time('Y'); 
  $driving_school_lite_archive_month = get_the_time('m'); 
  $driving_school_lite_archive_day   = get_the_time('d'); 
?> 

<?php $related_posts = driving_school_lite_related_posts_function(); ?>
<?php if ( $related_posts->have_posts() ): ?>

	<div class="related-posts clearfix py-3">
		<?php if ( get_theme_mod('driving_school_lite_related_posts_title','You May Also Like') != '' ) {?>
			<h2 class="related-posts-main-title"><?php echo esc_html( get_theme_mod('driving_school_lite_related_posts_title',__('You May Also Like','driving-school-lite')) ); ?></h2>
		<?php }?>
		<div class="row">
			<?php while ( $related_posts->have_posts() ) : $related_posts->the_post(); ?>

				<div class="col-lg-4 col-md-6">
					<article class="blog-sec p-2 mb-4">
					    <div class="mainimage">
					      <?php 
					        if(has_post_thumbnail() && get_theme_mod('driving_school_lite_show_related_posts_image',true) == true) { 
					          the_post_thumbnail(); 
					        }
					      ?>
					    </div>
					    <h3><a href="<?php echo esc_url(get_permalink() ); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3>
					    <?php if( get_theme_mod( 'driving_school_lite_related_post_date',true) != '' || get_theme_mod( 'driving_school_lite_related_post_author',true) != '' || get_theme_mod( 'driving_school_lite_related_post_comment_no',true) != '' || get_theme_mod( 'driving_school_lite_related_post_time',true) != '') { ?>
							<div class="post-info p-2 mb-2">
							<?php if( get_theme_mod( 'driving_school_lite_related_post_date',true) != '') { ?>
								<i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_related_post_date_icon',"fa fa-calendar pe-2" )); ?>"></i><a href="<?php echo esc_url( get_day_link( $driving_school_lite_archive_year, $driving_school_lite_archive_month, $driving_school_lite_archive_day)); ?>"><span class="entry-date pe-1"><?php echo esc_html( get_the_date() ); ?></span><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a>
							<?php }?>
							<?php if( get_theme_mod( 'driving_school_lite_related_post_author',true) != '') { ?>
								<i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_related_post_author_icon',"fa fa-user pe-2" )); ?>"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><span class="entry-author pe-1"> <?php the_author(); ?></span><span class="screen-reader-text"><?php the_author(); ?></span></a>
							<?php }?>
							<?php if( get_theme_mod( 'driving_school_lite_related_post_comment_no',true) != '') { ?>
								<i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_related_post_comment_icon',"fa fa-comments pe-2" )); ?>"></i><span class="entry-comments pe-1"> <?php comments_number( __('0 Comments','driving-school-lite'), __('0 Comments','driving-school-lite'), __('% Comments','driving-school-lite') ); ?></span> 
							<?php }?>
							<?php if( get_theme_mod( 'driving_school_lite_related_post_time',true) != '') { ?>
								<span class="entry-comments me-2"><i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_related_post_time_icon',"fa fa-clock pe-2" )); ?>"></i> <?php echo esc_html( get_the_time() ); ?></span>
							<?php }?>
							</div>
						<?php }?>
						<?php if(get_the_excerpt()) { ?>
					      <div class="entry-content"><p class="m-0"><?php $driving_school_lite_excerpt = get_the_excerpt(); echo esc_html( driving_school_lite_string_limit_words( $driving_school_lite_excerpt, esc_attr(get_theme_mod('driving_school_lite_related_post_excerpt_number','20')))); ?> <?php echo esc_html( get_theme_mod('driving_school_lite_related_post_excerpt_suffix','...') ); ?></p></div>
					    <?php }?>
					    <?php if ( get_theme_mod('driving_school_lite_related_button_text','Read Full') != '' ) {?>
						    <div class="blogbtn mt-3 text-end">
						        <a href="<?php the_permalink(); ?>" class="blogbutton-small" ><?php echo esc_html( get_theme_mod('driving_school_lite_related_button_text',__('Read Full', 'driving-school-lite')) ); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('driving_school_lite_related_button_text',__('Read Full', 'driving-school-lite')) ); ?></span></a>
						    </div>
					    <?php }?>
					</article>
				</div>

			<?php endwhile; ?>
		</div>

	</div><!--/.post-related-->
<?php endif; ?>

<?php wp_reset_postdata(); ?>