<?php
/**
 * The template part for displaying post
 * @package Driving School Lite
 * @subpackage driving_school_lite
 * @since 1.0
 */
?>
<?php 
  $driving_school_lite_archive_year  = get_the_time('Y'); 
  $driving_school_lite_archive_month = get_the_time('m'); 
  $driving_school_lite_archive_day   = get_the_time('d'); 
?> 
<?php 
  $driving_school_lite_grid_columns = get_theme_mod('driving_school_lite_grid_columns', '3');
  if ($driving_school_lite_grid_columns == '2') {
    $driving_school_lite_column_class = 'col-lg-6 col-md-6';
  } elseif ($driving_school_lite_grid_columns == '4') {
    $driving_school_lite_column_class = 'col-lg-3 col-md-6';
  } elseif ($driving_school_lite_grid_columns == '3') {
    $driving_school_lite_column_class = 'col-lg-4 col-md-4';
  }
?>
<div class="<?php echo esc_attr($driving_school_lite_column_class); ?>">
  <article class="grid-sec p-2 mb-4">
    <div class="mainimage">
      <?php 
        if(has_post_thumbnail() && get_theme_mod('driving_school_lite_grid_post_featured_image',true) == true) { 
          the_post_thumbnail(); 
        }
      ?>
    </div>
    <?php if( get_theme_mod( 'driving_school_lite_grid_post_date',true) != '' || get_theme_mod( 'driving_school_lite_grid_post_author',true) != '' || get_theme_mod( 'driving_school_lite_grid_post_comment',true) != '' || get_theme_mod( 'driving_school_lite_grid_post_time',true) != '') { ?>
      <div class="grid-post-info py-1 my-1">
        <?php if( get_theme_mod( 'driving_school_lite_grid_post_date',true) != '') { ?>
          <i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_grid_post_date_icon',"fa fa-calendar pe-1" )); ?>"></i><a href="<?php echo esc_url( get_day_link( $driving_school_lite_archive_year, $driving_school_lite_archive_month, $driving_school_lite_archive_day)); ?>"><span class="entry-date me-2"><?php echo esc_html( get_the_date() ); ?></span><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a>
        <?php }?>
        <?php if( get_theme_mod( 'driving_school_lite_grid_post_author',true) != '') { ?>
          <i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_grid_post_author_icon',"fa fa-user pe-1" )); ?>"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><span class="entry-author me-2"> <?php the_author(); ?></span><span class="screen-reader-text"><?php the_author(); ?></span></a>
        <?php }?>
        <?php if( get_theme_mod( 'driving_school_lite_grid_post_comment',true) != '') { ?>
          <i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_grid_post_comment_icon',"fa fa-comments pe-1" )); ?>"></i><span class="entry-comments me-2"> <?php comments_number( __('0 Comments','driving-school-lite'), __('0 Comments','driving-school-lite'), __('% Comments','driving-school-lite') ); ?></span> 
        <?php }?>
        <?php if( get_theme_mod( 'driving_school_lite_grid_post_time',true) != '') { ?>
          <span class="entry-comments me-2"><i class="<?php echo esc_attr(get_theme_mod('driving_school_lite_grid_post_time_icon',"fa fa-clock pe-1" )); ?>"></i> <?php echo esc_html( get_the_time() ); ?></span>
        <?php }?>
      </div>
    <?php }?>
    <h2><a href="<?php echo esc_url(get_permalink() ); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
    <div class="entry-content">
	        		<p>
			          <?php $driving_school_lite_theme_lay = get_theme_mod( 'driving_school_lite_grid_post_content','Excerpt Content');
				          if($driving_school_lite_theme_lay == 'Full Content'){ ?>
				            <?php the_content(); ?>
				          <?php }
				          if($driving_school_lite_theme_lay == 'Excerpt Content'){ ?>
				            <?php if(get_the_excerpt()) { ?>
				              <?php $driving_school_lite_excerpt = get_the_excerpt(); echo esc_html( driving_school_lite_string_limit_words( $driving_school_lite_excerpt, esc_attr(get_theme_mod('driving_school_lite_grid_excerpt_number','20')))); ?> <?php echo esc_html( get_theme_mod('driving_school_lite_grid_excerpt_suffix','...') ); ?>
				            <?php }?>
				        <?php }?>
			        </p>
	      </div>
    <?php if ( get_theme_mod('driving_school_lite_grid_button_text','Read Full') != '' ) {?>
      <div class="blogbtn mt-3 text-end">
        <a href="<?php the_permalink(); ?>" class="blogbutton-small" ><?php echo esc_html( get_theme_mod('driving_school_lite_grid_button_text',__('Read Full', 'driving-school-lite')) ); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('driving_school_lite_grid_button_text',__('Read Full', 'driving-school-lite')) ); ?></span></a>
      </div>
    <?php }?>
  </article>
</div>