<?php
//about theme info
add_action( 'admin_menu', 'driving_school_lite_gettingstarted' );
function driving_school_lite_gettingstarted() {    	
	add_theme_page( esc_html__('Demo Theme Content', 'driving-school-lite'), esc_html__('Demo Theme Content', 'driving-school-lite'), 'edit_theme_options', 'driving_school_lite_guide', 'driving_school_lite_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function driving_school_lite_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getting-started/getting-started.css');

   	// Admin notice code START
	wp_register_script('driving-school-lite-notice', esc_url(get_template_directory_uri()) . '/inc/getting-started/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('driving-school-lite-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'driving_school_lite_admin_theme_style');

//guidline for about theme
function driving_school_lite_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'driving-school-lite' );
?>
<div class="wrapper-info">
	<div class="intro">
		<h3><?php esc_html_e( 'Welcome to Driving School Lite WordPress Theme', 'driving-school-lite' ); ?></h3>
		<p>( Version: <?php echo esc_html($theme['Version']);?> )</p>
	</div>
	<div class="col-left">
		<div class="left-box">
			<div class="color_bg_blue color-info">

				<div class="intro-text"><img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/themesglance-logo.png" alt="" />
				</div>
				<p class="intro_version"><span class="highlight1"><?php echo esc_html__( 'Congratulations!', 'driving-school-lite' ); ?></span></p>

				<?php
					/* Demo Import */
					require get_parent_theme_file_path( '/inc/getting-started/demo-content.php' );
				?>
			</div>
			<div class="best-offers">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/best-offer.png" alt="best-offer" />
				<div class="offers">
					<p class="offer-text"><?php echo esc_html__( 'On Premium WordPress Theme', 'driving-school-lite' ); ?></p>
					<p class="coupon"><?php echo esc_html__( 'Use Coupon Code:" GET20 "', 'driving-school-lite' ); ?></p>
					<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_PRO_THEME_URL ); ?>" class="btn-pro" target="_blank" >
						<?php esc_html_e('Get Pro', 'driving-school-lite'); ?>
					</a>
				</div>
			</div>
		</div>
		<div class="started">
			<h3><?php esc_html_e( 'Lite Theme Info', 'driving-school-lite' ); ?></h3>
			<p><?php esc_html_e( 'Driving School Lite is a modern and versatile WordPress theme tailored for driving schools, instructors, car and bike training institutes, and road safety blogs. Built on the robust Bootstrap framework, it offers a sleek, responsive, and retina-ready design that ensures smooth performance across all devices. The theme includes essential sections such as gallery, testimonials, news updates, and subscription forms, making it easy to showcase courses, student feedback, and driving tips effectively. With integrated call-to-action (CTA) buttons and social media icons, Driving School Lite helps generate leads and boost online engagement. Its SEO-friendly structure, fast loading speed, and clean coding deliver a performance-driven website that ranks well on search engines. Highly customizable with flexible theme options, fonts, and layouts, it allows you to personalize your site to reflect your brand. Multilingual support and cross-browser compatibility further enhance accessibility, while its lightweight, secure build ensures a bug-free experience. Perfect for online driving courses, road safety awareness, or professional training centers, Driving School Lite combines functionality and style to help your business grow.', 'driving-school-lite')?></p>
			<hr>

			<div class="service">
				<div class="info col-lg-3 col-md-3">
					<h3><span class="dashicons dashicons-media-document"></span> <?php esc_html_e('Get Support', 'driving-school-lite'); ?></h3>
					<ol>
						<li>
						<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'driving-school-lite'); ?></a>
						</li>
					</ol>
				</div>
				<div class="info col-lg-3 col-md-3">
					<h3><span class="dashicons dashicons-welcome-widgets-menus"></span> <?php esc_html_e('Getting Started', 'driving-school-lite'); ?></h3>
					<ol>
						<li> <?php esc_html_e('Start', 'driving-school-lite'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'driving-school-lite'); ?></a> <?php esc_html_e('your website.', 'driving-school-lite'); ?></li>
					</ol>
				</div>
				<div class="info col-lg-3 col-md-3">
					<h3><span class="dashicons dashicons-star-filled"></span> <?php esc_html_e('Rate This Theme', 'driving-school-lite'); ?></h3>
					<ol>
						<li>
						<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_REVIEW ); ?>" target="_blank"><?php esc_html_e('Rate it here', 'driving-school-lite'); ?></a>
						</li>
					</ol>
				</div>
				<div class="info col-lg-3 col-md-3">
					<h3><span class="dashicons dashicons-editor-help"></span> <?php esc_html_e( 'Help Docs', 'driving-school-lite' ); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Driving School Lite Lite', 'driving-school-lite' ); ?> <a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'driving-school-lite' ); ?></a></li>
					</ol>
				</div>
			</div>
			
			<h3><?php esc_html_e( 'Get started with Driving School Lite Theme', 'driving-school-lite' ); ?></h3>
			<div class="col-left-inner"> 
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/free-screenshot.png" alt="" />
			</div>		
			<div class="col-right-inner">
				<p><?php esc_html_e( 'Go to', 'driving-school-lite' ); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizer', 'driving-school-lite' ); ?> </a> <?php esc_html_e( 'and start customizing your website', 'driving-school-lite' ); ?></p>
				<ul>
					<li><?php esc_html_e( 'Easily customizable ', 'driving-school-lite' ); ?> </li>
					<li><?php esc_html_e( 'Absolutely free', 'driving-school-lite' ); ?> </li>
				</ul>
			</div>
		</div>
	</div>
	<div class="col-right">
		<div class="centerbold">
			<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/responsive.png" alt="" />
			<hr class="firsthr">
			<div class="btn-grp">
				<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_PRO_THEME_URL ); ?>" target="_blank"><?php esc_html_e('Get Premium', 'driving-school-lite'); ?></a>
				<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'driving-school-lite'); ?></a>
				<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_THEMESGLANCE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'driving-school-lite'); ?></a>
				<a href="<?php echo esc_url( DRIVING_SCHOOL_LITE_BUNDLE_URL ); ?>" target="_blank"><?php esc_html_e('Bundle of 176+ Premium WP Themes at $79', 'driving-school-lite'); ?></a>
			</div>
			<hr class="secondhr">
		</div>
		<h3><?php esc_html_e( 'PREMIUM THEME FEATURES', 'driving-school-lite'); ?></h3>
		<ul>
		 	<li><?php esc_html_e( 'Slider with unlimited slides', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Simple Menu option', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Seperate Posttype for the Courses', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'About Section for the company description', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Custom Posttype for "testimonial" listing', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Gallery section with the plugin', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Team section with the custom posttype', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Video Promotion', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Plans listing', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Record section', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Social Icon widget', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Blog Post section on home', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Book now with contact form 7', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Frequently asked question', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Latest Blog Post Section', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Contact widget for footer', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Contact page Template', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Recent Post Widget with thumbnails', 'driving-school-lite'); ?></li>
		 	<li><?php esc_html_e( 'Blog full width, With Left and Right sidebar Template', 'driving-school-lite'); ?></li>
		</ul>
	</div>
	
</div>
<?php } ?>