<div class="theme-info">
	<?php
        // Check if the demo import has been completed
        $driving_school_lite_demo_import_completed = get_option('driving_school_lite_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($driving_school_lite_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'driving-school-lite') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="import-btn site-btn" target="_blank">' . esc_html__('VISIT SITE', 'driving-school-lite') . '</a></span>';
        echo '<span><a href="' . esc_url( admin_url('customize.php')) . '" class="import-btn site-btn" target="_blank">' . esc_html__('CUSTOMIZE', 'driving-school-lite') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

            // ------- Create Nav Menu --------
            $driving_school_lite_menuname = 'Main Menus';
            $driving_school_lite_bpmenulocation = 'primary';
            $driving_school_lite_menu_exists = wp_get_nav_menu_object($driving_school_lite_menuname);

            if (!$driving_school_lite_menu_exists) {
                $driving_school_lite_menu_id = wp_create_nav_menu($driving_school_lite_menuname);

                // Create Home Page
                $driving_school_lite_home_title = 'Home';
                $driving_school_lite_home = array(
                    'post_type' => 'page',
                    'post_title' => $driving_school_lite_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $driving_school_lite_home_id = wp_insert_post($driving_school_lite_home);
                // Assign Home Page Template
                add_post_meta($driving_school_lite_home_id, '_wp_page_template', 'page-template/custom-front-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $driving_school_lite_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($driving_school_lite_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'driving-school-lite'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $driving_school_lite_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $driving_school_lite_pages_title = 'Pages';
                $driving_school_lite_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $driving_school_lite_pages = array(
                    'post_type' => 'page',
                    'post_title' => $driving_school_lite_pages_title,
                    'post_content' => $driving_school_lite_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $driving_school_lite_pages_id = wp_insert_post($driving_school_lite_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($driving_school_lite_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'driving-school-lite'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $driving_school_lite_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $driving_school_lite_about_title = 'About Us';
                $driving_school_lite_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $driving_school_lite_about = array(
                    'post_type' => 'page',
                    'post_title' => $driving_school_lite_about_title,
                    'post_content' => $driving_school_lite_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $driving_school_lite_about_id = wp_insert_post($driving_school_lite_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($driving_school_lite_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'driving-school-lite'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $driving_school_lite_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                // Create Blog Page only if it doesn't exist already
                $driving_school_lite_existing_blog_page = get_page_by_path('blog');
                if (!$driving_school_lite_existing_blog_page) {
                    $driving_school_lite_blog_id = wp_insert_post(array(
                    'post_type'    => 'page',
                    'post_title'   => __('Blog', 'driving-school-lite'),
                    'post_content' => '',
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_name'    => 'blog'
                ));
                } else {
                    $driving_school_lite_blog_id = $driving_school_lite_existing_blog_page->ID;
                }
                // Assign as Posts Page
                update_option('page_for_posts', $driving_school_lite_blog_id);
                update_option('show_on_front', 'page');
                //Add to Menu (only if not already added)
                $driving_school_lite_menu_items = wp_get_nav_menu_items($driving_school_lite_menu_id);
                $driving_school_lite_blog_in_menu = false;
                if ($driving_school_lite_menu_items) {
                    foreach ($driving_school_lite_menu_items as $driving_school_lite_item) {
                        if ((int) $driving_school_lite_item->object_id === (int) $driving_school_lite_blog_id) {
                            $driving_school_lite_blog_in_menu = true;
                            break;
                        }
                    }
                }
                if (!$driving_school_lite_blog_in_menu) {
                wp_update_nav_menu_item($driving_school_lite_menu_id, 0, array(
                    'menu-item-title'       => __('Blog', 'driving-school-lite'),
                    'menu-item-url'         => home_url('/blog/'),
                    'menu-item-status'      => 'publish',
                    'menu-item-object-id'   => $driving_school_lite_blog_id,
                    'menu-item-object'      => 'page',
                    'menu-item-type'        => 'post_type',
                    'menu-item-classes'     => 'driving-school-lite-blog-link'
                ));
                }
                // Set the menu location if it's not already set
                if (!has_nav_menu($driving_school_lite_bpmenulocation)) {
                    $driving_school_lite_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($driving_school_lite_locations)) {
                        $driving_school_lite_locations = array();
                    }
                    $driving_school_lite_locations[$driving_school_lite_bpmenulocation] = $driving_school_lite_menu_id;
                    set_theme_mod('nav_menu_locations', $driving_school_lite_locations);
                }
                
        }    

        // Set the demo import completion flag
        update_option('driving_school_lite_demo_import_completed', true);
        // Display success message and "View Site" button
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'driving-school-lite') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="import-btn site-btn" target="_blank">' . esc_html__('VISIT SITE', 'driving-school-lite') . '</a></span>';
        echo '<span><a href="' . esc_url( admin_url('customize.php')) . '" class="import-btn site-btn" target="_blank">' . esc_html__('CUSTOMIZE', 'driving-school-lite') . '</a></span>';
        //end 

        //Topbar
        set_theme_mod( 'driving_school_lite_location', 'Lorem ipsum dolor sit amet' );
        set_theme_mod( 'driving_school_lite_facebook', '#' );
        set_theme_mod( 'driving_school_lite_twitter', '#' );
        set_theme_mod( 'driving_school_lite_youtube', '#' );
        set_theme_mod( 'driving_school_lite_linkedin', '#' );
        set_theme_mod( 'driving_school_lite_button_text', 'ENROLL NOW' );
        set_theme_mod( 'driving_school_lite_button_link', '#' );

        //Contact
        set_theme_mod( 'driving_school_lite_call_text', 'PHONES:' );
        set_theme_mod( 'driving_school_lite_call_number', '123 456 789' );
        set_theme_mod( 'driving_school_lite_email_text', 'EMAIL:' );
        set_theme_mod( 'driving_school_lite_email', 'xyz123@example.com' );
        set_theme_mod( 'driving_school_lite_timing_text', 'TIMINGS:' );
        set_theme_mod( 'driving_school_lite_timing', 'Mon - Fri 10 to 16' );

        //Slider Section
        set_theme_mod( 'driving_school_lite_slider_hide', true );
        set_theme_mod( 'driving_school_lite_slider_button_label', 'BOOK LESSON' );
        set_theme_mod( 'driving_school_lite_slider_button_link', '#' );

        
        $driving_school_lite_slider_titles = [
            'Drive Your Way to Confidence',
            'Master the Road with Expert Guidance',
            'Building Safe and Skilled Drivers',
            'Your Journey to Safe Driving Starts Here',

            ];     

        $driving_school_lite_slider_contents = [
            'Drive Your Way to Confidence, offering comprehensive training to make you a confident driver',
            'Master the Road with Expert Guidance, learning from experienced instructors focused on road safety',
            'Building Safe and Skilled Drivers, providing step-by-step lessons to ensure driving excellence',
            'Your Journey to Safe Driving Starts Here, empowering you with the skills to navigate the road responsibly',
];  

        for($driving_school_lite_i=1;$driving_school_lite_i<=4;$driving_school_lite_i++){
            $driving_school_lite_slider_title = $driving_school_lite_slider_titles[$driving_school_lite_i - 1];
            $driving_school_lite_slider_content = $driving_school_lite_slider_contents[$driving_school_lite_i - 1];
            // Create post object
            $driving_school_lite_my_post = array(
            'post_title'    => wp_strip_all_tags( $driving_school_lite_slider_title ),
            'post_content'  => $driving_school_lite_slider_content,
            'post_status'   => 'publish',
            'post_type'     => 'page',
            );

            // Insert the post into the database
            $driving_school_lite_post_id = wp_insert_post( $driving_school_lite_my_post );

            if ($driving_school_lite_post_id) {
                // Set the theme mod for the slider page
                set_theme_mod('driving_school_lite_slider_page' . $driving_school_lite_i, $driving_school_lite_post_id);

                $driving_school_lite_image_url = get_template_directory_uri().'/images/slider'.$driving_school_lite_i.'.png';

                $driving_school_lite_image_id = media_sideload_image($driving_school_lite_image_url, $driving_school_lite_post_id, null, 'id');

                    if (!is_wp_error($driving_school_lite_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($driving_school_lite_post_id, $driving_school_lite_image_id);
                    }
            }
        } 

        //Features Section
        set_theme_mod( 'driving_school_lite_page_title', 'OUR FEATURES' );

        // Set the theme mod for the default category
        set_theme_mod('driving_school_lite_category', 'postcategory3');

        // Define post category names and post titles
        $driving_school_lite_category_names = ['postcategory1', 'postcategory2', 'postcategory3'];
        $driving_school_lite_title_array = [
            ["FEATURES TITLE 1", "FEATURES TITLE 2", "FEATURES TITLE 3", "FEATURES TITLE 4"],
            ["FEATURES TITLE 1", "FEATURES TITLE 2", "FEATURES TITLE 3", "FEATURES TITLE 4"],
            ["FEATURES TITLE 1", "FEATURES TITLE 2", "FEATURES TITLE 3", "FEATURES TITLE 4"]
        ];

        $driving_school_lite_content_array = [
            [
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet",
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet"
            ],
            [
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet",
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet"
            ],
            [
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet", 
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet",
                "Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque delectus, quidem id ratione consequatur eveniet"
            ]
        ];

        foreach ($driving_school_lite_category_names as $driving_school_lite_index => $driving_school_lite_category_name) {
            // Create or retrieve the post category term ID
            $driving_school_lite_category_term = term_exists($driving_school_lite_category_name, 'category');
            if (!$driving_school_lite_category_term) {
                $driving_school_lite_category_term = wp_insert_term($driving_school_lite_category_name, 'category');
            }

            if (is_wp_error($driving_school_lite_category_term)) {
                error_log('Error creating category: ' . $driving_school_lite_category_term->get_error_message());
                continue; // Skip if category creation fails
            }

            $driving_school_lite_category_id = isset($driving_school_lite_category_term['term_id']) ? (int)$driving_school_lite_category_term['term_id'] : $driving_school_lite_category_term;

            for ($driving_school_lite_i = 0; $driving_school_lite_i < 4; $driving_school_lite_i++) {
                // Ensure the required data exists
                if (empty($driving_school_lite_title_array[$driving_school_lite_index][$driving_school_lite_i]) || 
                    empty($driving_school_lite_content_array[$driving_school_lite_index][$driving_school_lite_i])) {
                    continue; // Skip if title or content is missing
                }

                // Create the post
                $driving_school_lite_post_data = [
                    'post_title'    => wp_strip_all_tags($driving_school_lite_title_array[$driving_school_lite_index][$driving_school_lite_i]),
                    'post_content'  => $driving_school_lite_content_array[$driving_school_lite_index][$driving_school_lite_i],
                    'post_status'   => 'publish',
                    'post_type'     => 'post', // Default WordPress post type
                ];
                $driving_school_lite_post_id = wp_insert_post($driving_school_lite_post_data);

                if (is_wp_error($driving_school_lite_post_id)) {
                    error_log('Error creating post: ' . $driving_school_lite_post_id->get_error_message());
                    continue; // Skip if post creation fails
                }

                // Assign category to the post
                wp_set_post_categories($driving_school_lite_post_id, [$driving_school_lite_category_id]);

                // Handle the featured image
                $driving_school_lite_image_url = get_template_directory_uri() . '/images/feature' . ($driving_school_lite_i + 1) . '.png';
                $driving_school_lite_image_id = media_sideload_image($driving_school_lite_image_url, $driving_school_lite_post_id, null, 'id');

                if (is_wp_error($driving_school_lite_image_id)) {
                    error_log('Error downloading image: ' . $driving_school_lite_image_id->get_error_message());
                    continue; // Skip if image download fails
                }

                // Set the featured image
                set_post_thumbnail($driving_school_lite_post_id, $driving_school_lite_image_id);
            }
        }

        //Copyright Text
        set_theme_mod( 'driving_school_lite_footer_text', 'By Themesglance' );

        }
    ?>

    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=driving_school_lite_guide" method="POST" onsubmit="return validate(this);">
    <?php if (!get_option('driving_school_lite_demo_import_completed')) : ?>
        <div class="demo-btn">
            <p><?php echo  esc_html_e( 'You are about to use the most easy to use and flexible WordPress theme.', 'driving-school-lite' ); ?></p>
            <button id="import-button" type="submit" name="submit" class="import-btn run-import button-large">
                <?php esc_html_e('Run Importer', 'driving-school-lite'); ?>
                    <span id="spinner" style="display: none;">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/spinner.gif" alt="Loading..." style="width:34px; height:34px; margin-left:10px;vertical-align: middle;" />
                    </span>
            </button>
        </div>
    <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
			 if(confirm("Do you really want to import the Demo Theme Content?")){
			    document.getElementById('spinner').style.display = 'inline-block';
			}
		    else {
			    return false;
		    }
		}
	</script>
</div>
