<?php
	
	$driving_school_lite_first_theme_color = get_theme_mod('driving_school_lite_first_theme_color');

	$driving_school_lite_custom_css = '';

	/*------------------ Theme Color Option -----------*/
	if ($driving_school_lite_first_theme_color) {
		$driving_school_lite_custom_css .= ':root {';
		$driving_school_lite_custom_css .= '--primary-color: ' . esc_attr($driving_school_lite_first_theme_color) . ' !important;';
		$driving_school_lite_custom_css .= '} ';
	} 
	// Layout Options
	$driving_school_lite_theme_layout = get_theme_mod( 'driving_school_lite_theme_layout_options','Default Theme');
    if($driving_school_lite_theme_layout == 'Default Theme'){
		$driving_school_lite_custom_css .='body{';
			$driving_school_lite_custom_css .='max-width: 100%;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_theme_layout == 'Container Theme'){
		$driving_school_lite_custom_css .='body{';
			$driving_school_lite_custom_css .='width: 100%;padding-right: 15px;padding-left: 15px;margin-right: auto;margin-left: auto;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_theme_layout == 'Box Container Theme'){
		$driving_school_lite_custom_css .='body{';
			$driving_school_lite_custom_css .='max-width: 1140px; width: 100%; padding-right: 15px; padding-left: 15px; margin-right: auto; margin-left: auto;';
		$driving_school_lite_custom_css .='}';
	}

	/*----------------Slider Content Layout --------------*/

	$driving_school_lite_slider_layout = get_theme_mod( 'driving_school_lite_slider_alignment_option','Left Align');
    if($driving_school_lite_slider_layout == 'Left Align'){
    	$driving_school_lite_custom_css .='@media screen and (min-width:720px) {';
		$driving_school_lite_custom_css .='#slider .carousel-caption{';
			$driving_school_lite_custom_css .='text-align:left; left:0;
						   -webkit-clip-path: polygon(0 0, 100% 0, 75% 100%, 100% 100%, 0 100%); 
						   clip-path: polygon(0 0, 100% 0, 75% 100%, 100% 100%, 0% 100%);';
		$driving_school_lite_custom_css .='}}';
		$driving_school_lite_custom_css .='#slider .inner_carousel p, #slider .inner_carousel h1, .more-btn{';
			$driving_school_lite_custom_css .='text-align:left;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_slider_layout == 'Center Align'){
		$driving_school_lite_custom_css .='#slider .carousel-caption{';
			$driving_school_lite_custom_css .='text-align:center; left:20%; right:20%; clip-path:none; top:15%; bottom:30%;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#slider .carousel-caption.d-none.d-md-block{';
			$driving_school_lite_custom_css .=' width:auto; height:auto; padding:0';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#slider .inner_carousel p, #slider .inner_carousel h1, .more-btn{';
			$driving_school_lite_custom_css .='text-align:center;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='@media screen and (max-width: 720px) and (min-width: 320px){
			#slider .more-btn{';
			$driving_school_lite_custom_css .='padding:20px 0;';
		$driving_school_lite_custom_css .='} }';
		$driving_school_lite_custom_css .='#slider .inner_carousel{';
			$driving_school_lite_custom_css .='padding:4%;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_slider_layout == 'Right Align'){
		$driving_school_lite_custom_css .='@media screen and (min-width:720px) {';
		$driving_school_lite_custom_css .='#slider .carousel-caption{';
			$driving_school_lite_custom_css .='text-align:right;
						   right:0; left:auto;
						   -webkit-clip-path: polygon(0 0, 100% 0, 100% 100%, 100% 100%, 25% 100%); 
						   clip-path: polygon(0 0, 100% 0, 100% 100%, 100% 100%, 25% 100%);';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#slider .inner_carousel p, #slider .inner_carousel h1, .more-btn{';
			$driving_school_lite_custom_css .='text-align:right;';
		$driving_school_lite_custom_css .='}}';
	}

	// Slider Arrows hover color
	$driving_school_lite_slider_arrows_hover_color = get_theme_mod('driving_school_lite_slider_arrows_hover_color','#000');
	$driving_school_lite_custom_css .='#slider .carousel-control-prev-icon i:hover,#slider .carousel-control-next-icon i:hover{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_slider_arrows_hover_color).' !important;';
	$driving_school_lite_custom_css .='}';

	/*--------- Preloader Color Option -------*/
	$driving_school_lite_preloader_color = get_theme_mod('driving_school_lite_preloader_color');

	if($driving_school_lite_preloader_color != false){
		$driving_school_lite_custom_css .=' .tg-loader{';
			$driving_school_lite_custom_css .='border-color: '.esc_attr($driving_school_lite_preloader_color).';';
		$driving_school_lite_custom_css .='} ';
		$driving_school_lite_custom_css .=' .tg-loader-inner, .preloader .preloader-container .animated-preloader, .preloader .preloader-container .animated-preloader:before{';
			$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_preloader_color).';';
		$driving_school_lite_custom_css .='} ';
	}

	$driving_school_lite_preloader_bg_color = get_theme_mod('driving_school_lite_preloader_bg_color');

	if($driving_school_lite_preloader_bg_color != false){
		$driving_school_lite_custom_css .=' #overlayer, .preloader{';
			$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_preloader_bg_color).';';
		$driving_school_lite_custom_css .='} ';
	}

	$driving_school_lite_preloader_bg_img = get_theme_mod('driving_school_lite_preloader_bg_img');
	if($driving_school_lite_preloader_bg_img != false){
		$driving_school_lite_custom_css .=' #overlayer, .preloader{';
			$driving_school_lite_custom_css .='background: url('.esc_attr($driving_school_lite_preloader_bg_img).');-webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover;';
		$driving_school_lite_custom_css .='}';
	}

	/*------------ Button Settings option-----------------*/
	$driving_school_lite_top_button_padding = get_theme_mod('driving_school_lite_top_button_padding');
	$driving_school_lite_bottom_button_padding = get_theme_mod('driving_school_lite_bottom_button_padding');
	$driving_school_lite_left_button_padding = get_theme_mod('driving_school_lite_left_button_padding');
	$driving_school_lite_right_button_padding = get_theme_mod('driving_school_lite_right_button_padding');
	if($driving_school_lite_top_button_padding != false || $driving_school_lite_bottom_button_padding != false || $driving_school_lite_left_button_padding != false || $driving_school_lite_right_button_padding != false){
		$driving_school_lite_custom_css .='.blogbtn a, .more-btn a, #comments input[type="submit"].submit{';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_top_button_padding).'px; padding-bottom: '.esc_attr($driving_school_lite_bottom_button_padding).'px; padding-left: '.esc_attr($driving_school_lite_left_button_padding).'px; padding-right: '.esc_attr($driving_school_lite_right_button_padding).'px; display:inline-block;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_button_border_radius = get_theme_mod('driving_school_lite_button_border_radius');
	$driving_school_lite_custom_css .='.more-btn span, .more-btn a, .blogbtn a, #comments input[type="submit"].submit{';
		$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_button_border_radius).'px;';
	$driving_school_lite_custom_css .='}';

	// button font weight
	$driving_school_lite_button_font_weight = get_theme_mod('driving_school_lite_button_font_weight');
  	$driving_school_lite_custom_css .='.blogbtn a{';
    $driving_school_lite_custom_css .='font-weight: '.esc_attr($driving_school_lite_button_font_weight).';';
  	$driving_school_lite_custom_css .='}';


  	// button text transform
  	$driving_school_lite_button_text_transform = get_theme_mod('driving_school_lite_button_text_transform');
  	if($driving_school_lite_button_text_transform == 'uppercase' ){
    	$driving_school_lite_custom_css .='.blogbtn a{';
      	$driving_school_lite_custom_css .=' text-transform: uppercase;';
    	$driving_school_lite_custom_css .='}';
  	}elseif($driving_school_lite_button_text_transform == 'Capitalize' ){
    	$driving_school_lite_custom_css .='.blogbtn a{';
      	$driving_school_lite_custom_css .=' text-transform: Capitalize;';
    	$driving_school_lite_custom_css .='}';
  	}elseif($driving_school_lite_button_text_transform == 'lowercase' ){
    	$driving_school_lite_custom_css .='.blogbtn a{';
      	$driving_school_lite_custom_css .=' text-transform: lowercase;';
    	$driving_school_lite_custom_css .='}';
  	}

	//Button hover effect
	$driving_school_lite_button_hover_effect = get_theme_mod('driving_school_lite_button_hover_effect', 'disable');
	if ($driving_school_lite_button_hover_effect !== 'disable') {
		$driving_school_lite_custom_css .= '.blogbtn a:hover {';
		switch ($driving_school_lite_button_hover_effect) {
			case 'pulse':
				$driving_school_lite_custom_css .= 'animation: pulse 0.5s ease-in-out;';
				break;
			case 'rubberBand':
				$driving_school_lite_custom_css .= 'animation: rubberBand 0.5s ease-in-out;';
				break;
			case 'swing':
				$driving_school_lite_custom_css .= 'animation: swing 0.5s ease-in-out;';
				break;
			case 'tada':
				$driving_school_lite_custom_css .= 'animation: tada 0.5s ease-in-out;';
				break;
			case 'jello':
				$driving_school_lite_custom_css .= 'animation: jello 0.5s ease-in-out;';
				break;
		}
		$driving_school_lite_custom_css .= '}';
	}

	//keyframes for all animations
	$driving_school_lite_custom_css .= '
	@keyframes pulse {
		0% { transform: scale(1); }
		50% { transform: scale(1.1); }
		100% { transform: scale(1); }
	}

	@keyframes rubberBand {
		0% { transform: scale(1); }
		30% { transform: scaleX(1.25) scaleY(0.75); }
		40% { transform: scaleX(0.75) scaleY(1.25); }
		50% { transform: scale(1); }
	}

	@keyframes swing {
		20% { transform: rotate(15deg); }
		40% { transform: rotate(-10deg); }
		60% { transform: rotate(5deg); }
		80% { transform: rotate(-5deg); }
		100% { transform: rotate(0deg); }
	}

	@keyframes tada {
		0% { transform: scale(1); }
		10%, 20% { transform: scale(0.9) rotate(-3deg); }
		30%, 50%, 70%, 90% { transform: scale(1.1) rotate(3deg); }
		40%, 60%, 80% { transform: scale(1.1) rotate(-3deg); }
		100% { transform: scale(1) rotate(0); }
	}

	@keyframes jello {
		0%, 11.1%, 100% { transform: none; }
		22.2% { transform: skewX(-12.5deg) skewY(-12.5deg); }
		33.3% { transform: skewX(6.25deg) skewY(6.25deg); }
		44.4% { transform: skewX(-3.125deg) skewY(-3.125deg); }
		55.5% { transform: skewX(1.5625deg) skewY(1.5625deg); }
		66.6% { transform: skewX(-0.78125deg) skewY(-0.78125deg); }
		77.7% { transform: skewX(0.390625deg) skewY(0.390625deg); }
		88.8% { transform: skewX(-0.1953125deg) skewY(-0.1953125deg); }
	}';

	// Button letter spacing
	$driving_school_lite_button_letter_spacing = get_theme_mod('driving_school_lite_button_letter_spacing', '0');
	$driving_school_lite_custom_css .='.blogbtn a{';
		$driving_school_lite_custom_css .='letter-spacing: '.esc_attr($driving_school_lite_button_letter_spacing).'px;';
	$driving_school_lite_custom_css .='}';	

  	// widgets heading font size
	$driving_school_lite_widgets_heading_fontsize = get_theme_mod('driving_school_lite_widgets_heading_fontsize',26);
	if($driving_school_lite_widgets_heading_fontsize != false){
		$driving_school_lite_custom_css .='#footer h3, #footer h2, #footer .wp-block-search__label{';
			$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_widgets_heading_fontsize).'px; ';
		$driving_school_lite_custom_css .='}';
	}

	// widgets heading font weight
	$driving_school_lite_widgets_heading_font_weight = get_theme_mod('driving_school_lite_widgets_heading_font_weight', '600');
  	$driving_school_lite_custom_css .='#footer h3, #footer h2, #footer .wp-block-search__label{';
    $driving_school_lite_custom_css .='font-weight: '.esc_attr($driving_school_lite_widgets_heading_font_weight).';';
  	$driving_school_lite_custom_css .='}';

	/*----------- Footer widgets heading alignment -----*/
	$driving_school_lite_footer_widgets_heading = get_theme_mod( 'driving_school_lite_footer_widgets_heading','Left');
    if($driving_school_lite_footer_widgets_heading == 'Left'){
		$driving_school_lite_custom_css .='#footer h3{';
		$driving_school_lite_custom_css .='text-align: left;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_footer_widgets_heading == 'Center'){
		$driving_school_lite_custom_css .='#footer h3{';
			$driving_school_lite_custom_css .='text-align: center;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_footer_widgets_heading == 'Right'){
		$driving_school_lite_custom_css .='#footer h3{';
			$driving_school_lite_custom_css .='text-align: right;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_footer_widgets_content = get_theme_mod( 'driving_school_lite_footer_widgets_content','Left');
    if($driving_school_lite_footer_widgets_content == 'Left'){
		$driving_school_lite_custom_css .='#footer .widget ul{';
		$driving_school_lite_custom_css .='text-align: left;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_footer_widgets_content == 'Center'){
		$driving_school_lite_custom_css .='#footer .widget ul{';
			$driving_school_lite_custom_css .='text-align: center;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_footer_widgets_content == 'Right'){
		$driving_school_lite_custom_css .='#footer .widget ul{';
			$driving_school_lite_custom_css .='text-align: right;';
		$driving_school_lite_custom_css .='}';
	}

	// Footer Heading Text Transform

	$driving_school_lite_theme_lay = get_theme_mod( 'driving_school_lite_footer_text_tranform','Capitalize');
    if($driving_school_lite_theme_lay == 'Uppercase'){
		$driving_school_lite_custom_css .='#footer h3{';
			$driving_school_lite_custom_css .='text-transform: Uppercase;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_theme_lay == 'Lowercase'){
		$driving_school_lite_custom_css .='#footer h3{';
			$driving_school_lite_custom_css .='text-transform: Lowercase;';
		$driving_school_lite_custom_css .='}';
	}
	else if($driving_school_lite_theme_lay == 'Capitalize'){
		$driving_school_lite_custom_css .='#footer h3{';
			$driving_school_lite_custom_css .='text-transform: Capitalize;';
		$driving_school_lite_custom_css .='}';
	}
	
	// Footer Heading  letter spacing
	$driving_school_lite_widgets_heading_letter_spacing = get_theme_mod('driving_school_lite_widgets_heading_letter_spacing','');
	$driving_school_lite_custom_css .='#footer h3{';
	$driving_school_lite_custom_css .='letter-spacing: '.esc_attr($driving_school_lite_widgets_heading_letter_spacing).'px;';
	$driving_school_lite_custom_css .='}';	

	/*----------- Copyright css -----*/
	$driving_school_lite_copyright_top_padding = get_theme_mod('driving_school_lite_top_copyright_padding');
	$driving_school_lite_copyright_bottom_padding = get_theme_mod('driving_school_lite_top_copyright_padding');
	if($driving_school_lite_copyright_top_padding != false || $driving_school_lite_copyright_bottom_padding != false){
		$driving_school_lite_custom_css .='.copyright{';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_copyright_top_padding).'px; padding-bottom: '.esc_attr($driving_school_lite_copyright_bottom_padding).'px; ';
		$driving_school_lite_custom_css .='}';
	} 

	$driving_school_lite_copyright_alignment = get_theme_mod('driving_school_lite_copyright_alignment', 'center');
	if($driving_school_lite_copyright_alignment == 'center' ){
		$driving_school_lite_custom_css .='#footer .copyright p{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_copyright_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_copyright_alignment == 'left' ){
		$driving_school_lite_custom_css .='#footer .copyright p{';
			$driving_school_lite_custom_css .=' text-align: '. $driving_school_lite_copyright_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_copyright_alignment == 'right' ){
		$driving_school_lite_custom_css .='#footer .copyright p{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_copyright_alignment .';';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_copyright_font_size = get_theme_mod('driving_school_lite_copyright_font_size');
	$driving_school_lite_custom_css .='#footer .copyright p{';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_copyright_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_copyright_color = get_theme_mod('driving_school_lite_copyright_color');
	$driving_school_lite_custom_css .='#footer .copyright p,#footer .copyright a{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_copyright_color).'!important;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_back_to_top_color = get_theme_mod('driving_school_lite_back_to_top_color');
	$driving_school_lite_custom_css .='.back-to-top{';
		$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_back_to_top_color).'!important;';
	$driving_school_lite_custom_css .='}';
		$driving_school_lite_back_to_top_color = get_theme_mod('driving_school_lite_back_to_top_color');
	$driving_school_lite_custom_css .='.back-to-top::before{';
		$driving_school_lite_custom_css .='border-bottom-color: '.esc_attr($driving_school_lite_back_to_top_color).'!important;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_back_to_top_text_color = get_theme_mod('driving_school_lite_back_to_top_text_color');
	$driving_school_lite_custom_css .='.back-to-top{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_back_to_top_text_color).'!important;';
	$driving_school_lite_custom_css .='}';	

	// back to top icon hover color
	$driving_school_lite_back_to_top_hover_color = get_theme_mod('driving_school_lite_back_to_top_hover_color');
	$driving_school_lite_custom_css .='.back-to-top:hover{';
		$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_back_to_top_hover_color). ' !important;';
	$driving_school_lite_custom_css .='}';
		$driving_school_lite_back_to_top_hover_color = get_theme_mod('driving_school_lite_back_to_top_hover_color');
	$driving_school_lite_custom_css .='.back-to-top:hover::before{';
		$driving_school_lite_custom_css .='border-bottom-color: '.esc_attr($driving_school_lite_back_to_top_hover_color).'!important;';
	$driving_school_lite_custom_css .='}';

/*---------------------------Footer Style -------------------*/

	$driving_school_lite_theme_lay = get_theme_mod( 'driving_school_lite_footer_template','driving_school_lite-footer-one');
    if($driving_school_lite_theme_lay == 'driving_school_lite-footer-one'){
		$driving_school_lite_custom_css .='#footer  {';
			$driving_school_lite_custom_css .='';
		$driving_school_lite_custom_css .='}';

	}else if($driving_school_lite_theme_lay == 'driving_school_lite-footer-two'){
		$driving_school_lite_custom_css .='#footer  {';
			$driving_school_lite_custom_css .='background: #E3F2FD !important;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner p,.footerinner span,.footerinner li a,.footerinner #wp-calendar caption,.footerinner #wp-calendar td,.footerinner #wp-calendar th, .footerinner, .footerinner h3, .footerinner a.rsswidget, .footerinner #wp-calendar a, .copyright a, .footerinner .custom_details, .footerinner ins span, .footerinner .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, #footer ul li a, .footerinner table, .footerinner th, .footerinner td, .footerinner caption, #sidebar caption,.footerinner nav.wp-calendar-nav a,.footerinner .search-form .search-field{';
			$driving_school_lite_custom_css .='color:#000 !important;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#footer p{';
			$driving_school_lite_custom_css .='color:#000 !important;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner ul li::before{';
			$driving_school_lite_custom_css .='background:#000;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner table, .footerinner th, .footerinner td,.footerinner.search-form .search-field,.footerinner .tagcloud a{';
			$driving_school_lite_custom_css .='border: 1px solid #000;';
		$driving_school_lite_custom_css .='}';

	}else if($driving_school_lite_theme_lay == 'driving_school_lite-footer-three'){
		$driving_school_lite_custom_css .='#footer  {';
			$driving_school_lite_custom_css .='background: #0A0A1F !important;;';
		$driving_school_lite_custom_css .='}';
	}
	else if($driving_school_lite_theme_lay == 'driving_school_lite-footer-four'){
		$driving_school_lite_custom_css .='#footer  {';
			$driving_school_lite_custom_css .='background: #F5F5DC !important;;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner p,.footerinner span,.footerinner li a,.footerinner #wp-calendar caption,.footerinner #wp-calendar td,.footerinner #wp-calendar th, .footerinner, .footerinner h3, .footerinner a.rsswidget, .footerinner #wp-calendar a, .copyright a, .footerinner .custom_details, .footerinner ins span, .footerinner .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, #footer ul li a, .footerinner table, .footerinner th, .footerinner td, .footerinner caption, #sidebar caption,.footerinner nav.wp-calendar-nav a,.footerinner .search-form .search-field{';
			$driving_school_lite_custom_css .='color:#000 !important;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#footer p{';
			$driving_school_lite_custom_css .='color:#000 !important;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner ul li::before{';
			$driving_school_lite_custom_css .='background:#000;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.footerinner table, .footerinner th, .footerinner td,.footerinner.search-form .search-field,.footerinner .tagcloud a{';
			$driving_school_lite_custom_css .='border: 1px solid #000;';
		$driving_school_lite_custom_css .='}';
	}
    else if($driving_school_lite_theme_lay == 'driving_school_lite-footer-five'){
	$driving_school_lite_custom_css .='#footer {';
		$driving_school_lite_custom_css .='background: #333333 !important;;';
	$driving_school_lite_custom_css .='}';
   }	

	/*------ Topbar padding ------*/
	$driving_school_lite_top_topbar_padding = get_theme_mod('driving_school_lite_top_topbar_padding');
	$driving_school_lite_bottom_topbar_padding = get_theme_mod('driving_school_lite_bottom_topbar_padding');
	if($driving_school_lite_top_topbar_padding != false || $driving_school_lite_bottom_topbar_padding != false){
		$driving_school_lite_custom_css .='.topbar{';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_top_topbar_padding).'px; padding-bottom: '.esc_attr($driving_school_lite_bottom_topbar_padding).'px; ';
		$driving_school_lite_custom_css .='}';
	}

	/*------ Woocommerce ----*/
	$driving_school_lite_product_border = get_theme_mod('driving_school_lite_product_border',false);

	if($driving_school_lite_product_border == true){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
			$driving_school_lite_custom_css .='border: 1px solid '.esc_attr($driving_school_lite_first_theme_color).';';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_top = get_theme_mod('driving_school_lite_product_top_padding');
	$driving_school_lite_product_bottom = get_theme_mod('driving_school_lite_product_bottom_padding');
	$driving_school_lite_product_left = get_theme_mod('driving_school_lite_product_left_padding');
	$driving_school_lite_product_right = get_theme_mod('driving_school_lite_product_right_padding');
	if($driving_school_lite_product_top != false || $driving_school_lite_product_bottom != false || $driving_school_lite_product_left != false || $driving_school_lite_product_right != false){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_product_top).'px; padding-bottom: '.esc_attr($driving_school_lite_product_bottom).'px; padding-left: '.esc_attr($driving_school_lite_product_left).'px; padding-right: '.esc_attr($driving_school_lite_product_right).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_border_radius = get_theme_mod('driving_school_lite_product_border_radius');
	if($driving_school_lite_product_border_radius != false){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
			$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_product_border_radius).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_box_shadow = get_theme_mod('driving_school_lite_product_box_shadow','0');
	$driving_school_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$driving_school_lite_custom_css .='box-shadow: '.esc_attr($driving_school_lite_product_box_shadow).'px '.esc_attr($driving_school_lite_product_box_shadow).'px '.esc_attr($driving_school_lite_product_box_shadow).'px #eee;';
	$driving_school_lite_custom_css .='}';	

	/*----- WooCommerce button css --------*/
	$driving_school_lite_product_button_top = get_theme_mod('driving_school_lite_product_button_top_padding',10);
	$driving_school_lite_product_button_bottom = get_theme_mod('driving_school_lite_product_button_bottom_padding',10);
	$driving_school_lite_product_button_left = get_theme_mod('driving_school_lite_product_button_left_padding',15);
	$driving_school_lite_product_button_right = get_theme_mod('driving_school_lite_product_button_right_padding',15);
	if($driving_school_lite_product_button_top != false || $driving_school_lite_product_button_bottom != false || $driving_school_lite_product_button_left != false || $driving_school_lite_product_button_right != false){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product .button, .woocommerce div.product form.cart .button, a.button.wc-forward, .woocommerce .cart .button, .woocommerce .cart input.button, .woocommerce #payment #place_order, .woocommerce-page #payment #place_order, button.woocommerce-button.button.woocommerce-form-login__submit, .woocommerce button.button:disabled, .woocommerce button.button:disabled[disabled]{';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_product_button_top).'px; padding-bottom: '.esc_attr($driving_school_lite_product_button_bottom).'px; padding-left: '.esc_attr($driving_school_lite_product_button_left).'px; padding-right: '.esc_attr($driving_school_lite_product_button_right).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_button_border_radius = get_theme_mod('driving_school_lite_product_button_border_radius');
	if($driving_school_lite_product_button_border_radius != false){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product .button, .woocommerce div.product form.cart .button, a.button.wc-forward, .woocommerce .cart .button, .woocommerce .cart input.button, a.checkout-button.button.alt.wc-forward, .woocommerce #payment #place_order, .woocommerce-page #payment #place_order, button.woocommerce-button.button.woocommerce-form-login__submit{';
			$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_product_button_border_radius).'px;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- WooCommerce product sale css --------*/
	$driving_school_lite_product_sale_top = get_theme_mod('driving_school_lite_product_sale_top_padding');
	$driving_school_lite_product_sale_bottom = get_theme_mod('driving_school_lite_product_sale_bottom_padding');
	$driving_school_lite_product_sale_left = get_theme_mod('driving_school_lite_product_sale_left_padding');
	$driving_school_lite_product_sale_right = get_theme_mod('driving_school_lite_product_sale_right_padding');
	if($driving_school_lite_product_sale_top != false || $driving_school_lite_product_sale_bottom != false || $driving_school_lite_product_sale_left != false || $driving_school_lite_product_sale_right != false){
		$driving_school_lite_custom_css .='.woocommerce span.onsale {';
			$driving_school_lite_custom_css .='padding-top: '.esc_attr($driving_school_lite_product_sale_top).'px; padding-bottom: '.esc_attr($driving_school_lite_product_sale_bottom).'px; padding-left: '.esc_attr($driving_school_lite_product_sale_left).'px; padding-right: '.esc_attr($driving_school_lite_product_sale_right).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_sale_border_radius = get_theme_mod('driving_school_lite_product_sale_border_radius',50);
	if($driving_school_lite_product_sale_border_radius != false){
		$driving_school_lite_custom_css .='.woocommerce span.onsale {';
			$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_product_sale_border_radius).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_menu_case = get_theme_mod('driving_school_lite_product_sale_position', 'Right');
	if($driving_school_lite_menu_case == 'Right' ){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product .onsale{';
			$driving_school_lite_custom_css .=' left:auto; right:0;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_menu_case == 'Left' ){
		$driving_school_lite_custom_css .='.woocommerce ul.products li.product .onsale{';
			$driving_school_lite_custom_css .=' left:-10px; right:auto;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_product_sale_font_size = get_theme_mod('driving_school_lite_product_sale_font_size',13);
	$driving_school_lite_custom_css .='.woocommerce span.onsale {';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_product_sale_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	/*---- Comment form ----*/
	$driving_school_lite_comment_width = get_theme_mod('driving_school_lite_comment_width', '100');
	$driving_school_lite_custom_css .='#comments textarea{';
		$driving_school_lite_custom_css .=' width:'.esc_attr($driving_school_lite_comment_width).'%;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_comment_submit_text = get_theme_mod('driving_school_lite_comment_submit_text', 'Post Comment');
	if($driving_school_lite_comment_submit_text == ''){
		$driving_school_lite_custom_css .='#comments p.form-submit {';
			$driving_school_lite_custom_css .='display: none;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_comment_title = get_theme_mod('driving_school_lite_comment_title', 'Leave a Reply');
	if($driving_school_lite_comment_title == ''){
		$driving_school_lite_custom_css .='#comments h2#reply-title {';
			$driving_school_lite_custom_css .='display: none;';
		$driving_school_lite_custom_css .='}';
	}

	/*------ Footer background css -------*/
	$driving_school_lite_footer_bg_color = get_theme_mod('driving_school_lite_footer_bg_color');
	if($driving_school_lite_footer_bg_color != false){
		$driving_school_lite_custom_css .='#footer{';
			$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_footer_bg_color).';';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_footer_bg_image = get_theme_mod('driving_school_lite_footer_bg_image');
	if($driving_school_lite_footer_bg_image != false){
		$driving_school_lite_custom_css .='#footer{';
			$driving_school_lite_custom_css .='background: url('.esc_attr($driving_school_lite_footer_bg_image).'); background-size: cover;';
		$driving_school_lite_custom_css .='}';
	}

	//footer icon color
	$driving_school_lite_footer_icon_color = get_theme_mod('driving_school_lite_footer_icon_color', '#fff');
	$driving_school_lite_custom_css .='#footer .copyright a i{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_footer_icon_color).'!important;';
	$driving_school_lite_custom_css .='}';	

	/*-------- Footer Icon Alignment ------*/
	$driving_school_lite_footer_icon_alignment = get_theme_mod('driving_school_lite_footer_icon_alignment', 'Center');
	if($driving_school_lite_footer_icon_alignment == 'Center' ){
		$driving_school_lite_custom_css .='#footer .copyright{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_footer_icon_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_footer_icon_alignment == 'Left' ){
		$driving_school_lite_custom_css .='#footer .copyright{';
			$driving_school_lite_custom_css .=' text-align: '. $driving_school_lite_footer_icon_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_footer_icon_alignment == 'Right' ){
		$driving_school_lite_custom_css .='#footer .copyright{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_footer_icon_alignment .';';
		$driving_school_lite_custom_css .='}';
	}

	//Footer Social Icon Font size
	$driving_school_lite_footer_icon_font_size = get_theme_mod('driving_school_lite_footer_icon_font_size');
	$driving_school_lite_custom_css .='#footer .copyright a i{';
	$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_footer_icon_font_size).'px;';
	$driving_school_lite_custom_css .='}';

    // footer image position
	$driving_school_lite_footer_img_position = get_theme_mod('driving_school_lite_footer_img_position','center center');
	if($driving_school_lite_footer_img_position != false){
		$driving_school_lite_custom_css .='#footer{';
			$driving_school_lite_custom_css .='background-position: '.esc_attr($driving_school_lite_footer_img_position).'!important;';
		$driving_school_lite_custom_css .='}';
	}	

	// Footer Attatchment
	$driving_school_lite_theme_lay = get_theme_mod( 'driving_school_lite_footer_attatchment','scroll');
	if($driving_school_lite_theme_lay == 'fixed'){
		$driving_school_lite_custom_css .='#footer{';
			$driving_school_lite_custom_css .='background-attachment: fixed;';
		$driving_school_lite_custom_css .='}';
	}elseif ($driving_school_lite_theme_lay == 'scroll'){
		$driving_school_lite_custom_css .='#footer{';
			$driving_school_lite_custom_css .='background-attachment: scroll;';
		$driving_school_lite_custom_css .='}';
	}	

	/*---------------------------Footer top bottom padding -------------------*/

	$driving_school_lite_footer_padding = get_theme_mod('driving_school_lite_footer_padding');
	if($driving_school_lite_footer_padding != false){
		$driving_school_lite_custom_css .='#footer .footerinner{';
			$driving_school_lite_custom_css .='padding: '.esc_attr($driving_school_lite_footer_padding).' 0 !important;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- Featured image css -----*/
	$driving_school_lite_feature_image_border_radius = get_theme_mod('driving_school_lite_feature_image_border_radius');
	if($driving_school_lite_feature_image_border_radius != false){
		$driving_school_lite_custom_css .='#blog_post .blog-sec img{';
			$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_feature_image_border_radius).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_feature_image_shadow = get_theme_mod('driving_school_lite_feature_image_shadow');
	if($driving_school_lite_feature_image_shadow != false){
		$driving_school_lite_custom_css .='#blog_post .blog-sec img{';
			$driving_school_lite_custom_css .='box-shadow: '.esc_attr($driving_school_lite_feature_image_shadow).'px '.esc_attr($driving_school_lite_feature_image_shadow).'px '.esc_attr($driving_school_lite_feature_image_shadow).'px #aaa;';
		$driving_school_lite_custom_css .='}';
	}

	// blog post Pagination Alignment
	$driving_school_lite_post_pagination_alignment = get_theme_mod( 'driving_school_lite_post_pagination_option','Right');
	if($driving_school_lite_post_pagination_alignment == 'Left'){
		$driving_school_lite_custom_css .='.navigation nav.pagination{';
			$driving_school_lite_custom_css .='justify-content: left;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_post_pagination_alignment == 'Center'){
		$driving_school_lite_custom_css .='.navigation nav.pagination{';
			$driving_school_lite_custom_css .='justify-content: center;';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_post_pagination_alignment == 'Right'){
		$driving_school_lite_custom_css .='.navigation nav.pagination{';
			$driving_school_lite_custom_css .='justify-content: right;';
		$driving_school_lite_custom_css .='}';
	}

	//Blog Post Initial Cap
	$driving_school_lite_initial_caps_enable = get_theme_mod('driving_school_lite_initial_caps_enable', 'false');
	if($driving_school_lite_initial_caps_enable == 'true' ){
		$driving_school_lite_custom_css .='.blogger .entry-content p:nth-of-type(1)::first-letter,.blogger p:nth-of-type(1)::first-letter{';
			$driving_school_lite_custom_css .=' font-size: 60px!important; font-weight: 800!important;';
		$driving_school_lite_custom_css .=' margin-right: 4px; text-transform: uppercase;';
			$driving_school_lite_custom_css .=' font-family: "Vollkorn", serif!important;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_initial_caps_enable == 'false' ){
		$driving_school_lite_custom_css .='.blogger .entry-content p:nth-of-type(1)::first-letter,.blogger p:nth-of-type(1)::first-letter{';
			$driving_school_lite_custom_css .='display: none!important;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- Related posts image css-----*/
	$driving_school_lite_related_posts_image_shadow = get_theme_mod('driving_school_lite_related_posts_image_shadow');
	if($driving_school_lite_related_posts_image_shadow != false){
		$driving_school_lite_custom_css .='.related-posts .blog-sec img{';
			$driving_school_lite_custom_css .='box-shadow: '.esc_attr($driving_school_lite_related_posts_image_shadow).'px '.esc_attr($driving_school_lite_related_posts_image_shadow).'px '.esc_attr($driving_school_lite_related_posts_image_shadow).'px #aaa;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_related_image_border_radius = get_theme_mod('driving_school_lite_related_image_border_radius');
	if($driving_school_lite_related_image_border_radius != false){
		$driving_school_lite_custom_css .='.related-posts .blog-sec img{';
			$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_related_image_border_radius).'px;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- Related Post display type css ------*/
	$driving_school_lite_related_post_display_type = get_theme_mod('driving_school_lite_related_post_display_type', 'blocks');
	if($driving_school_lite_related_post_display_type == 'without blocks' ){
		$driving_school_lite_custom_css .='.related-posts .blog-sec{';
			$driving_school_lite_custom_css .='border: 0!important;';
		$driving_school_lite_custom_css .='}';
	}

	// Metabox Seperator related post
	$driving_school_lite_related_post_metabox_seperator = get_theme_mod('driving_school_lite_related_post_metabox_seperator', '|');
	if($driving_school_lite_related_post_metabox_seperator != '' ){
		$driving_school_lite_custom_css .='.related-posts .blog-sec .post-info span:after{';
			$driving_school_lite_custom_css .=' content: "'.esc_attr($driving_school_lite_related_post_metabox_seperator).'"; padding-left:10px;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.related-posts .blog-sec .post-info span:last-child:after{';
			$driving_school_lite_custom_css .=' content: none;';
		$driving_school_lite_custom_css .='}';
	}	

	/*------ Sticky header padding ------------*/
	$driving_school_lite_top_sticky_header_padding = get_theme_mod('driving_school_lite_top_sticky_header_padding');
	$driving_school_lite_bottom_sticky_header_padding = get_theme_mod('driving_school_lite_bottom_sticky_header_padding');
	$driving_school_lite_custom_css .=' .fixed-header{';
		$driving_school_lite_custom_css .=' padding-top: '.esc_attr($driving_school_lite_top_sticky_header_padding).'px; padding-bottom: '.esc_attr($driving_school_lite_bottom_sticky_header_padding).'px';
	$driving_school_lite_custom_css .='}';

	// featured image dimention
	$driving_school_lite_blog_image_dimension = get_theme_mod('driving_school_lite_blog_image_dimension', 'default');
	$driving_school_lite_feature_image_custom_width = get_theme_mod('driving_school_lite_feature_image_custom_width',250);
	$driving_school_lite_feature_image_custom_height = get_theme_mod('driving_school_lite_feature_image_custom_height',250);
	if($driving_school_lite_blog_image_dimension == 'custom'){
		$driving_school_lite_custom_css .='#blog_post .blog-sec img{';
			$driving_school_lite_custom_css .='width: '.esc_attr($driving_school_lite_feature_image_custom_width).'px; height: '.esc_attr($driving_school_lite_feature_image_custom_height).'px;';
		$driving_school_lite_custom_css .='}';
	}

	/*------ Related products ---------*/
	$driving_school_lite_related_products = get_theme_mod('driving_school_lite_single_related_products',true);
	if($driving_school_lite_related_products == false){
		$driving_school_lite_custom_css .=' .related.products{';
			$driving_school_lite_custom_css .='display: none;';
		$driving_school_lite_custom_css .='}';
	}

	/*---- nav menu css ----*/
	if (!has_nav_menu('primary')){
		$driving_school_lite_custom_css .=' hr.dash{';
			$driving_school_lite_custom_css .='margin-top: -8px;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .=' @media screen and (max-width:1000px){
			hr.dash{';
			$driving_school_lite_custom_css .='margin-top: -30px;';
		$driving_school_lite_custom_css .='} }';
	}

	/*-------- Menu Font Size --------*/
	$driving_school_lite_menu_font_size = get_theme_mod('driving_school_lite_menu_font_size',14);
	if($driving_school_lite_menu_font_size != false){
		$driving_school_lite_custom_css .='.nav-menu li a{';
			$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_menu_font_size).'px;';
		$driving_school_lite_custom_css .='}';
	}

	$driving_school_lite_menu_font_weight = get_theme_mod('driving_school_lite_menu_font_weight');
	$driving_school_lite_custom_css .='.nav-menu li a{';
		$driving_school_lite_custom_css .='font-weight: '.esc_attr($driving_school_lite_menu_font_weight).';';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_menu_case = get_theme_mod('driving_school_lite_menu_case', 'uppercase');
	if($driving_school_lite_menu_case == 'uppercase' ){
		$driving_school_lite_custom_css .='.nav-menu li a{';
			$driving_school_lite_custom_css .=' text-transform: uppercase;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_menu_case == 'capitalize' ){
		$driving_school_lite_custom_css .='.nav-menu li a{';
			$driving_school_lite_custom_css .=' text-transform: capitalize;';
		$driving_school_lite_custom_css .='}';
	}

	// Social Icons Font Size
	$driving_school_lite_social_icons_font_size = get_theme_mod('driving_school_lite_social_icons_font_size', '15');
	$driving_school_lite_custom_css .='.social-media i{';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_social_icons_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	//Header icon color
	$driving_school_lite_header_icon_color = get_theme_mod('driving_school_lite_header_icon_color', '');
	$driving_school_lite_custom_css .='.social-media i{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_header_icon_color).'!important;';
	$driving_school_lite_custom_css .='}';

	// Featured image header
	$header_image_url = driving_school_lite_banner_image( $image_url = '' );
	$driving_school_lite_custom_css .='#page-site-header{';
		$driving_school_lite_custom_css .='background-image: url('. esc_url( $header_image_url ).'); background-size: cover;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_post_featured_image = get_theme_mod('driving_school_lite_post_featured_image', 'in-content');
	if($driving_school_lite_post_featured_image == 'banner' ){
		$driving_school_lite_custom_css .='.single #wrapper h1, .page #wrapper h1, .page #wrapper img, .page .title-box h1{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.page-template-custom-front-page #page-site-header{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='}';
	}

	// Woocommerce Shop page pagination
	$driving_school_lite_shop_page_navigation = get_theme_mod('driving_school_lite_shop_page_navigation',true);
	if ($driving_school_lite_shop_page_navigation == false) {
		$driving_school_lite_custom_css .='.woocommerce nav.woocommerce-pagination{';
			$driving_school_lite_custom_css .='display: none;';
		$driving_school_lite_custom_css .='}';
	}

	// Slider Button color
	$driving_school_lite_slider_btn_color = get_theme_mod('driving_school_lite_slider_btn_color','#fff');
	$driving_school_lite_custom_css .='.more-btn a{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_slider_btn_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// Slider button bg color
	$driving_school_lite_slider_btn_bg_color = get_theme_mod('driving_school_lite_slider_btn_bg_color','#000');
	$driving_school_lite_custom_css .='.more-btn span,.more-btn a{';
			$driving_school_lite_custom_css .='background: '.esc_attr($driving_school_lite_slider_btn_bg_color).' !important;';
	$driving_school_lite_custom_css .='}';

	/*---- Slider Height ------*/
	$driving_school_lite_slider_height = get_theme_mod('driving_school_lite_slider_height');
	$driving_school_lite_custom_css .='#slider img{';
		$driving_school_lite_custom_css .='height: '.esc_attr($driving_school_lite_slider_height).'px;';
	$driving_school_lite_custom_css .='}';
	$driving_school_lite_custom_css .='@media screen and (max-width: 768px){
		#slider img{';
		$driving_school_lite_custom_css .='height: auto;';
	$driving_school_lite_custom_css .='} }';

	/*--------------------------- Slider Opacity -------------------*/
	$driving_school_lite_theme_lay = get_theme_mod( 'driving_school_lite_slider_image_opacity','0.9');
	if($driving_school_lite_theme_lay == '0'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.1'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.1';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.2'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.2';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.3'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.3';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.4'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.4';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.5'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.5';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.6'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.6';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.7'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.7';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.8'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.8';
		$driving_school_lite_custom_css .='}';
		}else if($driving_school_lite_theme_lay == '0.9'){
		$driving_school_lite_custom_css .='#slider img{';
			$driving_school_lite_custom_css .='opacity:0.9';
		$driving_school_lite_custom_css .='}';
		}

	/*----- Blog Post display type css ------*/
	$driving_school_lite_blog_post_display_type = get_theme_mod('driving_school_lite_blog_post_display_type', 'blocks');
	if($driving_school_lite_blog_post_display_type == 'without blocks' ){
		$driving_school_lite_custom_css .='.blog .blog-sec{';
			$driving_school_lite_custom_css .='border: 0;';
		$driving_school_lite_custom_css .='}';
	}

	/*---------- Responsive style ---------*/
	if (get_theme_mod('driving_school_lite_hide_topbar_responsive',true) == true && get_theme_mod('driving_school_lite_top_header',true) == false) {
		$driving_school_lite_custom_css .='.topbar{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} ';
	}
	if (get_theme_mod('driving_school_lite_hide_topbar_responsive',true) == false) {
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			.topbar{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} }';
	} else if(get_theme_mod('driving_school_lite_hide_topbar_responsive',true) == true){
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			.topbar{';
			$driving_school_lite_custom_css .=' display: block;';
		$driving_school_lite_custom_css .='} }';
	}

	if (get_theme_mod('driving_school_lite_sticky_header_responsive') == false) {
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			.sticky{';
			$driving_school_lite_custom_css .=' position: static;';
		$driving_school_lite_custom_css .='} }';
	}

	$driving_school_lite_resp_sidebar = get_theme_mod( 'driving_school_lite_sidebar_hide_show',true);
    if($driving_school_lite_resp_sidebar == true){
    	$driving_school_lite_custom_css .='@media screen and (max-width:575px) {';
		$driving_school_lite_custom_css .='#sidebar{';
			$driving_school_lite_custom_css .='display:block;';
		$driving_school_lite_custom_css .='} }';
	}else if($driving_school_lite_resp_sidebar == false){
		$driving_school_lite_custom_css .='@media screen and (max-width:575px) {';
		$driving_school_lite_custom_css .='#sidebar{';
			$driving_school_lite_custom_css .='display:none;';
		$driving_school_lite_custom_css .='} }';
	}

	// Metabox Seperator
	$driving_school_lite_metabox_seperator = get_theme_mod('driving_school_lite_metabox_seperator','|');
	if($driving_school_lite_metabox_seperator != '' ){
		$driving_school_lite_custom_css .='#blog_post .blog-sec .post-info span:after{';
			$driving_school_lite_custom_css .=' content: "'.esc_attr($driving_school_lite_metabox_seperator).'"; padding-left:10px;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='#blog_post .blog-sec .post-info span:last-child:after{';
			$driving_school_lite_custom_css .=' content: none;';
		$driving_school_lite_custom_css .='}';
	}

	// Metabox Seperator Single post
	$driving_school_lite_single_post_metabox_seperator = get_theme_mod('driving_school_lite_single_post_metabox_seperator','|');
	if($driving_school_lite_single_post_metabox_seperator != '' ){
		$driving_school_lite_custom_css .='.post-info span:after{';
			$driving_school_lite_custom_css .=' content: "'.esc_attr($driving_school_lite_single_post_metabox_seperator).'"; padding-left:10px;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.post-info span:last-child:after{';
			$driving_school_lite_custom_css .=' content: none;';
		$driving_school_lite_custom_css .='}';
	}

	// Metabox Seperator Grid post
	$driving_school_lite_grid_post_metabox_seperator = get_theme_mod('driving_school_lite_grid_post_metabox_seperator','|');
	if($driving_school_lite_grid_post_metabox_seperator != '' ){
		$driving_school_lite_custom_css .='.grid-post-info span:after{';
			$driving_school_lite_custom_css .=' content: "'.esc_attr($driving_school_lite_grid_post_metabox_seperator).'"; padding-left:10px;';
		$driving_school_lite_custom_css .='}';
		$driving_school_lite_custom_css .='.grid-post-info span:last-child:after{';
			$driving_school_lite_custom_css .=' content: none;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- grid Post display type css ------*/
	$driving_school_lite_grid_post_display_type = get_theme_mod('driving_school_lite_grid_post_display_type', 'blocks');
	if($driving_school_lite_grid_post_display_type == 'without blocks' ){
		$driving_school_lite_custom_css .='.grid-sec{';
			$driving_school_lite_custom_css .='border: 0;';
		$driving_school_lite_custom_css .='}';
	}

	/*----- grid Post css ------*/
	$driving_school_lite_grid_post_image_border_radius = get_theme_mod('driving_school_lite_grid_post_image_border_radius');
	 if($driving_school_lite_grid_post_image_border_radius != false){
		 $driving_school_lite_custom_css .='.grid-sec img{';
			 $driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_grid_post_image_border_radius).'px;';
		 $driving_school_lite_custom_css .='}';
	 }
 
	$driving_school_lite_grid_posts_image_shadow = get_theme_mod('driving_school_lite_grid_posts_image_shadow');
	if($driving_school_lite_grid_posts_image_shadow != false){
		$driving_school_lite_custom_css .='.grid-sec img{';
			$driving_school_lite_custom_css .='box-shadow: '.esc_attr($driving_school_lite_grid_posts_image_shadow).'px '.esc_attr($driving_school_lite_grid_posts_image_shadow).'px '.esc_attr($driving_school_lite_grid_posts_image_shadow).'px #aaa;';
		$driving_school_lite_custom_css .='}';
	}

	/*-------- grid post Alignment ------*/
	$driving_school_lite_grid_alignment = get_theme_mod('driving_school_lite_grid_alignment','center');
	if($driving_school_lite_grid_alignment == 'left' ){
		$driving_school_lite_custom_css .='.grid-sec, .grid-sec h2, .grid-post-info, .grid-sec .entry-content, .grid-sec .blogbtn{';
			$driving_school_lite_custom_css .=' text-align: '. $driving_school_lite_grid_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_grid_alignment == 'right' ){
		$driving_school_lite_custom_css .='.grid-sec, .grid-sec h2, .grid-post-info, .grid-sec .entry-content, .grid-sec .blogbtn{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_grid_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_grid_alignment == 'center' ){
		$driving_school_lite_custom_css .='.grid-sec, .grid-sec h2, .grid-post-info, .grid-sec .entry-content, .grid-sec .blogbtn{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_grid_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}
	
	/*-------- Blog Post Alignment ------*/
	$driving_school_lite_post_alignment = get_theme_mod('driving_school_lite_blog_post_alignment', 'center');
	if($driving_school_lite_post_alignment == 'left' ){
		$driving_school_lite_custom_css .='.blog-sec, .blog-sec h2, .post-info, .blog-sec .blogbtn{';
			$driving_school_lite_custom_css .=' text-align: '. $driving_school_lite_post_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_post_alignment == 'right' ){
		$driving_school_lite_custom_css .='.blog-sec, .blog-sec h2, .post-info, .blog-sec .blogbtn{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_post_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_post_alignment == 'center' ){
		$driving_school_lite_custom_css .='.blog-sec, .blog-sec h2, .post-info, .blog-sec .blogbtn{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_post_alignment .'!important;';
		$driving_school_lite_custom_css .='}';
	}		

	// Site title Font Size
	$driving_school_lite_site_title_font_size = get_theme_mod('driving_school_lite_site_title_font_size', '25');
	$driving_school_lite_custom_css .='.logo h1, .logo p.site-title{';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_site_title_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	// Site tagline Font Size
	$driving_school_lite_site_tagline_font_size = get_theme_mod('driving_school_lite_site_tagline_font_size', '12');
	$driving_school_lite_custom_css .='.logo p.site-description{';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_site_tagline_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	/*---- Slider Content Position -----*/
	$driving_school_lite_top_position = get_theme_mod('driving_school_lite_slider_top_position');
	$driving_school_lite_bottom_position = get_theme_mod('driving_school_lite_slider_bottom_position');
	$driving_school_lite_left_position = get_theme_mod('driving_school_lite_slider_left_position');
	$driving_school_lite_right_position = get_theme_mod('driving_school_lite_slider_right_position');
	if($driving_school_lite_top_position != false || $driving_school_lite_bottom_position != false || $driving_school_lite_left_position != false || $driving_school_lite_right_position != false){
		$driving_school_lite_custom_css .='#slider .inner_carousel{';
			$driving_school_lite_custom_css .='top: '.esc_attr($driving_school_lite_top_position).'%; bottom: '.esc_attr($driving_school_lite_bottom_position).'%; left: '.esc_attr($driving_school_lite_left_position).'%; right: '.esc_attr($driving_school_lite_right_position).'%;';
		$driving_school_lite_custom_css .='}';
	}

	// responsive settings
	$driving_school_lite_toggle_button_bg_color_settings = get_theme_mod('driving_school_lite_toggle_button_bg_color_settings');
	$driving_school_lite_custom_css .='.toggle-menu {';
	$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_toggle_button_bg_color_settings).';';
	$driving_school_lite_custom_css .='} ';
	
	if (get_theme_mod('driving_school_lite_preloader_responsive',false) == true && get_theme_mod('driving_school_lite_preloader',false) == false) {
		$driving_school_lite_custom_css .='@media screen and (min-width: 575px){
			.preloader, #overlayer, .tg-loader{';
			$driving_school_lite_custom_css .=' visibility: hidden;';
		$driving_school_lite_custom_css .='} }';
	}
	if (get_theme_mod('driving_school_lite_preloader_responsive',false) == false) {
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			.preloader, #overlayer, .tg-loader{';
			$driving_school_lite_custom_css .=' visibility: hidden;';
		$driving_school_lite_custom_css .='} }';
	}

	// scroll to top
	$driving_school_lite_scroll = get_theme_mod( 'driving_school_lite_backtotop_responsive',true);
	if (get_theme_mod('driving_school_lite_backtotop_responsive',true) == true && get_theme_mod('driving_school_lite_hide_scroll',true) == false) {
    	$driving_school_lite_custom_css .='.show-back-to-top{';
			$driving_school_lite_custom_css .='visibility: hidden !important;';
		$driving_school_lite_custom_css .='} ';
	}
    if($driving_school_lite_scroll == true){
    	$driving_school_lite_custom_css .='@media screen and (max-width:575px) {';
		$driving_school_lite_custom_css .='.show-back-to-top{';
			$driving_school_lite_custom_css .='visibility: visible !important;';
		$driving_school_lite_custom_css .='} }';
	}else if($driving_school_lite_scroll == false){
		$driving_school_lite_custom_css .='@media screen and (max-width:575px) {';
		$driving_school_lite_custom_css .='.show-back-to-top{';
			$driving_school_lite_custom_css .='visibility: hidden !important;';
		$driving_school_lite_custom_css .='} }';
	}

	/*------ Footer background css -------*/
	$driving_school_lite_copyright_bg_color = get_theme_mod('driving_school_lite_copyright_bg_color');
	if($driving_school_lite_copyright_bg_color != false){
		$driving_school_lite_custom_css .='.inner{';
			$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_copyright_bg_color).';';
		$driving_school_lite_custom_css .='}';
	}

	// site logo padding 
	$driving_school_lite_logo_spacing = get_theme_mod('driving_school_lite_logo_spacing', '');
	$driving_school_lite_custom_css .='.logo{';
	$driving_school_lite_custom_css .='padding: '.esc_attr($driving_school_lite_logo_spacing).'px !important;';
	$driving_school_lite_custom_css .='}';

	// site title color
	$driving_school_lite_site_title_text_color = get_theme_mod('driving_school_lite_site_title_text_color');
	$driving_school_lite_custom_css .='.logo h1 a, .logo p.site-title a{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_site_title_text_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// site tagline color
	$driving_school_lite_site_tagline_text_color = get_theme_mod('driving_school_lite_site_tagline_text_color');
	$driving_school_lite_custom_css .='.logo p.site-description{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_site_tagline_text_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// responsive slider
	if (get_theme_mod('driving_school_lite_slider_responsive',true) == true && get_theme_mod('driving_school_lite_slider_hide',false) == false) {
		$driving_school_lite_custom_css .='@media screen and (min-width: 575px){
			#slider{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} }';
	}
	if (get_theme_mod('driving_school_lite_slider_responsive',true) == false) {
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			#slider{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} }';
	}

	// slider button
	if (get_theme_mod('driving_school_lite_slider_button_responsive',true) == true && get_theme_mod('driving_school_lite_slider_button',true) == false) {
		$driving_school_lite_custom_css .='@media screen and (min-width: 575px){
			.more-btn{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} }';
	}
	if (get_theme_mod('driving_school_lite_slider_button_responsive',true) == false) {
		$driving_school_lite_custom_css .='@media screen and (max-width: 575px){
			.more-btn{';
			$driving_school_lite_custom_css .=' display: none;';
		$driving_school_lite_custom_css .='} }';
	}

	// menu padding
	$driving_school_lite_menu_padding = get_theme_mod('driving_school_lite_menu_padding',22);
	$driving_school_lite_custom_css .='.nav-menu ul li a, .sf-arrows ul .sf-with-ul, .sf-arrows .sf-with-ul{';
		$driving_school_lite_custom_css .='padding: '.esc_attr($driving_school_lite_menu_padding).'px;';
	$driving_school_lite_custom_css .='}';

	// menu color
	$driving_school_lite_menu_color = get_theme_mod('driving_school_lite_menu_color');
	$driving_school_lite_custom_css .='.nav-menu a, .nav-menu .current-menu-item > a, .nav-menu .current_page_ancestor > a{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_menu_color).' !important;';
	$driving_school_lite_custom_css .='}';

	$driving_school_lite_menus_item = get_theme_mod( 'driving_school_lite_menus_item_style','None');
    if($driving_school_lite_menus_item == 'None'){
		$driving_school_lite_custom_css .='.nav-menu ul li a{';
			$driving_school_lite_custom_css .='';
		$driving_school_lite_custom_css .='}';
	}else if($driving_school_lite_menus_item == 'Zoom In'){
		$driving_school_lite_custom_css .='.nav-menu ul li a:hover{';
			$driving_school_lite_custom_css .='transition: all 0.3s ease-in-out !important; transform: scale(1.2) !important;';
		$driving_school_lite_custom_css .='}';
	}else if ($driving_school_lite_menus_item == 'Underline Expand') { 
		$driving_school_lite_custom_css .= '.nav-menu ul li a { position: relative; text-decoration: none; }';
	$driving_school_lite_custom_css .= '.nav-menu ul li a::after {';
		$driving_school_lite_custom_css .= 'content: ""; position: absolute; left: 50%; bottom: calc(' . esc_attr($driving_school_lite_menu_padding) . 'px / 2); width: 0; height: 2px; background-color: currentColor;';
	$driving_school_lite_custom_css .= 'transition: width 0.3s ease, left 0.3s ease;';
		$driving_school_lite_custom_css .= '}';
	$driving_school_lite_custom_css .= '.nav-menu ul li a:hover::after {';
		$driving_school_lite_custom_css .= 'width: 100%; left: 0;';
	$driving_school_lite_custom_css .= '}';
}		

	// menu hover color
	$driving_school_lite_menu_hover_color = get_theme_mod('driving_school_lite_menu_hover_color');
	$driving_school_lite_custom_css .='.nav-menu a:hover, .nav-menu ul li a:hover{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_menu_hover_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// Submenu color
	$driving_school_lite_submenu_menu_color = get_theme_mod('driving_school_lite_submenu_menu_color');
	$driving_school_lite_custom_css .='.nav-menu ul.sub-menu a, .nav-menu ul.sub-menu li a,.nav-menu ul.children a, .nav-menu ul.children li a{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_submenu_menu_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// submenu hover color
	$driving_school_lite_submenu_hover_color = get_theme_mod('driving_school_lite_submenu_hover_color');
	$driving_school_lite_custom_css .='.nav-menu ul.sub-menu a:hover, .nav-menu ul.sub-menu li a:hover,.nav-menu ul.children a:hover, .nav-menu ul.children li a:hover{';
			$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_submenu_hover_color).' !important;';
	$driving_school_lite_custom_css .='}';

	// Breadcrumb Alignmennt
	$driving_school_lite_single_page_breadcrumb_alignment = get_theme_mod('driving_school_lite_single_page_breadcrumb_alignment', 'Left');
	if($driving_school_lite_single_page_breadcrumb_alignment == 'Center' ){
		$driving_school_lite_custom_css .='.bradcrumbs{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_single_page_breadcrumb_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_single_page_breadcrumb_alignment == 'Left' ){
		$driving_school_lite_custom_css .='.bradcrumbs{';
			$driving_school_lite_custom_css .=' text-align: '. $driving_school_lite_single_page_breadcrumb_alignment .';';
		$driving_school_lite_custom_css .='}';
	}elseif($driving_school_lite_single_page_breadcrumb_alignment == 'Right' ){
		$driving_school_lite_custom_css .='.bradcrumbs{';
			$driving_school_lite_custom_css .='text-align: '. $driving_school_lite_single_page_breadcrumb_alignment .';';
		$driving_school_lite_custom_css .='}';
	}

	// Breadcrumb color option
	$driving_school_lite_breadcrumb_color = get_theme_mod('driving_school_lite_breadcrumb_color');
	$driving_school_lite_custom_css .='.bradcrumbs a,.bradcrumbs span{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_breadcrumb_color).'!important;';
	$driving_school_lite_custom_css .='}';

	// Breadcrumb bg color option
	$driving_school_lite_breadcrumb_background_color = get_theme_mod('driving_school_lite_breadcrumb_background_color');
	$driving_school_lite_custom_css .='.bradcrumbs a,.bradcrumbs span{';
		$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_breadcrumb_background_color).'!important;';
	$driving_school_lite_custom_css .='}';

	// Breadcrumb hover color option
	$driving_school_lite_breadcrumb_hover_color = get_theme_mod('driving_school_lite_breadcrumb_hover_color');
	$driving_school_lite_custom_css .='.bradcrumbs a:hover{';
		$driving_school_lite_custom_css .='color: '.esc_attr($driving_school_lite_breadcrumb_hover_color).'!important;';
	$driving_school_lite_custom_css .='}';

	// Breadcrumb hover bg color option
	$driving_school_lite_breadcrumb_hover_bg_color = get_theme_mod('driving_school_lite_breadcrumb_hover_bg_color');
	$driving_school_lite_custom_css .='.bradcrumbs a:hover{';
		$driving_school_lite_custom_css .='background-color: '.esc_attr($driving_school_lite_breadcrumb_hover_bg_color).'!important;';
	$driving_school_lite_custom_css .='}';

	// site logo margin 
	$driving_school_lite_logo_margin = get_theme_mod('driving_school_lite_logo_margin', '');
	$driving_school_lite_custom_css .='.logo{';
	$driving_school_lite_custom_css .='margin: '.esc_attr($driving_school_lite_logo_margin).'px;';
	$driving_school_lite_custom_css .='}';

	// Single post image border radious
	$driving_school_lite_single_post_img_border_radius = get_theme_mod('driving_school_lite_single_post_img_border_radius', 0);
	$driving_school_lite_custom_css .='.feature-box img{';
		$driving_school_lite_custom_css .='border-radius: '.esc_attr($driving_school_lite_single_post_img_border_radius).'px;';
	$driving_school_lite_custom_css .='}';

	// Single post image box shadow
	$driving_school_lite_single_post_img_box_shadow = get_theme_mod('driving_school_lite_single_post_img_box_shadow',0);
	$driving_school_lite_custom_css .='.feature-box img{';
		$driving_school_lite_custom_css .='box-shadow: '.esc_attr($driving_school_lite_single_post_img_box_shadow).'px '.esc_attr($driving_school_lite_single_post_img_box_shadow).'px '.esc_attr($driving_school_lite_single_post_img_box_shadow).'px #ccc;';
	$driving_school_lite_custom_css .='}';

	// single post image dimention
	$driving_school_lite_single_post_image_dimension = get_theme_mod('driving_school_lite_single_post_image_dimension', 'default');
	$driving_school_lite_single_post_image_custom_width = get_theme_mod('driving_school_lite_single_post_image_custom_width',400);
	$driving_school_lite_single_post_image_custom_height = get_theme_mod('driving_school_lite_single_post_image_custom_height',400);
	if($driving_school_lite_single_post_image_dimension == 'custom'){
		$driving_school_lite_custom_css .='.singlepost-page .feature-box img{';
			$driving_school_lite_custom_css .='width: '.esc_attr($driving_school_lite_single_post_image_custom_width).'px; height: '.esc_attr($driving_school_lite_single_post_image_custom_height).'px;';
		$driving_school_lite_custom_css .='}';
	}

	// Button Font Size
	$driving_school_lite_button_font_size = get_theme_mod('driving_school_lite_button_font_size', '16');
	$driving_school_lite_custom_css .='.blogbtn a{';
		$driving_school_lite_custom_css .='font-size: '.esc_attr($driving_school_lite_button_font_size).'px;';
	$driving_school_lite_custom_css .='}';

	// sticky sidebar
	$driving_school_lite_sticky_sidebar = get_theme_mod('driving_school_lite_sticky_sidebar');
	if ( $driving_school_lite_sticky_sidebar ) {
		$driving_school_lite_custom_css .= '@media (min-width: 768px) {';
			$driving_school_lite_custom_css .= '#sidebar {';
				$driving_school_lite_custom_css .= 'position: sticky;';
				$driving_school_lite_custom_css .= 'top: 25px;';
				$driving_school_lite_custom_css .= 'align-self: start;';
			$driving_school_lite_custom_css .= '}';
		$driving_school_lite_custom_css .= '}';
	}

	// Copyright Sticky 
	$driving_school_lite_resp_stickycopyright = get_theme_mod( 'driving_school_lite_stickycopyright_hide_show',false);
	if($driving_school_lite_resp_stickycopyright == true && get_theme_mod( 'driving_school_lite_copyright_sticky',false) != true){
    	$driving_school_lite_custom_css .='.copyright-sticky{';
			$driving_school_lite_custom_css .='position:static;';
		$driving_school_lite_custom_css .='} ';
	}	