<?php
/**
 * The template for displaying the footer.
 * @package Driving School Lite
 */
?>
<?php if( get_theme_mod( 'driving_school_lite_hide_scroll',true) != '' || get_theme_mod( 'driving_school_lite_backtotop_responsive',true) != '') { ?>
  <?php $driving_school_lite_scroll_align = get_theme_mod( 'driving_school_lite_back_to_top','Right');
  if($driving_school_lite_scroll_align == 'Left'){ ?>
    <a href="#content" class="back-to-top scroll-left text-center"><?php esc_html_e('Top', 'driving-school-lite'); ?><span class="screen-reader-text"><?php esc_html_e('Back to Top', 'driving-school-lite'); ?></span></a>
  <?php }else if($driving_school_lite_scroll_align == 'Center'){ ?>
    <a href="#content" class="back-to-top scroll-center text-center"><?php esc_html_e('Top', 'driving-school-lite'); ?><span class="screen-reader-text"><?php esc_html_e('Back to Top', 'driving-school-lite'); ?></span></a>
  <?php }else{ ?>
    <a href="#content" class="back-to-top scroll-right text-center"><?php esc_html_e('Top', 'driving-school-lite'); ?><span class="screen-reader-text"><?php esc_html_e('Back to Top', 'driving-school-lite'); ?></span></a>
  <?php }?>
<?php }?>
<footer role="contentinfo" id="footer" class="copyright-wrapper">
  <?php //Set widget areas classes based on user choice
    $driving_school_lite_footer_columns = get_theme_mod('driving_school_lite_footer_widget', '4');
    if ($driving_school_lite_footer_columns == '3') {
      $driving_school_lite_cols = 'col-lg-4 col-md-4';
    } elseif ($driving_school_lite_footer_columns == '4') {
      $driving_school_lite_cols = 'col-lg-3 col-md-3';
    } elseif ($driving_school_lite_footer_columns == '2') {
      $driving_school_lite_cols = 'col-lg-6 col-md-6';
    } else {
      $driving_school_lite_cols = 'col-lg-12 col-md-12';
    }
  ?>
  <?php if (get_theme_mod('driving_school_lite_footer_hide_show', true)){ ?>
    <div class="footerinner py-4">
      <div class="container">
      <div class="row">
        <!-- Footer 1 -->
        <div class="<?php echo esc_attr($driving_school_lite_cols); ?> footer-block wow zoomIn">
            <?php if (is_active_sidebar('footer-1')) : ?>
                <?php dynamic_sidebar('footer-1'); ?>
            <?php else : ?>
                <aside id="categories" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'driving-school-lite'); ?>">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'driving-school-lite'); ?></h3>
                    <ul>
                        <?php wp_list_categories('title_li='); ?>
                    </ul>
                </aside>
            <?php endif; ?>
        </div>

        <!-- Footer 2 -->
        <div class="<?php echo esc_attr($driving_school_lite_cols); ?> footer-block wow zoomIn">
            <?php if (is_active_sidebar('footer-2')) : ?>
                <?php dynamic_sidebar('footer-2'); ?>
            <?php else : ?>
                <aside id="archives" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'driving-school-lite'); ?>">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'driving-school-lite'); ?></h3>
                    <ul>
                        <?php wp_get_archives(array('type' => 'monthly')); ?>
                    </ul>
                </aside>
            <?php endif; ?>
        </div>

        <!-- Footer 3 -->
        <div class="<?php echo esc_attr($driving_school_lite_cols); ?> footer-block wow zoomIn">
            <?php if (is_active_sidebar('footer-3')) : ?>
                <?php dynamic_sidebar('footer-3'); ?>
            <?php else : ?>
                <aside id="meta" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'driving-school-lite'); ?>">
                    <h3 class="widget-title"><?php esc_html_e('Meta', 'driving-school-lite'); ?></h3>
                    <ul>
                        <?php wp_register(); ?>
                        <li><?php wp_loginout(); ?></li>
                        <?php wp_meta(); ?>
                    </ul>
                </aside>
            <?php endif; ?>
        </div>

        <!-- Footer 4 -->
        <div class="<?php echo esc_attr($driving_school_lite_cols); ?> footer-block wow zoomIn">
            <?php if (is_active_sidebar('footer-4')) : ?>
                <?php dynamic_sidebar('footer-4'); ?>
            <?php else : ?>
                <aside id="search-widget" class="widget py-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'driving-school-lite'); ?>">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'driving-school-lite'); ?></h3>
                    <?php the_widget('WP_Widget_Search'); ?>
                </aside>
            <?php endif; ?>
        </div>
      </div>
      </div>
    </div>
  <?php } ?>  
  <div class="footer <?php if( get_theme_mod( 'driving_school_lite_copyright_sticky', false) == 1) { ?> copyright-sticky<?php } else { ?>close-sticky <?php } ?>">     
  <?php if (get_theme_mod('driving_school_lite_copyright_hide_show', true)) {?>
    <div class="inner py-2">
      <div class="copyright">
        <div class="container">
          <p><span class="black px-2"><?php driving_school_lite_credit_link(); ?> <?php echo esc_html(get_theme_mod('driving_school_lite_text',__('By Themesglance','driving-school-lite'))); ?></span></p>
            <?php if(get_theme_mod('driving_school_lite_footer_social_media_hide_show',false)){ ?>
              <div class="mt-2">
                <?php if( get_theme_mod( 'driving_school_lite_footer_facebook' ) != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'driving_school_lite_footer_facebook','' ) ); ?>" class="px-1"><i class="<?php echo esc_html(get_theme_mod('driving_school_lite_footer_facebook_icon','fab fa-facebook-f')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Facebook','driving-school-lite'); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'driving_school_lite_footer_twitter' ) != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'driving_school_lite_footer_twitter','' ) ); ?>" class="px-1"><i class="<?php echo esc_html(get_theme_mod('driving_school_lite_footer_twitter_icon','fab fa-twitter')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Twitter','driving-school-lite'); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'driving_school_lite_footer_youtube' ) != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'driving_school_lite_footer_youtube','' ) ); ?>" class="px-1"><i class="<?php echo esc_html(get_theme_mod('driving_school_lite_footer_youtube_icon','fab fa-youtube')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Youtube','driving-school-lite'); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'driving_school_lite_footer_linkedin') != '') { ?>
                  <a target="_blank" href="<?php echo esc_url( get_theme_mod( 'driving_school_lite_footer_linkedin','' ) ); ?>" class="px-1"><i class="<?php echo esc_html(get_theme_mod('driving_school_lite_footer_linkedin_icon','fab fa-linkedin-in')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Linkedin','driving-school-lite'); ?></span></a>
                <?php } ?>
              </div>
            <?php } ?>  
        </div>
        <hr class="dash p-1 mb-0 pt-2">
      </div>
    </div>
  <?php }?>   
</footer>
</div>
<?php wp_footer(); ?>
</body>
</html>