<?php
/**
 *  Driving School Lite: Block Patterns
 *
 * @package  Driving School Lite
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'driving-school-lite',
		array( 'label' => __( ' Driving School Lite', 'driving-school-lite' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'driving-school-lite/banner-section',
		array(
			'title'      => __( 'Banner Section', 'driving-school-lite' ),
			'categories' => array( 'driving-school-lite' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/banner.png\",\"id\":722,\"dimRatio\":50,\"align\":\"full\",\"className\":\"main-banner-section\"} -->\n<div class=\"wp-block-cover alignfull main-banner-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-722\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/banner.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"full\",\"className\":\"main-banner-section-col\"} -->\n<div class=\"wp-block-columns alignfull main-banner-section-col\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"main-banner-section-content\"} -->\n<div class=\"wp-block-column main-banner-section-content\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":\"30px\",\"textTransform\":\"uppercase\"}}} -->\n<h2 style=\"font-size:30px;text-transform:uppercase\">Lorem ipsum dolor sit amet.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"black\",\"textColor\":\"white\",\"style\":{\"border\":{\"radius\":\"4px\"}},\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link has-white-color has-black-background-color has-text-color has-background\" style=\"border-radius:4px\">BOOK LESSON</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'driving-school-lite/our-features-section',
		array(
			'title'      => __( 'Our Features Section', 'driving-school-lite' ),
			'categories' => array( 'driving-school-lite' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/features-bg-img.png\",\"id\":735,\"dimRatio\":50,\"minHeight\":155,\"minHeightUnit\":\"px\",\"align\":\"full\",\"className\":\"our-features\"} -->\n<div class=\"wp-block-cover alignfull our-features\" style=\"min-height:155px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-735\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/features-bg-img.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"has-text-align-center\">OUR FEATURES</h2>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'driving-school-lite/service-section',
		array(
			'title'      => __( 'Service Section', 'driving-school-lite' ),
			'categories' => array( 'driving-school-lite' ),
			'content'    => "<!-- wp:columns {\"className\":\"our-features-next-col position-relative \"} -->\n<div class=\"wp-block-columns our-features-next-col position-relative\"><!-- wp:column {\"className\":\"our-features-col\"} -->\n<div class=\"wp-block-column our-features-col\"><!-- wp:image {\"align\":\"center\",\"id\":806,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"our-features-next-col-img\"} -->\n<figure class=\"wp-block-image aligncenter size-full our-features-next-col-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/Group 1.png\" alt=\"\" class=\"wp-image-806\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"uppercase\"}},\"className\":\"our-features-heading\"} -->\n<h3 class=\"has-text-align-center our-features-heading\" style=\"font-size:16px;text-transform:uppercase\">Features Title 1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-align-center\" style=\"font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"4px\"}},\"className\":\"read-more\",\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button aligncenter has-custom-font-size read-more has-small-font-size\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" style=\"border-radius:4px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"our-features-col\"} -->\n<div class=\"wp-block-column our-features-col\"><!-- wp:image {\"align\":\"center\",\"id\":807,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"our-features-next-col-img\"} -->\n<figure class=\"wp-block-image aligncenter size-full our-features-next-col-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/Group 2.png\" alt=\"\" class=\"wp-image-807\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"uppercase\"}},\"className\":\"our-features-heading\"} -->\n<h3 class=\"has-text-align-center our-features-heading\" style=\"font-size:16px;text-transform:uppercase\">Features Title 2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-align-center\" style=\"font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"4px\"}},\"className\":\"read-more\",\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button aligncenter has-custom-font-size read-more has-small-font-size\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" style=\"border-radius:4px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"our-features-col\"} -->\n<div class=\"wp-block-column our-features-col\"><!-- wp:image {\"align\":\"center\",\"id\":808,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"our-features-next-col-img\"} -->\n<figure class=\"wp-block-image aligncenter size-full our-features-next-col-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/Group 3.png\" alt=\"\" class=\"wp-image-808\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"uppercase\"}},\"className\":\"our-features-heading\"} -->\n<h3 class=\"has-text-align-center our-features-heading\" style=\"font-size:16px;text-transform:uppercase\">Features Title 3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-align-center\" style=\"font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"4px\"}},\"className\":\"read-more\",\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button aligncenter has-custom-font-size read-more has-small-font-size\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" style=\"border-radius:4px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"our-features-col\"} -->\n<div class=\"wp-block-column our-features-col\"><!-- wp:image {\"align\":\"center\",\"id\":809,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"our-features-next-col-img\"} -->\n<figure class=\"wp-block-image aligncenter size-full our-features-next-col-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/block-patterns/images/Group 4.png\" alt=\"\" class=\"wp-image-809\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"textTransform\":\"uppercase\"}},\"className\":\"our-features-heading\"} -->\n<h3 class=\"has-text-align-center our-features-heading\" style=\"font-size:16px;text-transform:uppercase\">Features Title 4</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p class=\"has-text-align-center\" style=\"font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"white\",\"textColor\":\"black\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"4px\"}},\"className\":\"read-more\",\"fontSize\":\"small\"} -->\n<div class=\"wp-block-button aligncenter has-custom-font-size read-more has-small-font-size\"><a class=\"wp-block-button__link has-black-color has-white-background-color has-text-color has-background\" style=\"border-radius:4px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);
}