<?php
/**
 * Template part post content
 *
 * @package Doo
 */

?>
<article <?php post_class( 'entry' ); ?>>
  
    <?php
    if ( has_post_thumbnail() ) {
    ?>
    <div class="entry-thumbnail">
      <?php the_post_thumbnail();?>
    </div>
    <?php
    }
    ?>

  <div class="post-content">

      <div class="entry-header">
        <h1 class="entry-title"><?php the_title(); ?></h1>
      </div>

      <?php
      $post_date = get_theme_mod( 'post_date', 1 );
      $post_categorys = get_theme_mod( 'post_categorys', 1 );
      $post_comments = get_theme_mod( 'post_comments', 1 );
      $post_post_views = get_theme_mod( 'post_post_views', 0 );
      $post_reading_time = get_theme_mod( 'post_reading_time', 0 );
      if ( $post_date || $post_categorys || $post_comments || $post_post_views || $post_reading_time ) {
      ?>
      <div class="entry-meta">
        <div class="entry-meta-inner">
          <?php
          if ( $post_date ) { vs_get_meta_date(); }
          if ( $post_categorys ) { vs_get_meta_categorys(); }
          if ( $post_comments ) { vs_get_meta_comments(); }
          if ( $post_post_views ) { vs_get_meta_post_views(); }
          if ( $post_reading_time ){ vs_get_meta_reading_time(); }
          ?>
        </div>
      </div>
      <?php
      }
      ?>

      <?php do_action( 'vs_post_content_start' ); ?>
      <div class="entry-content">
        <?php
        the_content();
        ?>
      </div>
      <?php do_action( 'vs_post_content_end' ); ?>
      
      <?php
      $post_tags = get_theme_mod( 'post_tags', 1 );
      if ( $post_tags ) {
      ?>
      <div class="entry-details">
        <div class="entry-details-inner">
          <?php
          if ( $post_tags ) { vs_get_meta_tags(); }
          ?>
        </div>
      </div>
      <?php
      }
      ?>
  </div>
</article>
