<?php
/**
 * Widgets Init
 *
 * @package Doo
 */

if ( ! function_exists( 'vs_widgets_init' ) ) {
  /**
   * Register widget areas.
   *
   * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
   */
  function vs_widgets_init() {

    $tag = apply_filters( 'vs_section_title_tag', 'h5' );

    register_sidebar(
      array(
        'name'          => esc_html__( 'Default Sidebar', 'doo' ),
        'id'            => 'sidebar-1',
        'before_widget' => '<div class="widget %1$s %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<' . $tag . ' class="widget-title">',
        'after_title'   => '</' . $tag . '>',
      )
    );

  }
}
add_action( 'widgets_init', 'vs_widgets_init' );
