<?php
/**
 * Post Settings
 *
 * @package Doo
 */

// Add new section
$wp_customize->add_section( 'post_section', array(
  'title'                => esc_html__( 'Post Settings', 'doo' ),
  'priority'             => 28,
) );

// Sidebar
$wp_customize->add_setting( 'post_sidebar', array(
  'default'              => 'right',
  'sanitize_callback'    => 'vs_sanitize_sidebar',
) );
$wp_customize->add_control( 'post_sidebar', array(
  'label'                => esc_html__( 'Sidebar', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'radio',
  'choices'              => array(
    'right'              => esc_html__( 'Right Sidebar', 'doo' ),
    'left'               => esc_html__( 'Left Sidebar', 'doo' ),
    'disabled'           => esc_html__( 'No Sidebar', 'doo' ),
  ),
) );

// Display about the author
$wp_customize->add_setting( 'post_about_author', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_about_author', array(
  'label'                => esc_html__( 'Display about the author', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display prev next links
$wp_customize->add_setting( 'post_prev_next', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_prev_next', array(
  'label'                => esc_html__( 'Display prev next links', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Heading
$wp_customize->add_setting( 'post_heading_post_meta', array(
  'sanitize_callback'    => 'esc_html',
) );
$wp_customize->add_control( new vs_customize_control_heading( $wp_customize, 'post_heading_post_meta', array(
  'label'                => esc_html__( 'Post Meta', 'doo' ),
  'section'              => 'post_section',
) ) );

// Display Date
$wp_customize->add_setting( 'post_date', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_date', array(
  'label'                => esc_html__( 'Display Date', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Categorys
$wp_customize->add_setting( 'post_categorys', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_categorys', array(
  'label'                => esc_html__( 'Display Categorys', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Comments
$wp_customize->add_setting( 'post_comments', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_comments', array(
  'label'                => esc_html__( 'Display Comments', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Tags
$wp_customize->add_setting( 'post_tags', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_tags', array(
  'label'                => esc_html__( 'Display Tags', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

if ( class_exists( 'Post_Views_Counter' ) ) {
  // Display Post Views
  $wp_customize->add_setting( 'post_post_views', array(
    'default'              => 0,
    'sanitize_callback'    => 'vs_sanitize_checkbox',
  ) );
  $wp_customize->add_control( 'post_post_views', array(
    'label'                => esc_html__( 'Display Post Views', 'doo' ),
    'section'              => 'post_section',
    'type'                 => 'checkbox',
  ) );
}

// Display Reading Time
$wp_customize->add_setting( 'post_reading_time', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_reading_time', array(
  'label'                => esc_html__( 'Display Reading Time', 'doo' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );
