<?php
/**
 * Custom template comment for this theme
 *
 * @package Doo
 */
 
if ( ! function_exists( 'vs_list_comments' ) ) {
  /**
   * Custom comment list
   */
  function vs_list_comments($comment,$args,$depth) {
    if ( $comment->comment_type=='pingback' || $comment->comment_type=='trackback' ) {
  ?>
    <li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
      <div class="comment-body">
        <?php echo esc_html__( 'Pingback:', 'doo' ); ?> <?php comment_author_link(); ?>
        <?php edit_comment_link( esc_html__( '(Edit)', 'doo' ), '<div class="comment-meta"><span class="edit-link">', '</span></div>' ); ?>
      </div>
  <?php
    }else{  
  ?>
    <li id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?>>
      <div id="div-comment-<?php comment_ID(); ?>" class="comment-body clearfix">
              <div class="comment-author">
          <div class="comment-avatar"><?php echo get_avatar( $comment, 40 ); ?></div>
                  <div class="fn"><?php echo get_comment_author_link();?></div>
                  
                  <div class="comment-meta clearfix">            
                      <span class="comment-metadata"><time datetime="<?php comment_time( 'c' ); ?>"><?php printf( esc_html_x( '%1$s at %2$s', '1: date, 2: time', 'doo' ), get_comment_date(), get_comment_time() ); ?></time></span>
                      <?php edit_comment_link( esc_html__( '(Edit)', 'doo' ), '<span class="edit-link">', '</span>' ); ?>
      
                      <?php if ( '0' == $comment->comment_approved ) : ?>
                      <p class="comment-awaiting-moderation"><?php echo esc_html__( 'Your comment is awaiting moderation.', 'doo' ); ?></p>
                      <?php endif; ?>
                  </div>
              </div>
              
              <div class="comment_wrap">     
                <div class="comment-content clearfix"><?php comment_text();?></div>
              </div>
              
              <div class="reply"><?php comment_reply_link( array_merge( $args, array('add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></div>
      </div>
  <?php 
    }
  }
}

if ( ! function_exists( 'vs_comment_form_default_fields' ) ) {
  /**
   * Custom default fields
   */
  function vs_comment_form_default_fields( $fields ) {
    $req = get_option( 'require_name_email' );
    $commenter = wp_get_current_commenter();
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $fields['author'] = '<div class="comment-item"><input id="author" type="text" aria-required="true" size="22" value="' . esc_attr($commenter['comment_author']) . '" name="author" ' . $aria_req . ' placeholder="' . esc_attr__('Name','doo') . ' ' . ($req?'*':'') . '" /></div>';
    $fields['email'] = '<div class="comment-item"><input id="email" type="text" aria-required="true" size="22" value="' . esc_attr($commenter['comment_author_email']) . '" name="email" ' . $aria_req . ' placeholder="' . esc_attr__('Email','doo') . ' ' . ($req?'*':'') . '" /></div>';
    $fields['url'] = '<div class="comment-item"><input id="url" type="text" aria-required="true" size="22" value="' . esc_url($commenter['comment_author_url']) . '" name="url" placeholder="' . esc_attr__('Website','doo') . '" /></div>';
    return $fields;
  }
}
add_filter( 'comment_form_default_fields', 'vs_comment_form_default_fields' );

if ( ! function_exists( 'vs_comment_form_field_comment' ) ) {
  /**
   * Custom fields comment
   */
  function vs_comment_form_field_comment( $comment_field ) {
    $req = get_option( 'require_name_email' );
    $comment_field = '<div class="comment-item"><textarea id="comment" name="comment" placeholder="' . esc_attr__('Comment','doo') . ' ' . ($req?'*':'') . '" /></textarea></div>';
    return $comment_field;
  }
}
add_filter( 'comment_form_field_comment', 'vs_comment_form_field_comment' );

if ( ! function_exists( 'vs_move_comment_form_field' ) ) {
  /**
   * Move comment form field
   */
  function vs_move_comment_form_field( $field ) {
    $field_cookies = $field['cookies'];
    $field_comment = $field['comment'];
    unset( $field['cookies'] );
    unset( $field['comment'] );
    $field['comment'] = $field_comment;
    $field['cookies'] = $field_cookies;
    return $field;
  }
}
add_filter( 'comment_form_fields', 'vs_move_comment_form_field' );
