<?php
/**
 * Post Meta Helper Functions
 *
 * @package Doo
 */

if ( ! function_exists( 'vs_get_meta_categorys' ) ) {
  /**
   * Сategory
   */
  function vs_get_meta_categorys() {

    $category_list = get_the_category_list(' ');
    if ( $category_list ) {
      ?>
      <span class="meta-category"><?php echo $category_list; ?></span>
      <?php
    }
  }
}

if ( ! function_exists( 'vs_get_meta_date' ) ) {
  /**
   * Date
   */
  function vs_get_meta_date() {

    ?>
    <span class="meta-date"><?php echo get_the_date(); ?></span>
    <?php
  }
}

if ( ! function_exists( 'vs_get_meta_author' ) ) {
  /**
   * Author
   */
  function vs_get_meta_author() {

    ?>
    <span class="meta-author"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
    <?php
  }
}

if ( ! function_exists( 'vs_get_meta_comments' ) ) {
  /**
   * Comments
   */
  function vs_get_meta_comments() {

    if ( ! comments_open() ) {
      return;
    }
    ?>
    <span class="meta-comments"><?php comments_popup_link( esc_html__( 'No Comments', 'doo' ), esc_html__( '1 Comment', 'doo' ), '% ' . esc_html__( 'Comments', 'doo' ), 'comments-link', '' ); ?></span>
    <?php
  }
}

if ( ! function_exists( 'vs_get_meta_tags' ) ) {
  /**
   * Tags
   */
  function vs_get_meta_tags() {

    $tags_list = get_the_tag_list();
    if ( $tags_list ) {
      ?>
      <span class="meta-tags"><?php echo $tags_list; ?></span>
      <?php
    }
  }
}

if ( ! function_exists( 'vs_get_meta_post_views' ) ) {
  /**
   * Post Views
   */
  function vs_get_meta_post_views() {

    // Post Views Counter.
    if ( ! class_exists( 'Post_Views_Counter' ) ) {
      return;
    }

    $views = pvc_get_post_views();

    // Don't display if minimum threshold is not met.
    if ( $views < apply_filters( 'vs_minimum_views', 1 ) ) {
      return;
    }
    ?>
    <span class="meta-post-views"><?php
    if ( $views > 1000 ) {
      $views_rounded = vs_get_round_number( $views );
      echo $views_rounded . ' ' . esc_html__( 'views', 'doo' );
    } else {
      /* translators: %s number of post views */
      echo esc_html( sprintf( _n( '%s view', '%s views', $views, 'doo' ), $views ) );
    }
    ?></span>
    <?php
  }
}

if ( ! function_exists( 'vs_get_meta_reading_time' ) ) {
  /**
   * Reading Time
   */
  function vs_get_meta_reading_time() {

    $reading_time = vs_get_post_reading_time();
    ?>
    <span class="meta-reading-time"><?php echo esc_html( sprintf( _n( '%s minute read', '%s minute read', $reading_time, 'doo' ), $reading_time ) ); ?></span>
    <?php
  }
}
