<?php
/**
 * These functions are used to load template parts (partials) or actions when used within action hooks
 *
 * @package Doo
 */

if ( ! function_exists( 'vs_header_offcanvas_button' ) ) {
  /**
   * Header Offcanvas Button
   */
  function vs_header_offcanvas_button() {
    ?>
    <a class="navbar-toggle-offcanvas toggle-offcanvas" href="javascript:void(0)">
      <i class="vs-icon vs-icon-bars"></i>
    </a>
    <?php
  }
}

if ( ! function_exists( 'vs_header_logo' ) ) {
  /**
   * Header Logo
   */
  function vs_header_logo() {
    ?>
    <div class="site-branding-logo <?php if (get_theme_mod( 'header_title' )){?>only-logo<?php }?>">
      <?php the_custom_logo();?>

      <?php if ( !get_theme_mod( 'header_title' )):?>
        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
      <?php endif;?>

      <?php
      $description = get_bloginfo( 'description', 'display' );
      if ( $description || is_customize_preview() ) : ?>
        <p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
      <?php endif; ?>
    </div>
    <?php
  }
}

if ( ! function_exists( 'vs_navbar_nav_menu' ) ) {
  /**
   * Navbar Nav Menu
   */
  function vs_navbar_nav_menu() {
    if ( has_nav_menu( 'primary' ) ) {
      wp_nav_menu( array(
        'menu_class'      => 'navbar-nav',
        'theme_location'  => 'primary',
        'container'       => '',
        'container_class' => '',
      ) );
    }
  }
}

if ( ! function_exists( 'vs_scroll_to_top' ) ) {
  /**
   * Scroll To Top
   */
  function vs_scroll_to_top() {
    $misc_scroll_to_top = get_theme_mod( 'misc_scroll_to_top', 1 );
    if ( 1 === $misc_scroll_to_top ) {
      ?>
      <a href="#top" class="vs-scroll-to-top">
        <i class="vs-icon vs-icon-chevron-up"></i>
      </a>
      <?php
    }
  }
}

if ( ! function_exists( 'vs_offcanvas' ) ) {
  /**
   * Off-canvas
   */
  function vs_offcanvas() {
    get_template_part( 'template-parts/offcanvas' );
  }
}

if ( ! function_exists( 'vs_single_author' ) ) {
  /**
   * Single Author
   */
  function vs_single_author() {
    if ( ! is_singular( 'post' ) ) {
      return;
    }
    if ( get_theme_mod( 'post_about_author', 0 ) ) {
      get_template_part( 'template-parts/post-author' );
    }
  }
}

if ( ! function_exists( 'vs_single_prev_nex' ) ) {
  /**
   * Single Prev Next
   */
  function vs_single_prev_nex() {
    if ( ! is_singular( 'post' ) ) {
      return;
    }
    if ( get_theme_mod( 'post_prev_next', 1 ) ) {
      get_template_part( 'template-parts/post-prev-next' );
    }
  }
}

if ( ! function_exists( 'vs_comments' ) ) {
  /**
   * Comments
   */
  function vs_comments() {
    if ( post_password_required() ) {
      return;
    }
    if ( comments_open() || get_comments_number() ) {
      comments_template();
    }
  }
}
