<?php
/**
 * All enqueues of scripts and styles.
 *
 * @package Doo
 */

if ( ! function_exists( 'vs_content_width' ) ) {
  /**
   * Set the content width in pixels, based on the theme's design and stylesheet.
   *
   * Priority 0 to make it available to lower priority callbacks.
   *
   * @global int $content_width
   */
  function vs_content_width() {

    $GLOBALS['content_width'] = apply_filters( 'vs_content_width', 690 );
  }
}
add_action( 'after_setup_theme', 'vs_content_width', 0 );

if ( ! function_exists( 'vs_editor_style' ) ) {
  /**
   * Add callback for custom editor stylesheets
   */
  function vs_editor_style() {

    // Add support for editor styles.
    add_theme_support( 'editor-styles' );

    // Enqueue editor styles.
    add_editor_style( 'assets/css/editor-style.css' );
  }
}
add_action( 'current_screen', 'vs_editor_style' );

if ( ! function_exists( 'vs_enqueue_scripts' ) ) {
  /**
   * Enqueue scripts and styles.
   */
  function vs_enqueue_scripts() {

    $version = vs_get_theme_data( 'Version' );
    
    // Register vendor scripts.
    wp_register_script( 'object-fit-images', get_template_directory_uri() . '/assets/js/ofi.min.js', array(), '3.2.4', true );
    
    // Register theme scripts.
    wp_register_script( 'vs-scripts', get_template_directory_uri() . '/assets/js/theme.js', array(
      'jquery',
      'object-fit-images',
    ), $version, true );

    // Enqueue theme scripts.
    wp_enqueue_script( 'vs-scripts' );

    // Enqueue comment reply script.
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

    // Register theme styles.
    wp_register_style( 'vs-styles', get_template_directory_uri() . '/style.css', array(), $version );

    // Enqueue theme styles.
    wp_enqueue_style( 'vs-styles' );
  }
}
add_action( 'wp_enqueue_scripts', 'vs_enqueue_scripts' );
