<?php
/**
 * The template for displaying comments
 *
 * @package Doo
 */

?>
<div id="comments" class="post-comments">
  <?php

  if ( have_comments() ) { ?>
    <h5 class="comments-title">
      <?php
      $comment_count = get_comments_number();
      if ( 1 === $comment_count ) {
        printf(

          esc_html_e( 'One thought on &ldquo;%1$s&rdquo;', 'doo' ),
          '<span>' . get_the_title() . '</span>'
        );
      } else {
        printf(

          esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $comment_count, 'comments title', 'doo' ) ),
          number_format_i18n( $comment_count ),
          '<span>' . get_the_title() . '</span>'
        );
      }
      ?>
    </h5>

    <ol class="comment-list">
      <?php
        wp_list_comments( array(
          'callback'=>'vs_list_comments'
        ) );
      ?>
    </ol>

    <?php the_comments_navigation(); ?>

    <?php
    if ( ! comments_open() ) : ?>
      <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'doo' ); ?></p>
    <?php
    endif;

  }
  ?>
</div>
<?php
comment_form(
  array(
    'title_reply_before' => '<h5 id="reply-title" class="comment-reply-title">',
    'title_reply_after'  => '</h5>',
    'comment_notes_before'    => '',
    'comment_notes_after'     => '',
  )
);
?>
