<?php

/**
 * search-excerpt.php
 *
 **/

 documentaire_check_direct();

?>

  <div <?php post_class(); ?>>

    <h2><a href="<?php echo esc_url( get_the_permalink() ); ?>" ' title="<?php esc_attr_e( 'See in full', 'documentaire' ); ?>"><?php the_title(); ?></a><br><?php edit_post_link(); ?></h2>

    <?php if( esc_html( get_post_type() ) !== "page" ): ?>
    <p><?php _e('Posted on','documentaire'); ?>
      <?php
      $documentaire_post_date = date_i18n( get_option( 'date_format' ), get_the_date( 'U' ) );
      echo $documentaire_post_date;
      ?>
      <?php _e('by','documentaire'); ?>
    <?php
      $documentaire_author_url = esc_url( get_the_author_meta('url') );
      $documentaire_author_name = esc_html( get_the_author() );
      if( !empty( $documentaire_author_url ) ) {
        echo '<a href="' . esc_html( $documentaire_author_url ) . '" title="' . esc_attr( $documentaire_author_name ) . '\'s ' . esc_attr__( 'homepage', 'documentaire' ) . '">';
        echo esc_html( $documentaire_author_name );
        echo '</a>';
      } else {
        echo esc_html( $documentaire_author_name );
      }
    ?>
    <?php endif ;?>
    </p>

    <?php the_excerpt(); ?>
</p>

</div>
