<?php

/**
 * functions.php
 *
 **/

include( get_template_directory() . '/includes/functions-documentaire-check-direct.php');

documentaire_check_direct();

if ( ! function_exists( 'documentaire_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 */
function documentaire_setup() {
	/*
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'documentaire' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for custom logo.
	 *
	 */
	add_theme_support( 'custom-logo', array(
		'height'      => 300,
		'width'       => 300,
		'flex-height' => true,
	) );

  $defaults = array(
    'default-image'          => '',
    'width'                  => 0,
    'height'                 => 0,
    'flex-height'            => false,
    'flex-width'             => false,
    'uploads'                => true,
    'random-default'         => false,
    'header-text'            => true,
    'default-text-color'     => '',
    'wp-head-callback'       => '',
    'admin-head-callback'    => '',
    'admin-preview-callback' => '',
  );
  add_theme_support( 'custom-header', $defaults );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 */
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 1200, 9999 );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'documentaire' )
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
   *
	 */
	add_theme_support( 'html5', array(
		'gallery',
		'caption',
	) );

	// Indicate widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );
}
endif; // documentaire_setup
add_action( 'after_setup_theme', 'documentaire_setup' );

/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 */
function documentaire_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'documentaire_content_width', 1600 );
}
add_action( 'after_setup_theme', 'documentaire_content_width', 0 );

/**
 * Enqueues scripts and styles.
 *
 */
function documentaire_comments() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'documentaire_comments' );

function documentaire_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Content Bottom 1', 'documentaire' ),
		'id'            => 'documentaire-sidebar-2',
		'description'   => __( 'Appears at the bottom of the content on posts and pages.', 'documentaire' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Content Bottom 2', 'documentaire' ),
		'id'            => 'documentaire-sidebar-3',
		'description'   => __( 'Appears at the bottom of the content on posts and pages.', 'documentaire' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'documentaire_widgets_init' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function documentaire_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="'.get_bloginfo( 'pingback_url' ).'">';
	}
}
add_action( 'wp_head', 'documentaire_pingback_header' );

/**
 * Enqueue scripts and styles.
 */
function documentaire_scripts() {

	// Bootstrap 3 Stylesheet
	wp_enqueue_style( 'bootstrap' , get_theme_file_uri( '/css/bootstrap.min.css' ) );

  // JQuery JavaScript
  wp_enqueue_script( 'jquery' );

  // Bootstrap 3 JavaScript
  wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/js/bootstrap.min.js' ), array(), '1.0', true );

  // Google Fonts
  	// Add custom fonts
	wp_enqueue_style( 'documentaire-google-fonts', documentaire_fonts_url(), array(), null );

	// Theme Stylesheet
	wp_enqueue_style( 'documentaire-main-style', get_stylesheet_uri() );

}
add_action( 'wp_enqueue_scripts', 'documentaire_scripts' );

/**
 * Register Google fonts
 */

function documentaire_fonts_url() {
	$fonts_url = '';

  $font_families = array('Merriweather','Open Sans');

  $query_args = array(
    'family' => urlencode( implode( '|', $font_families ) ),
    'subset' => urlencode( 'latin,latin-ext' ),
  );

  $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

	return esc_url_raw( $fonts_url );
}

?>
