<?php

/**
 * content-single.php
 *
 **/

 documentaire_check_direct();

?>

<section id="a-post" <?php post_class(); ?>>

  <h2><span class="biggest"><?php the_title(); ?></span><br><?php edit_post_link(); ?></h2>

  <p><?php _e('Posted on','documentaire'); ?>
  <?php
    $documentaire_post_date = date_i18n( get_option( 'date_format' ) , get_the_date( 'U' ) );
    echo $documentaire_post_date;
  ?> <?php _e('by','documentaire'); ?> <?php esc_url( the_author_link() ); ?>
  </p>

  <?php
    $documentaire_thumbnail = esc_url( get_the_post_thumbnail_url() );
    $documentaire_thumbnail_id = get_post_thumbnail_id( $post->ID );
    $documentaire_alt_text = get_post_meta( $documentaire_thumbnail_id, '_wp_attachment_image_alt', true );
    if( !empty( $documentaire_thumbnail ) ) {
       if( !empty( $documentaire_alt_text )){
         $documentaire_alt_text = $documentaire_alt_text;
       } else {
         $documentaire_alt_text = esc_html( the_title() );
       }
      echo '<img id="content-featured-image" src="'.esc_url( get_the_post_thumbnail_url() ).'" alt="'.esc_attr( $documentaire_alt_text ).'" class="aligncenter img-r" />';
      }
  ?>

  <?php the_content(); ?>


  <?php
    $documentaire_categories = get_categories();
    if( !empty( $documentaire_categories ) ) {
      echo '<p>';
      foreach ( $documentaire_categories as $documentaire_category ) {
        // Only print the title if there are tags
        if( $documentaire_cat_count == 0 ) {
          echo '<h3>';
          _e( 'Categorized As', 'documentaire' );
          echo '</h3><p>';
        }
        if ( $documentaire_cat_count != 0 ) {
          echo ', ';
        }

        echo '<a href="' . esc_url( get_category_link( $documentaire_category->term_id ) ) .'" title="'.esc_attr( $documentaire_category->name ).' '.esc_attr__('archive','documentaire').'" >' . esc_html( $documentaire_category->name ) . '</a>';

          $documentaire_cat_count++;
      }
      echo '</p>';
    }
  ?>

  <?php
      $documentaire_tags = get_the_tags();
      $documentaire_tag_count = 0;
      if( !empty( $documentaire_tags ) ) {
        echo '<p>';
        foreach( $documentaire_tags as $tag ) {

          if( $documentaire_tag_count == 0 ) {
            echo '<h3>';
            _e( 'Tagged', 'documentaire' );
            echo '</h3><p>';
          }

          if ( $documentaire_tag_count != 0 ) {
            echo ', ';
          }

          echo '<a href="' . esc_url( get_tag_link( $tag->term_id ) ) . '" title="'.esc_attr( $tag->name ).' '.esc_attr__('archive','documentaire').'" >' . esc_html( $tag->name ) . '</a>';

          $documentaire_tag_count++;
        }
      echo '</p>';
      }
    ?>
</section>
