<?php

/**
 * comments.php
 *
 **/

 documentaire_check_direct();

?>

<?php
if ( post_password_required() )
    return;
?>

<div id="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>
        <h3><?php _e( 'Comments', 'documentaire' ); ?></h3>

        <ol class="comment-list">
            <?php
                wp_list_comments( array(
                    'style'       => 'ul',
                    'short_ping'  => true,
                    'avatar_size' => 74,
                ) );
            ?>
        </ol>

        <?php
          if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
        ?>
        <nav class="navigation comment-navigation" role="navigation">
            <h1 class="sr-only section-heading"><?php _e( 'Comment navigation', 'documentaire' ); ?></h1>
            <div class="nav-previous"><?php previous_comments_link( '&larr; '.__( 'Older Comments', 'documentaire' ) ); ?></div>
            <div class="nav-next"><?php next_comments_link( __( 'Newer Comments', 'documentaire' ).' &rarr;' ); ?></div>
        </nav>
        <?php endif; ?>

        <?php if ( ! comments_open() && get_comments_number() ) : ?>
          <?php
            echo '<p>';
            _e( 'Comments are closed at this time.', 'documentaire' );
            echo '</p>';
          ?>
        <?php endif; ?>

    <?php endif; ?>

    <?php
    $args = array('comment_field' => '<p><label for="comment" class="sr-only">'.__( 'Your Comments', 'documentaire' ).'</label>
    <textarea id="comment" name="comment" class="form-control" aria-required="true" rows="6" placeholder="'.esc_attr__( 'Your Comments', 'documentaire' ).'"></textarea></p>',
    'fields' => apply_filters( 'comment_form_default_fields',
    array( 'author' => '<p><label for="author" class="sr-only">'.__( 'Your Name', 'documentaire' ).'</label>
    <input id="author" name="author"  class="form-control" type="text" value="'.esc_attr( $commenter['comment_author'] ).'" placeholder="'.esc_attr__( 'Your Name', 'documentaire' ).'" /></p>',
    'email' => '<p><label for="email" class="sr-only">'.__( 'Your Email', 'documentaire' ).'</label><input id="email" name="email"  class="form-control" type="text" value="'. esc_attr(  $commenter['comment_author_email'] ).'" placeholder="'.esc_attr__( 'Your Email', 'documentaire' ).'" /></p>', 'url' => '<p><label for="url" class="sr-only">'.__( 'Your Website Address', 'documentaire' ).'</label><input id="url" name="url" type="text"  class="form-control" value="'.esc_attr( $commenter['comment_author_url'] ).'" placeholder="'.esc_attr__( 'Your Website', 'documentaire' ).'" /></p>')),'class_submit' => 'btn btn-default');
    comment_form( $args );
  ?>

</div>
