<?php
ob_start();
include_once get_template_directory() . '/admin/customizer.php';
require_once( trailingslashit( get_template_directory() ) . 'trt-customizer-pro/discover/class-customize.php' );

//get the theme option from options array
function themeszen_get_option($name, $default = '') {
//    echo $default;
    $options = get_option('themeszen_options');
    if (isset($options[$name]) && $options[$name] != '') {
        return $options[$name];
    } elseif ($default) {
        if (themeszen_get_option('discover_dummy_data') == 'on') {
            return $default;
        }
    } else {
        return false;
    }
}

// Save all option in single array
function themeszen_save_option($option) {
    if (!empty($option)) {
        return update_option('themeszen_options', $option);
    }
}

//update theme option
function themeszen_update_option($name, $value) {
    $options = get_option('themeszen_options');
    $options[$name] = $value;
    return update_option('themeszen_options', $options);
}

//delete theme option
function themeszen_delete_option($name) {
    $options = get_option('themeszen_options');
    unset($options[$name]);
    return update_option('themeszen_options', $options);
}

/** Tell WordPress to run discover_setup() when the 'after_setup_theme' hook is run. */
add_action( 'after_setup_theme', 'discover_setup' );

if ( ! function_exists( 'discover_setup' ) ):

function discover_setup() {

	 global $content_width;
	 
     if (!isset($content_width))
            $content_width = 620;

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );
	
	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );	
	add_theme_support('title-tag');
	add_editor_style();
	
	// Add support for custom backgrounds
	$args = array(
	'default-color' => 'ffffff',
	'wp-head-callback' => '_custom_background_cb'
);
add_theme_support( 'custom-background', $args );

	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'discover', get_template_directory() . '/languages' );
		
	// This theme uses wp_nav_menu() in two location.	
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'discover' ),
	) );
	
	// Add support for woocommerce
	$template = get_option( 'template' );
	update_option( 'woocommerce_theme_support_check', $template );
	add_theme_support( 'woocommerce' );	

}
endif;
?>
<?php
/**
 * Setup the WordPress core custom header feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for previous versions.
 * Use feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 *
 * @todo Rework this function to remove WordPress 3.4 support when WordPress 3.6 is released.
 *
 * @uses discover_s_header_style()
 * @uses discover_s_admin_header_style()
 * @uses discover_s_admin_header_image()
 *
 * @package discover_s
 */
function discover_custom_header_setup() {
	$args = array(
		'default-image'          => '',
		'default-text-color'     => 'fd7800',
		'width'                  => 220,
		'height'                 => 75,
		'flex-height'            => true,
		'wp-head-callback'       => '',
		'admin-head-callback'    => '',
		'admin-preview-callback' => '',
	);

	$args = apply_filters( 'discover_custom_header_args', $args );
	add_theme_support( 'custom-header', $args );

}
add_action( 'after_setup_theme', 'discover_custom_header_setup' );

?>
<?php
function discover_list_pings($comment, $args, $depth) { 
	$GLOBALS['comment'] = $comment; ?>
	<li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php } ?>
<?php
add_filter('get_comments_number', 'discover_comment_count', 0);
function discover_comment_count( $count ) {
	if ( ! is_admin() ) {
	global $id;
	$get_comments_status= get_comments('status=approve&post_id=' . $id);
	$comments_by_type = separate_comments($get_comments_status);
	return count($comments_by_type['comment']);
} else {
return $count;
}
}
?>
<?php
if ( ! function_exists( 'discover_comment_callback' ) ) :
function discover_comment_callback( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo get_avatar( $comment, 40 ); ?>
			<?php printf( __( '%s', 'discover' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em><?php _e( 'Your comment is awaiting moderation.', 'discover' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'discover' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'discover' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'discover' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __('(Edit)', 'discover'), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;

/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override discover_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 */
function discover_widgets_init() {
	// Area 1, located at the top of the sidebar.
	register_sidebar( array(
		'name' => __( 'Primary Widget Area', 'discover' ),
		'id' => 'primary-widget-area',
		'description' => __( 'The primary widget area', 'discover' ),
		'before_widget' => '<div id="%1$s" class="widget-container-primary %2$s">',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	) );
	
	// Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', 'discover' ),
		'id' => 'first-footer-widget-area',
		'description' => __( 'The first footer widget area', 'discover' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Second Footer Widget Area', 'discover' ),
		'id' => 'second-footer-widget-area',
		'description' => __( 'The second footer widget area', 'discover' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Third Footer Widget Area', 'discover' ),
		'id' => 'third-footer-widget-area',
		'description' => __( 'The third footer widget area', 'discover' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

}
if ( ! function_exists( 'discover_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 * Create your own discover_posted_on to override in a child theme
 *
 * @since Twenty Eleven 1.0
 */
function discover_posted_on() {
	printf( __( '<span class="sep">Posted on </span><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a><span class="by-author"> <span class="sep"> by </span> <span class="author vcard"><a class="url fn n" href="%5$s" title="%6$s" rel="author">%7$s</a></span></span>', 'discover' ),
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_attr( sprintf( __( 'View all posts by %s', 'discover' ), get_the_author() ) ),
		get_the_author()
	);
}
endif;
/** Register sidebars by running discover_widgets_init() on the widgets_init hook. */
add_action( 'widgets_init', 'discover_widgets_init' );

/** Excerpt */
function discover_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'discover_excerpt_length' );

function discover_auto_excerpt_more( $more ) {
	return ' &hellip;' ;
}
add_filter( 'excerpt_more', 'discover_auto_excerpt_more' );


/** filter function for wp_title */
function discover_filter_wp_title( $old_title, $sep, $sep_location ){
 
// add padding to the sep
$ssep = ' ' . $sep . ' ';
 
// find the type of index page this is
if( is_category() ) $insert = $ssep . 'Category';
elseif( is_tag() ) $insert = $ssep . 'Tag';
elseif( is_author() ) $insert = $ssep . 'Author';
elseif( is_year() || is_month() || is_day() ) $insert = $ssep . 'Archives';
else $insert = NULL;
 
// get the page number we're on (index)
if( get_query_var( 'paged' ) )
$num = $ssep . 'page ' . get_query_var( 'paged' );
 
// get the page number we're on (multipage post)
elseif( get_query_var( 'page' ) )
$num = $ssep . 'page ' . get_query_var( 'page' );
 
// else
else $num = NULL;
 
// concoct and return new title
return get_bloginfo( 'name' ) . $insert . $old_title . $num;
}

// call our custom wp_title filter, with normal (10) priority, and 3 args
add_filter( 'wp_title', 'discover_filter_wp_title', 10, 3 );

// custom function

function discover_page_menu_args( $args ) {
$args['show_home'] = true;
return $args;
}
add_filter( 'wp_page_menu_args', 'discover_page_menu_args' );

// custom function
/*-----------------------------------------------------------------------------------*/
/* Exclude categories from displaying on the "Blog" page template.
/*-----------------------------------------------------------------------------------*/

// Exclude categories on the "Blog" page template.
add_filter( 'discover_blog_template_query_args', 'discover_exclude_categories_blogtemplate' );

function discover_exclude_categories_blogtemplate ( $args ) {

	if ( ! function_exists( 'discover_prepare_category_ids_from_option' ) ) { return $args; }

	$excluded_cats = array();

	// Process the category data and convert all categories to IDs.
	$excluded_cats = discover_prepare_category_ids_from_option( 'exclude_cat' );


	if ( count( $excluded_cats ) > 0 ) {

		// Setup the categories as a string, because "category__not_in" doesn't seem to work
		// when using query_posts().

		foreach ( $excluded_cats as $k => $v ) { $excluded_cats[$k] = '-' . $v; }
		$cats = join( ',', $excluded_cats );

		$args['cat'] = $cats;
	}

	return $args;

}

/*-----------------------------------------------------------------------------------*/
/* discover_prepare_category_ids_from_option()
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'discover_prepare_category_ids_from_option' ) ) {

	function discover_prepare_category_ids_from_option ( $option ) {

		$cats = array();

		$stored_cats = themeszen_get_option( $option );

		$cats_raw = explode( ',', $stored_cats );

		if ( is_array( $cats_raw ) && ( count( $cats_raw ) > 0 ) ) {
			foreach ( $cats_raw as $k => $v ) {
				$value = trim( $v );

				if ( is_numeric( $value ) ) {
					$cats_raw[$k] = $value;
				} else {
					$cat_obj = get_category_by_slug( $value );
					if ( isset( $cat_obj->term_id ) ) {
						$cats_raw[$k] = $cat_obj->term_id;
					}
				}

				$cats = $cats_raw;
			}
		}

		return $cats;

	}

}

function discover_date_on() {
	printf( __( '<span class="%1$s">Posted on</span> %2$s', 'discover' ),
		'meta-prep meta-prep-author',
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span></a>',
			get_permalink(),
			esc_attr( get_the_time() ),
			get_the_date()
		)
	);
}

function discover_of_register_js() {
	if (!is_admin()) {
		
		wp_register_script('superfish', get_template_directory_uri() . '/js/superfish.js', 'jquery', '1.0', TRUE);
		wp_register_script('discover_custom', get_template_directory_uri() . '/js/jquery.custom.js', 'jquery', '1.0', TRUE);
		wp_register_script('fitvids', get_template_directory_uri() . '/js/jquery.fitvids.js', 'jquery', '1.0', TRUE);
		wp_register_script('selectnav', get_template_directory_uri() . '/js/selectnav.js', 'jquery', '0.1', TRUE);
		wp_register_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider.js', 'jquery', '2.1', TRUE);
		wp_register_script('modernizr', get_template_directory_uri() . '/js/modernizr.js', 'jquery', '2.6.1', false);
		
		wp_enqueue_script('jquery');
		wp_enqueue_script('superfish');
		wp_enqueue_script('discover_custom');
		wp_enqueue_script('fitvids');
		wp_enqueue_script('flexslider');		
		wp_enqueue_script('selectnav');
		wp_enqueue_script('modernizr');
	}
}
add_action('init', 'discover_of_register_js');

function discover_of_single_scripts() {
	if(is_singular()) wp_enqueue_script( 'comment-reply' ); // loads the javascript required for threaded comments 
}
add_action('wp_print_scripts', 'discover_of_single_scripts');

function discover_of_styles() {
		wp_register_style( 'superfish', get_template_directory_uri() . '/css/superfish.css' );
		wp_register_style( 'flexslider', get_template_directory_uri() . '/css/flexslider.css' );
		wp_register_style( 'foundation', get_template_directory_uri() . '/css/foundation.css' );

		
		wp_enqueue_style( 'superfish' );
		wp_enqueue_style( 'flexslider' );		
		wp_enqueue_style( 'foundation' );		
		
}
add_action('wp_print_styles', 'discover_of_styles');

// WooCommerce

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

add_action('woocommerce_before_main_content', 'discover_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'discover_wrapper_end', 10);

function discover_wrapper_start() {
  echo '	<div id="subhead_container">
		<div class="row">
		<div class="twelve columns">
		<h1><?php the_title(); ?>
  </h1>
  </div>
  </div>
  </div>
  <!--content-->
  <div class="row" id="content_container"> 
    <!--left col-->
    <div class="eight columns">
      <div id="left-col">
        <div class="post-entry">';
}
          
function discover_wrapper_end() {
          echo '
          <div class="clear"></div>
          ';
          wp_link_pages( array( 'before' => '' . __( 'Pages:', 'discover' ), 'after' => '' ) );
          echo ' </div>
        <!--post-entry end--> 
      </div>
      <!--left-col end--> 
    </div>
    <!--column end-->';
    get_sidebar();
    echo '</div>
  <!--content end-->';
}

function discover_tracking_admin_notice() {
    global $current_user;
    $user_id = $current_user->ID;
    /* Check that the user hasn't already clicked to ignore the message */
    if (!get_user_meta($user_id, 'wp_tracking_ignore_notice')) {
        ?>
        <div class="updated um-admin-notice"><p><?php _e('Theme options are moved to Appearance - Customize as per theme guidelines.', 'discover'); ?></p></div>
        <?php
    }
}

add_action('admin_notices', 'discover_tracking_admin_notice');

ob_clean();
?>