<?php
/**
 * Default theme options.
 *
 * @package Digital Diary
 */

if ( ! function_exists( 'digital_diary_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function digital_diary_get_default_theme_options() {

	$defaults = array();

	// Top Bar
	$defaults['show_header_contact_info'] 				= false;
    $defaults['show_header_social_links'] 				= false;
    $defaults['header_social_links']					= array();

    // Front Page Content
	$defaults['enable_frontpage_content'] 				= false;

	// Slider Section	
	$defaults['enable_featured_slider_section']		    = false;
	$defaults['number_of_featured_slider_items']	    = 3;
	$defaults['featured_slider_content_type']		    = 'featured_slider_post';

	// Latest Posts Section
	$defaults['enable_latest_posts_section']			= false;
	$defaults['latest_posts_section_title']	    		= esc_html__( 'Latest Articles', 'digital-diary' );
	$defaults['latest_posts_category']	   	    		= 0; 
	$defaults['latest_posts_number']					= 9;
	$defaults['latest_posts_column']					= 'col-3';

	// Theme Options
	$defaults['show_header_image']		    			= 'header-image-enable';
	$defaults['show_page_title']		    			= 'page-title-enable';
	$defaults['layout_options_blog']					= 'no-sidebar';
	$defaults['layout_options_archive']					= 'no-sidebar';
	$defaults['layout_options_page']					= 'no-sidebar';	
	$defaults['layout_options_single']					= 'right-sidebar';	
	$defaults['excerpt_length']							= 25;
	$defaults['your_latest_posts_title']				= esc_html__('Blog','digital-diary');

	//Footer section 		
	$defaults['copyright_text']							= esc_html__( 'Copyright &copy; All rights reserved.', 'digital-diary' );

	// Pass through filter.
	$defaults = apply_filters( 'digital_diary_filter_default_theme_options', $defaults );
	return $defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'digital_diary_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function digital_diary_get_option( $key ) {

		$default_options = digital_diary_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;